/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.List;
import org.gnu.glib.Error;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.gtk.FileChooserException;
import org.gnu.gtk.event.FileChooserEvent;
import org.gnu.gtk.event.FileChooserListener;

class FileChooserHelper {
    static boolean setFilename(Handle handle, String string) {
        if (string == null) {
            throw new RuntimeException("filename must not be null");
        }
        return FileChooserHelper.gtk_file_chooser_set_filename(handle, string);
    }

    static void addShortcutFolder(Handle handle, String string) throws FileChooserException {
        Handle handle2 = FileChooserHelper.gtk_file_chooser_add_shortcut_folder(handle, string);
        if (handle2 != null) {
            Error error = new Error(handle2);
            throw new FileChooserException(error.getErrorCode());
        }
    }

    static void removeShortcutFolder(Handle handle, String string) throws FileChooserException {
        Handle handle2 = FileChooserHelper.gtk_file_chooser_remove_shortcut_folder(handle, string);
        if (handle2 != null) {
            Error error = new Error(handle2);
            throw new FileChooserException(error.getErrorCode());
        }
    }

    static void addShortcutURI(Handle handle, String string) throws FileChooserException {
        Handle handle2 = FileChooserHelper.gtk_file_chooser_add_shortcut_folder_uri(handle, string);
        if (handle2 != null) {
            Error error = new Error(handle2);
            throw new FileChooserException(error.getErrorCode());
        }
    }

    static void removeShortcutURI(Handle handle, String string) throws FileChooserException {
        Handle handle2 = FileChooserHelper.gtk_file_chooser_remove_shortcut_folder_uri(handle, string);
        if (handle2 != null) {
            Error error = new Error(handle2);
            throw new FileChooserException(error.getErrorCode());
        }
    }

    static void fireCurrentFolderChanged(List list, FileChooserEvent fileChooserEvent) {
        if (list == null) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ((FileChooserListener)list.get(i)).currentFolderChanged(fileChooserEvent);
        }
    }

    static void fireFileActivated(List list, FileChooserEvent fileChooserEvent) {
        if (list == null) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ((FileChooserListener)list.get(i)).fileActivated(fileChooserEvent);
        }
    }

    static void fireSelectionChanged(List list, FileChooserEvent fileChooserEvent) {
        if (list == null) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ((FileChooserListener)list.get(i)).selectionChanged(fileChooserEvent);
        }
    }

    static void fireUpdatePreview(List list, FileChooserEvent fileChooserEvent) {
        if (list == null) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ((FileChooserListener)list.get(i)).updatePreview(fileChooserEvent);
        }
    }

    static void addListener(List list, FileChooserListener fileChooserListener, EventMap eventMap, GObject gObject) {
        if (list.size() == 0) {
            FileChooserEvent.Type[] typeArray = FileChooserEvent.Type.getTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                eventMap.initialize(gObject, (EventType)typeArray[i]);
            }
        } else if (list.contains(fileChooserListener)) {
            return;
        }
        list.add(fileChooserListener);
    }

    static void removeListener(List list, FileChooserListener fileChooserListener, EventMap eventMap, GObject gObject) {
        if (list == null) {
            return;
        }
        list.remove(fileChooserListener);
        if (list.size() == 0) {
            FileChooserEvent.Type[] typeArray = FileChooserEvent.Type.getTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                eventMap.uninitialize(gObject, (EventType)typeArray[i]);
            }
        }
    }

    static final native void gtk_file_chooser_set_action(Handle var0, int var1);

    static final native int gtk_file_chooser_get_action(Handle var0);

    static final native void gtk_file_chooser_set_local_only(Handle var0, boolean var1);

    static final native boolean gtk_file_chooser_get_local_only(Handle var0);

    static final native void gtk_file_chooser_set_select_multiple(Handle var0, boolean var1);

    static final native boolean gtk_file_chooser_get_select_multiple(Handle var0);

    static final native void gtk_file_chooser_set_current_name(Handle var0, String var1);

    static final native String gtk_file_chooser_get_filename(Handle var0);

    static final native boolean gtk_file_chooser_set_filename(Handle var0, String var1);

    static final native boolean gtk_file_chooser_select_filename(Handle var0, String var1);

    static final native void gtk_file_chooser_unselect_filename(Handle var0, String var1);

    static final native void gtk_file_chooser_select_all(Handle var0);

    static final native void gtk_file_chooser_unselect_all(Handle var0);

    static final native String[] gtk_file_chooser_get_filenames(Handle var0);

    static final native boolean gtk_file_chooser_set_current_folder(Handle var0, String var1);

    static final native String gtk_file_chooser_get_current_folder(Handle var0);

    static final native String gtk_file_chooser_get_uri(Handle var0);

    static final native boolean gtk_file_chooser_set_uri(Handle var0, String var1);

    static final native boolean gtk_file_chooser_select_uri(Handle var0, String var1);

    static final native void gtk_file_chooser_unselect_uri(Handle var0, String var1);

    static final native String[] gtk_file_chooser_get_uris(Handle var0);

    static final native boolean gtk_file_chooser_set_current_folder_uri(Handle var0, String var1);

    static final native String gtk_file_chooser_get_current_folder_uri(Handle var0);

    static final native void gtk_file_chooser_set_preview_widget(Handle var0, Handle var1);

    static final native Handle gtk_file_chooser_get_preview_widget(Handle var0);

    static final native void gtk_file_chooser_set_preview_widget_active(Handle var0, boolean var1);

    static final native boolean gtk_file_chooser_get_preview_widget_active(Handle var0);

    static final native void gtk_file_chooser_set_use_preview_label(Handle var0, boolean var1);

    static final native boolean gtk_file_chooser_get_use_preview_label(Handle var0);

    static final native String gtk_file_chooser_get_preview_filename(Handle var0);

    static final native String gtk_file_chooser_get_preview_uri(Handle var0);

    static final native void gtk_file_chooser_set_extra_widget(Handle var0, Handle var1);

    static final native Handle gtk_file_chooser_get_extra_widget(Handle var0);

    static final native void gtk_file_chooser_add_filter(Handle var0, Handle var1);

    static final native void gtk_file_chooser_remove_filter(Handle var0, Handle var1);

    static final native Handle[] gtk_file_chooser_list_filters(Handle var0);

    static final native void gtk_file_chooser_set_filter(Handle var0, Handle var1);

    static final native Handle gtk_file_chooser_get_filter(Handle var0);

    static final native Handle gtk_file_chooser_add_shortcut_folder(Handle var0, String var1);

    static final native Handle gtk_file_chooser_remove_shortcut_folder(Handle var0, String var1);

    static final native String[] gtk_file_chooser_list_shortcut_folders(Handle var0);

    static final native Handle gtk_file_chooser_add_shortcut_folder_uri(Handle var0, String var1);

    static final native Handle gtk_file_chooser_remove_shortcut_folder_uri(Handle var0, String var1);

    static final native String[] gtk_file_chooser_list_shortcut_folder_uris(Handle var0);

    static final native void gtk_file_chooser_set_show_hidden(Handle var0, boolean var1);

    static final native boolean gtk_file_chooser_get_show_hidden(Handle var0);

    private static final native int gtk_file_chooser_get_type();

    FileChooserHelper() {
    }
}

