/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.gdk.Point;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.DeleteType;
import org.gnu.gtk.Editable;
import org.gnu.gtk.EditableHelper;
import org.gnu.gtk.EntryCompletion;
import org.gnu.gtk.MovementStep;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.EntryEvent;
import org.gnu.gtk.event.EntryListener;
import org.gnu.pango.Layout;

public class Entry
extends Widget
implements Editable {
    private Vector entryListeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.entryListeners = null;
    }

    public Entry() {
        super(Entry.gtk_entry_new());
        this.finit$();
    }

    public Entry(Handle handle) {
        super(handle);
        this.finit$();
    }

    public static Entry getEntry(Handle handle) {
        if (handle == null) {
            return null;
        }
        Entry entry = (Entry)GObject.getGObjectFromHandle((Handle)handle);
        if (entry == null) {
            entry = new Entry(handle);
        }
        return entry;
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        Entry.gtk_entry_set_text(this.getHandle(), string);
    }

    public String getText() {
        return Entry.gtk_entry_get_text(this.getHandle());
    }

    public void setVisible(boolean bl) {
        Entry.gtk_entry_set_visibility(this.getHandle(), bl);
    }

    public boolean getVisible() {
        return Entry.gtk_entry_get_visibility(this.getHandle());
    }

    public void setInvisibleChar(char c) {
        Entry.gtk_entry_set_invisible_char(this.getHandle(), (byte)c);
    }

    public void setMaxLength(int n) {
        Entry.gtk_entry_set_max_length(this.getHandle(), n);
    }

    public int getMaxLength() {
        return Entry.gtk_entry_get_max_length(this.getHandle());
    }

    public boolean getHasFrame() {
        return Entry.gtk_entry_get_has_frame(this.getHandle());
    }

    public int getWidth() {
        return Entry.gtk_entry_get_width_chars(this.getHandle());
    }

    public void setActivateDefaultWidget(boolean bl) {
        Entry.gtk_entry_set_activates_default(this.getHandle(), bl);
    }

    public void setHasFrame(boolean bl) {
        Entry.gtk_entry_set_has_frame(this.getHandle(), bl);
    }

    public void setWidth(int n) {
        Entry.gtk_entry_set_width_chars(this.getHandle(), n);
    }

    public Layout getLayout() {
        Handle handle = Entry.gtk_entry_get_layout(this.getHandle());
        GObject gObject = GObject.getGObjectFromHandle((Handle)handle);
        if (gObject != null) {
            return (Layout)gObject;
        }
        return new Layout(handle);
    }

    public Point getLayoutOffsets() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Entry.gtk_entry_get_layout_offsets(this.getHandle(), nArray, nArray2);
        return new Point(nArray[0], nArray2[0]);
    }

    public void setAlignment(float f) {
        Entry.gtk_entry_set_alignment(this.getHandle(), f);
    }

    public float getAlignment() {
        return Entry.gtk_entry_get_alignment(this.getHandle());
    }

    public int layoutIndexToTextIndex(int n) {
        return Entry.gtk_entry_layout_index_to_text_index(this.getHandle(), n);
    }

    public int textIndexToLayoutIndex(int n) {
        return Entry.gtk_entry_text_index_to_layout_index(this.getHandle(), n);
    }

    public static Type getType() {
        return new Type(Entry.gtk_entry_get_type());
    }

    public void addListener(EntryListener entryListener) {
        int n = Widget.findListener(this.entryListeners, entryListener);
        if (n == -1) {
            if (this.entryListeners == null) {
                evtMap.initialize((GObject)this, (EventType)EntryEvent.Type.ACTIVATE);
                evtMap.initialize((GObject)this, (EventType)EntryEvent.Type.MOVE_CURSOR);
                evtMap.initialize((GObject)this, (EventType)EntryEvent.Type.INSERT_AT_CURSOR);
                evtMap.initialize((GObject)this, (EventType)EntryEvent.Type.DELETE_FROM_CURSOR);
                evtMap.initialize((GObject)this, (EventType)EntryEvent.Type.CUT_CLIPBOARD);
                evtMap.initialize((GObject)this, (EventType)EntryEvent.Type.COPY_CLIPBOARD);
                evtMap.initialize((GObject)this, (EventType)EntryEvent.Type.PASTE_CLIPBOARD);
                evtMap.initialize((GObject)this, (EventType)EntryEvent.Type.TOGGLE_OVERWRITE);
                evtMap.initialize((GObject)this, (EventType)EntryEvent.Type.CHANGED);
                evtMap.initialize((GObject)this, (EventType)EntryEvent.Type.DELETE_TEXT);
                evtMap.initialize((GObject)this, (EventType)EntryEvent.Type.INSERT_TEXT);
                this.entryListeners = new Vector();
            }
            this.entryListeners.addElement(entryListener);
        }
    }

    public void removeListener(EntryListener entryListener) {
        int n = Widget.findListener(this.entryListeners, entryListener);
        if (n > -1) {
            this.entryListeners.remove(n);
        }
        if (this.entryListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)EntryEvent.Type.ACTIVATE);
            evtMap.uninitialize((GObject)this, (EventType)EntryEvent.Type.MOVE_CURSOR);
            evtMap.uninitialize((GObject)this, (EventType)EntryEvent.Type.INSERT_AT_CURSOR);
            evtMap.uninitialize((GObject)this, (EventType)EntryEvent.Type.DELETE_FROM_CURSOR);
            evtMap.uninitialize((GObject)this, (EventType)EntryEvent.Type.CUT_CLIPBOARD);
            evtMap.uninitialize((GObject)this, (EventType)EntryEvent.Type.COPY_CLIPBOARD);
            evtMap.uninitialize((GObject)this, (EventType)EntryEvent.Type.PASTE_CLIPBOARD);
            evtMap.uninitialize((GObject)this, (EventType)EntryEvent.Type.TOGGLE_OVERWRITE);
            evtMap.uninitialize((GObject)this, (EventType)EntryEvent.Type.CHANGED);
            evtMap.uninitialize((GObject)this, (EventType)EntryEvent.Type.DELETE_TEXT);
            evtMap.uninitialize((GObject)this, (EventType)EntryEvent.Type.INSERT_TEXT);
            this.entryListeners = null;
        }
    }

    protected void fireEntryEvent(EntryEvent entryEvent) {
        if (this.entryListeners == null) {
            return;
        }
        int n = this.entryListeners.size();
        for (int i = 0; i < n; ++i) {
            EntryListener entryListener = (EntryListener)this.entryListeners.elementAt(i);
            entryListener.entryEvent(entryEvent);
        }
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("activate", "handleActivate", (EventType)EntryEvent.Type.ACTIVATE, Entry.class$("org.gnu.gtk.event.EntryListener"));
        eventMap.addEvent("move_cursor", "handleMoveCursor", (EventType)EntryEvent.Type.MOVE_CURSOR, Entry.class$("org.gnu.gtk.event.EntryListener"));
        eventMap.addEvent("insert_at_cursor", "handleInsertAtCursor", (EventType)EntryEvent.Type.INSERT_AT_CURSOR, Entry.class$("org.gnu.gtk.event.EntryListener"));
        eventMap.addEvent("delete_from_cursor", "handleDeleteFromCursor", (EventType)EntryEvent.Type.DELETE_FROM_CURSOR, Entry.class$("org.gnu.gtk.event.EntryListener"));
        eventMap.addEvent("cut_clipboard", "handleCutClipboard", (EventType)EntryEvent.Type.CUT_CLIPBOARD, Entry.class$("org.gnu.gtk.event.EntryListener"));
        eventMap.addEvent("copy_clipboard", "handleCopyClipboard", (EventType)EntryEvent.Type.COPY_CLIPBOARD, Entry.class$("org.gnu.gtk.event.EntryListener"));
        eventMap.addEvent("paste_clipboard", "handlePasteClipboard", (EventType)EntryEvent.Type.PASTE_CLIPBOARD, Entry.class$("org.gnu.gtk.event.EntryListener"));
        eventMap.addEvent("toggle_overwrite", "handleToggleOverwrite", (EventType)EntryEvent.Type.TOGGLE_OVERWRITE, Entry.class$("org.gnu.gtk.event.EntryListener"));
        eventMap.addEvent("changed", "handleChanged", (EventType)EntryEvent.Type.CHANGED, Entry.class$("org.gnu.gtk.event.EntryListener"));
        eventMap.addEvent("delete_text", "handleDeleteText", (EventType)EntryEvent.Type.DELETE_TEXT, Entry.class$("org.gnu.gtk.event.EntryListener"));
        eventMap.addEvent("insert_text", "handleInsertText", (EventType)EntryEvent.Type.INSERT_TEXT, Entry.class$("org.gnu.gtk.event.EntryListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void handleActivate() {
        this.fireEntryEvent(new EntryEvent(this, EntryEvent.Type.ACTIVATE));
    }

    private void handleMoveCursor(int n, int n2, boolean bl) {
        EntryEvent entryEvent = new EntryEvent(this, EntryEvent.Type.MOVE_CURSOR);
        entryEvent.setMovementStep(MovementStep.intern(n));
        entryEvent.setCount(n2);
        entryEvent.setExtendedSelection(bl);
        this.fireEntryEvent(entryEvent);
    }

    private void handleInsertAtCursor(String string) {
        EntryEvent entryEvent = new EntryEvent(this, EntryEvent.Type.INSERT_AT_CURSOR);
        entryEvent.setText(string);
        this.fireEntryEvent(entryEvent);
    }

    private void handleDeleteFromCursor(int n, int n2) {
        EntryEvent entryEvent = new EntryEvent(this, EntryEvent.Type.DELETE_FROM_CURSOR);
        entryEvent.setDeleteType(DeleteType.intern(n));
        entryEvent.setCount(n2);
        this.fireEntryEvent(entryEvent);
    }

    private void handleCutClipboard() {
        this.fireEntryEvent(new EntryEvent(this, EntryEvent.Type.CUT_CLIPBOARD));
    }

    private void handleCopyClipboard() {
        this.fireEntryEvent(new EntryEvent(this, EntryEvent.Type.COPY_CLIPBOARD));
    }

    private void handlePasteClipboard() {
        this.fireEntryEvent(new EntryEvent(this, EntryEvent.Type.PASTE_CLIPBOARD));
    }

    public void handleToggleOverwrite() {
        this.fireEntryEvent(new EntryEvent(this, EntryEvent.Type.TOGGLE_OVERWRITE));
    }

    private void handleChanged() {
        this.fireEntryEvent(new EntryEvent(this, EntryEvent.Type.CHANGED));
    }

    private void handleDeleteText(int n, int n2) {
        EntryEvent entryEvent = new EntryEvent(this, EntryEvent.Type.DELETE_TEXT);
        entryEvent.setStartPosition(n);
        entryEvent.setEndPosition(n2);
        this.fireEntryEvent(entryEvent);
    }

    private void handleInsertText(String string, int n, Handle handle) {
        EntryEvent entryEvent = new EntryEvent(this, EntryEvent.Type.INSERT_TEXT);
        entryEvent.setText(string);
        entryEvent.setInsertPosition(GObject.getIntFromHandle((Handle)handle));
        this.fireEntryEvent(entryEvent);
    }

    public void setCompletion(EntryCompletion entryCompletion) {
        Entry.gtk_entry_set_completion(this.getHandle(), entryCompletion.getHandle());
    }

    public EntryCompletion getCompletion() {
        Handle handle = Entry.gtk_entry_get_completion(this.getHandle());
        return EntryCompletion.getEntryCompletion(handle);
    }

    public void selectRegion(int n, int n2) {
        EditableHelper.gtk_editable_select_region(this.getHandle(), n, n2);
    }

    public int insertText(String string, int n) {
        int[] nArray = new int[]{n};
        EditableHelper.gtk_editable_insert_text(this.getHandle(), string, string.length(), nArray);
        return nArray[0];
    }

    public void deleteText(int n, int n2) {
        EditableHelper.gtk_editable_delete_text(this.getHandle(), n, n2);
    }

    public String getCharacters(int n, int n2) {
        return EditableHelper.gtk_editable_get_chars(this.getHandle(), n, n2);
    }

    public void cutClipboard() {
        EditableHelper.gtk_editable_cut_clipboard(this.getHandle());
    }

    public void copyClipboard() {
        EditableHelper.gtk_editable_copy_clipboard(this.getHandle());
    }

    public void pasteClipboard() {
        EditableHelper.gtk_editable_paste_clipboard(this.getHandle());
    }

    public void deleteSelection() {
        EditableHelper.gtk_editable_delete_selection(this.getHandle());
    }

    public void setCursorPosition(int n) {
        EditableHelper.gtk_editable_set_position(this.getHandle(), n);
    }

    public int getCursorPosition() {
        return EditableHelper.gtk_editable_get_position(this.getHandle());
    }

    public void setEditable(boolean bl) {
        EditableHelper.gtk_editable_set_editable(this.getHandle(), bl);
    }

    public boolean getEditable() {
        return EditableHelper.gtk_editable_get_editable(this.getHandle());
    }

    protected static final native int gtk_entry_get_type();

    protected static final native Handle gtk_entry_new();

    protected static final native void gtk_entry_set_visibility(Handle var0, boolean var1);

    protected static final native boolean gtk_entry_get_visibility(Handle var0);

    protected static final native void gtk_entry_set_invisible_char(Handle var0, byte var1);

    protected static final native byte gtk_entry_get_invisible_char(Handle var0);

    protected static final native void gtk_entry_set_has_frame(Handle var0, boolean var1);

    protected static final native boolean gtk_entry_get_has_frame(Handle var0);

    protected static final native void gtk_entry_set_max_length(Handle var0, int var1);

    protected static final native int gtk_entry_get_max_length(Handle var0);

    protected static final native void gtk_entry_set_activates_default(Handle var0, boolean var1);

    protected static final native boolean gtk_entry_get_activates_default(Handle var0);

    protected static final native void gtk_entry_set_width_chars(Handle var0, int var1);

    protected static final native int gtk_entry_get_width_chars(Handle var0);

    protected static final native void gtk_entry_set_text(Handle var0, String var1);

    protected static final native String gtk_entry_get_text(Handle var0);

    protected static final native Handle gtk_entry_get_layout(Handle var0);

    protected static final native void gtk_entry_get_layout_offsets(Handle var0, int[] var1, int[] var2);

    protected static final native void gtk_entry_set_completion(Handle var0, Handle var1);

    protected static final native Handle gtk_entry_get_completion(Handle var0);

    private static final native void gtk_entry_set_alignment(Handle var0, float var1);

    private static final native float gtk_entry_get_alignment(Handle var0);

    private static final native int gtk_entry_layout_index_to_text_index(Handle var0, int var1);

    private static final native int gtk_entry_text_index_to_layout_index(Handle var0, int var1);

    static {
        Entry.addEvents(evtMap);
    }
}

