/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.GtkStockItem;
import org.gnu.gtk.HButtonBox;
import org.gnu.gtk.ResponseType;
import org.gnu.gtk.VBox;
import org.gnu.gtk.Widget;
import org.gnu.gtk.Window;
import org.gnu.gtk.event.DialogEvent;
import org.gnu.gtk.event.DialogListener;

public class Dialog
extends Window {
    private Vector dialogListeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.dialogListeners = null;
    }

    public Dialog() {
        super(Dialog.gtk_dialog_new());
        this.finit$();
    }

    public Dialog(Handle handle) {
        super(handle);
        this.finit$();
    }

    public static Dialog getDialog(Handle handle) {
        if (handle == null) {
            return null;
        }
        Dialog dialog = (Dialog)GObject.getGObjectFromHandle((Handle)handle);
        if (dialog == null) {
            dialog = new Dialog(handle);
        }
        return dialog;
    }

    public int run() {
        this.checkState();
        return Dialog.gtk_dialog_run(this.getHandle());
    }

    public void addButton(String string, int n) {
        this.checkState();
        Dialog.gtk_dialog_add_button(this.getHandle(), string, n);
    }

    public void addButton(GtkStockItem gtkStockItem, int n) {
        this.checkState();
        this.addButton(gtkStockItem.getString(), n);
    }

    public void addWidget(Widget widget, int n) {
        this.checkState();
        Dialog.gtk_dialog_add_action_widget(this.getHandle(), widget.getHandle(), n);
    }

    public void setDefaultResponse(int n) {
        this.checkState();
        Dialog.gtk_dialog_set_default_response(this.getHandle(), n);
    }

    public VBox getDialogLayout() {
        this.checkState();
        Handle handle = Dialog.getVbox(this.getHandle());
        return VBox.getVBox(handle);
    }

    public HButtonBox getActionArea() {
        this.checkState();
        Handle handle = Dialog.getActionArea(this.getHandle());
        return HButtonBox.getHButtonBox(handle);
    }

    public void setHasSeparator(boolean bl) {
        this.checkState();
        Dialog.gtk_dialog_set_has_separator(this.getHandle(), bl);
    }

    public boolean getHasSeparator() {
        this.checkState();
        return Dialog.gtk_dialog_get_has_separator(this.getHandle());
    }

    public ResponseType getResponseForWidget(Widget widget) {
        this.checkState();
        return ResponseType.intern(Dialog.gtk_dialog_get_response_for_widget(this.getHandle(), widget.getHandle()));
    }

    public void addListener(DialogListener dialogListener) {
        this.checkState();
        int n = Widget.findListener(this.dialogListeners, dialogListener);
        if (n == -1) {
            if (this.dialogListeners == null) {
                evtMap.initialize((GObject)this, (EventType)DialogEvent.Type.CLOSE);
                evtMap.initialize((GObject)this, (EventType)DialogEvent.Type.RESPONSE);
                this.dialogListeners = new Vector();
            }
            this.dialogListeners.addElement(dialogListener);
        }
    }

    public void removeListener(DialogListener dialogListener) {
        this.checkState();
        int n = Widget.findListener(this.dialogListeners, dialogListener);
        if (n > -1) {
            this.dialogListeners.remove(n);
        }
        if (this.dialogListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)DialogEvent.Type.CLOSE);
            evtMap.uninitialize((GObject)this, (EventType)DialogEvent.Type.RESPONSE);
            this.dialogListeners = null;
        }
    }

    protected void fireButtonEvent(DialogEvent dialogEvent) {
        if (this.dialogListeners == null) {
            return;
        }
        int n = this.dialogListeners.size();
        for (int i = 0; i < n; ++i) {
            DialogListener dialogListener = (DialogListener)this.dialogListeners.elementAt(i);
            dialogListener.dialogEvent(dialogEvent);
        }
    }

    private void handleClose() {
        this.fireButtonEvent(new DialogEvent((Object)this, DialogEvent.Type.CLOSE));
    }

    private void handleResponse(int n) {
        DialogEvent dialogEvent = new DialogEvent((Object)this, DialogEvent.Type.RESPONSE);
        dialogEvent.setResponse(n);
        this.fireButtonEvent(dialogEvent);
    }

    public Class getEventListenerClass(String string) {
        this.checkState();
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        this.checkState();
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("close", "handleClose", (EventType)DialogEvent.Type.CLOSE, Dialog.class$("org.gnu.gtk.event.DialogListener"));
        eventMap.addEvent("response", "handleResponse", (EventType)DialogEvent.Type.RESPONSE, Dialog.class$("org.gnu.gtk.event.DialogListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Type getType() {
        return new Type(Dialog.gtk_dialog_get_type());
    }

    protected static final native Handle getVbox(Handle var0);

    protected static final native Handle getActionArea(Handle var0);

    protected static final native int gtk_dialog_get_type();

    protected static final native Handle gtk_dialog_new();

    protected static final native void gtk_dialog_add_action_widget(Handle var0, Handle var1, int var2);

    protected static final native Handle gtk_dialog_add_button(Handle var0, String var1, int var2);

    protected static final native void gtk_dialog_set_response_sensitive(Handle var0, int var1, boolean var2);

    protected static final native void gtk_dialog_set_default_response(Handle var0, int var1);

    protected static final native void gtk_dialog_set_has_separator(Handle var0, boolean var1);

    protected static final native boolean gtk_dialog_get_has_separator(Handle var0);

    protected static final native void gtk_dialog_response(Handle var0, int var1);

    protected static final native int gtk_dialog_run(Handle var0);

    protected static final native int gtk_dialog_get_response_for_widget(Handle var0, Handle var1);

    static {
        Dialog.addEvents(evtMap);
    }
}

