/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.glib.Value;
import org.gnu.gtk.ResizeMode;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.ContainerEvent;
import org.gnu.gtk.event.ContainerListener;

public class Container
extends Widget {
    private Vector containerListeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.containerListeners = null;
    }

    protected Container(Handle handle) {
        super(handle);
        this.finit$();
    }

    protected static Container getContainer(Handle handle) {
        if (handle == null) {
            return null;
        }
        Container container = (Container)GObject.getGObjectFromHandle((Handle)handle);
        if (container == null) {
            container = new Container(handle);
        }
        return container;
    }

    public void add(Widget widget) {
        this.checkState();
        Container.gtk_container_add(this.getHandle(), widget.getHandle());
    }

    public void remove(Widget widget) {
        this.checkState();
        Container.gtk_container_remove(this.getHandle(), widget.getHandle());
    }

    public ResizeMode getResizeMode() {
        this.checkState();
        int n = Container.gtk_container_get_resize_mode(this.getHandle());
        return ResizeMode.intern(n);
    }

    public void setResizeMode(ResizeMode resizeMode) {
        this.checkState();
        Container.gtk_container_set_resize_mode(this.getHandle(), resizeMode.getValue());
    }

    public int getBorderWidth() {
        this.checkState();
        return Container.gtk_container_get_border_width(this.getHandle());
    }

    public void setBorderWidth(int n) {
        this.checkState();
        Container.gtk_container_set_border_width(this.getHandle(), n);
    }

    public void setChildProperty(Widget widget, String string, Value value) {
        Container.gtk_container_child_set_property(this.getHandle(), widget.getHandle(), string, value.getHandle());
    }

    public void setIntChildProperty(Widget widget, String string, int n) {
        Value value = new Value(Type.INT());
        value.setInteger(n);
        this.setChildProperty(widget, string, value);
    }

    public void setBooleanChildProperty(Widget widget, String string, boolean bl) {
        Value value = new Value(Type.BOOLEAN());
        value.setBoolean(bl);
        this.setChildProperty(widget, string, value);
    }

    public Value getChildProperty(Widget widget, String string) {
        return new Value(Container.gtk_container_child_get_property(this.getHandle(), widget.getHandle(), string));
    }

    public int getIntChildProperty(Widget widget, String string) {
        Value value = this.getChildProperty(widget, string);
        if (value != null) {
            return value.getInt();
        }
        return 0;
    }

    public boolean getBooleanChildProperty(Widget widget, String string) {
        Value value = this.getChildProperty(widget, string);
        if (value != null) {
            return value.getBoolean();
        }
        return false;
    }

    public void resizeChildren() {
        this.checkState();
        Container.gtk_container_resize_children(this.getHandle());
    }

    public Widget[] getChildren() {
        this.checkState();
        Handle[] handleArray = Container.gtk_container_get_children(this.getHandle());
        if (handleArray == null) {
            return null;
        }
        Widget[] widgetArray = new Widget[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            widgetArray[i] = (Widget)GObject.getGObjectFromHandle((Handle)handleArray[i]);
            if (widgetArray[i] != null) continue;
            try {
                widgetArray[i] = Widget.makeWidget(handleArray[i]);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                widgetArray[i] = new Widget(handleArray[i]);
            }
        }
        return widgetArray;
    }

    public static Type getType() {
        return new Type(Container.gtk_container_get_type());
    }

    public void addListener(ContainerListener containerListener) {
        this.checkState();
        int n = Widget.findListener(this.containerListeners, containerListener);
        if (n == -1) {
            if (this.containerListeners == null) {
                evtMap.initialize((GObject)this, (EventType)ContainerEvent.Type.ADD);
                evtMap.initialize((GObject)this, (EventType)ContainerEvent.Type.CHECK_RESIZE);
                evtMap.initialize((GObject)this, (EventType)ContainerEvent.Type.REMOVE);
                evtMap.initialize((GObject)this, (EventType)ContainerEvent.Type.SET_FOCUS_CHILD);
                this.containerListeners = new Vector();
            }
            this.containerListeners.addElement(containerListener);
        }
    }

    public void removeListener(ContainerListener containerListener) {
        this.checkState();
        int n = Widget.findListener(this.containerListeners, containerListener);
        if (n > -1) {
            this.containerListeners.remove(n);
        }
        if (this.containerListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)ContainerEvent.Type.ADD);
            evtMap.uninitialize((GObject)this, (EventType)ContainerEvent.Type.CHECK_RESIZE);
            evtMap.uninitialize((GObject)this, (EventType)ContainerEvent.Type.REMOVE);
            evtMap.uninitialize((GObject)this, (EventType)ContainerEvent.Type.SET_FOCUS_CHILD);
            this.containerListeners = null;
        }
    }

    protected void fireContainerEvent(ContainerEvent containerEvent) {
        if (this.containerListeners == null) {
            return;
        }
        int n = this.containerListeners.size();
        for (int i = 0; i < n; ++i) {
            ContainerListener containerListener = (ContainerListener)this.containerListeners.elementAt(i);
            containerListener.containerEvent(containerEvent);
        }
    }

    private void handleAdd(Handle handle) {
        this.fireContainerEvent(new ContainerEvent((Object)this, ContainerEvent.Type.ADD));
    }

    private void handleCheckResize() {
        this.fireContainerEvent(new ContainerEvent((Object)this, ContainerEvent.Type.CHECK_RESIZE));
    }

    private void handleRemove(Handle handle) {
        this.fireContainerEvent(new ContainerEvent((Object)this, ContainerEvent.Type.REMOVE));
    }

    private void handleSetFocusChild(Handle handle) {
        this.fireContainerEvent(new ContainerEvent((Object)this, ContainerEvent.Type.SET_FOCUS_CHILD));
    }

    public Class getEventListenerClass(String string) {
        this.checkState();
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        this.checkState();
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("add", "handleAdd", (EventType)ContainerEvent.Type.ADD, Container.class$("org.gnu.gtk.event.ContainerListener"));
        eventMap.addEvent("check_resize", "handleCheckResize", (EventType)ContainerEvent.Type.CHECK_RESIZE, Container.class$("org.gnu.gtk.event.ContainerListener"));
        eventMap.addEvent("remove", "handleRemove", (EventType)ContainerEvent.Type.REMOVE, Container.class$("org.gnu.gtk.event.ContainerListener"));
        eventMap.addEvent("set_focus_child", "handleSetFocusChild", (EventType)ContainerEvent.Type.SET_FOCUS_CHILD, Container.class$("org.gnu.gtk.event.ContainerListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static final native int gtk_container_get_type();

    protected static final native void gtk_container_set_border_width(Handle var0, int var1);

    protected static final native int gtk_container_get_border_width(Handle var0);

    protected static final native void gtk_container_add(Handle var0, Handle var1);

    protected static final native void gtk_container_remove(Handle var0, Handle var1);

    protected static final native void gtk_container_set_resize_mode(Handle var0, int var1);

    protected static final native int gtk_container_get_resize_mode(Handle var0);

    protected static final native void gtk_container_check_resize(Handle var0);

    protected static final native Handle[] gtk_container_get_children(Handle var0);

    protected static final native void gtk_container_propagate_expose(Handle var0, Handle var1, Handle var2);

    protected static final native void gtk_container_set_focus_chain(Handle var0, Handle var1);

    protected static final native boolean gtk_container_get_focus_chain(Handle var0, Handle var1);

    protected static final native void gtk_container_unset_focus_chain(Handle var0);

    protected static final native void gtk_container_set_reallocate_redraws(Handle var0, boolean var1);

    protected static final native void gtk_container_set_focus_child(Handle var0, Handle var1);

    protected static final native void gtk_container_set_focus_vadjustment(Handle var0, Handle var1);

    protected static final native Handle gtk_container_get_focus_vadjustment(Handle var0);

    protected static final native void gtk_container_set_focus_hadjustment(Handle var0, Handle var1);

    protected static final native Handle gtk_container_get_focus_hadjustment(Handle var0);

    protected static final native void gtk_container_resize_children(Handle var0);

    protected static final native int gtk_container_child_type(Handle var0);

    protected static final native void gtk_container_child_set_property(Handle var0, Handle var1, String var2, Handle var3);

    protected static final native Handle gtk_container_child_get_property(Handle var0, Handle var1, String var2);

    static {
        Container.addEvents(evtMap);
    }
}

