/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.atk.AtkObject;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.gtk.Bin;
import org.gnu.gtk.CellLayout;
import org.gnu.gtk.CellLayoutHelper;
import org.gnu.gtk.CellRenderer;
import org.gnu.gtk.CellRendererAttribute;
import org.gnu.gtk.DataColumn;
import org.gnu.gtk.TreeIter;
import org.gnu.gtk.TreeModel;
import org.gnu.gtk.TreeViewRowSeparatorMethod;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.ComboBoxEvent;
import org.gnu.gtk.event.ComboBoxListener;

public class ComboBox
extends Bin
implements CellLayout {
    private TreeViewRowSeparatorMethod separatorFunc;
    private Vector cbListeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.separatorFunc = null;
        this.cbListeners = null;
    }

    public ComboBox(Handle handle) {
        super(handle);
        this.finit$();
    }

    public static ComboBox getComboBox(Handle handle) {
        if (handle == null) {
            return null;
        }
        ComboBox comboBox = (ComboBox)GObject.getGObjectFromHandle((Handle)handle);
        if (comboBox == null) {
            comboBox = new ComboBox(handle);
        }
        return comboBox;
    }

    public ComboBox() {
        super(ComboBox.gtk_combo_box_new_text());
        this.finit$();
    }

    public ComboBox(TreeModel treeModel) {
        super(treeModel == null ? ComboBox.gtk_combo_box_new() : ComboBox.gtk_combo_box_new_with_model(treeModel.getHandle()));
        this.finit$();
    }

    public void setWrapWidth(int n) {
        ComboBox.gtk_combo_box_set_wrap_width(this.getHandle(), n);
    }

    public int getWrapWidth() {
        return ComboBox.gtk_combo_box_get_wrap_width(this.getHandle());
    }

    public void setRowSpanColumn(int n) {
        ComboBox.gtk_combo_box_set_row_span_column(this.getHandle(), n);
    }

    public int getRowSpanColumn() {
        return ComboBox.gtk_combo_box_get_row_span_column(this.getHandle());
    }

    public void setColumnSpanColumn(int n) {
        ComboBox.gtk_combo_box_set_column_span_column(this.getHandle(), n);
    }

    public int getColumnSpanColumn() {
        return ComboBox.gtk_combo_box_get_column_span_column(this.getHandle());
    }

    public boolean getAddTearoffs() {
        return ComboBox.gtk_combo_box_get_add_tearoffs(this.getHandle());
    }

    public void setAddTearoffs(boolean bl) {
        ComboBox.gtk_combo_box_set_add_tearoffs(this.getHandle(), bl);
    }

    public boolean getFocusOnClick() {
        return ComboBox.gtk_combo_box_get_focus_on_click(this.getHandle());
    }

    public void setFocusOnClick(boolean bl) {
        ComboBox.gtk_combo_box_set_focus_on_click(this.getHandle(), bl);
    }

    public int getActive() {
        return ComboBox.gtk_combo_box_get_active(this.getHandle());
    }

    public void setActive(int n) {
        ComboBox.gtk_combo_box_set_active(this.getHandle(), n);
    }

    public TreeIter getActiveIter() {
        Handle handle = ComboBox.gtk_combo_box_get_active_iter(this.getHandle());
        return TreeIter.getTreeIter(handle, this.getModel());
    }

    public void setActiveIter(TreeIter treeIter) {
        ComboBox.gtk_combo_box_set_active_iter(this.getHandle(), treeIter.getHandle());
    }

    public TreeModel getModel() {
        Handle handle = ComboBox.gtk_combo_box_get_model(this.getHandle());
        return TreeModel.getTreeModel(handle);
    }

    public void setModel(TreeModel treeModel) {
        ComboBox.gtk_combo_box_set_model(this.getHandle(), treeModel.getHandle());
    }

    public void appendText(String string) {
        ComboBox.gtk_combo_box_append_text(this.getHandle(), string);
    }

    public void insertText(int n, String string) {
        ComboBox.gtk_combo_box_insert_text(this.getHandle(), n, string);
    }

    public void prependText(String string) {
        ComboBox.gtk_combo_box_prepend_text(this.getHandle(), string);
    }

    public void removeText(int n) {
        ComboBox.gtk_combo_box_remove_text(this.getHandle(), n);
    }

    public String getActiveText() {
        return ComboBox.gtk_combo_box_get_active_text(this.getHandle());
    }

    public void popup() {
        ComboBox.gtk_combo_box_popup(this.getHandle());
    }

    public void popdown() {
        ComboBox.gtk_combo_box_popdown(this.getHandle());
    }

    public AtkObject getPopupAccessible() {
        return new AtkObject(ComboBox.gtk_combo_box_get_popup_accessible(this.getHandle()));
    }

    public void packStart(CellRenderer cellRenderer, boolean bl) {
        CellLayoutHelper.packStart(this, cellRenderer, bl);
    }

    public void packEnd(CellRenderer cellRenderer, boolean bl) {
        CellLayoutHelper.packEnd(this, cellRenderer, bl);
    }

    public void clear() {
        CellLayoutHelper.clear(this);
    }

    public void addAttributeMapping(CellRenderer cellRenderer, CellRendererAttribute cellRendererAttribute, DataColumn dataColumn) {
        CellLayoutHelper.addAttributeMapping(this, cellRenderer, cellRendererAttribute, dataColumn);
    }

    public void clearAttributeMappings(CellRenderer cellRenderer) {
        CellLayoutHelper.clearAttributeMappings(this, cellRenderer);
    }

    public void reorder(CellRenderer cellRenderer, int n) {
        CellLayoutHelper.reorder(this, cellRenderer, n);
    }

    public void setRowSeparatorMethod(TreeViewRowSeparatorMethod treeViewRowSeparatorMethod) {
        this.separatorFunc = treeViewRowSeparatorMethod;
        if (treeViewRowSeparatorMethod == null) {
            ComboBox.gtk_combo_box_set_row_separator_func(this.getHandle(), null, "handleSeparatorFunc");
        } else {
            ComboBox.gtk_combo_box_set_row_separator_func(this.getHandle(), this, "handleSeparatorFunc");
        }
    }

    protected boolean handleSeparatorFunc(Handle handle, Handle handle2) {
        TreeModel treeModel = (TreeModel)GObject.getGObjectFromHandle((Handle)handle);
        TreeIter treeIter = TreeIter.getTreeIter(handle2, treeModel);
        return this.separatorFunc.isSeparator(treeModel, treeIter);
    }

    public TreeViewRowSeparatorMethod getRowSeparatorMethod() {
        return this.separatorFunc;
    }

    public void addListener(ComboBoxListener comboBoxListener) {
        int n = Widget.findListener(this.cbListeners, comboBoxListener);
        if (n == -1) {
            if (this.cbListeners == null) {
                evtMap.initialize((GObject)this, (EventType)ComboBoxEvent.Type.CHANGED);
                this.cbListeners = new Vector();
            }
            this.cbListeners.addElement(comboBoxListener);
        }
    }

    public void removeListener(ComboBoxListener comboBoxListener) {
        int n = Widget.findListener(this.cbListeners, comboBoxListener);
        if (n > -1) {
            this.cbListeners.remove(n);
        }
        if (this.cbListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)ComboBoxEvent.Type.CHANGED);
            this.cbListeners = null;
        }
    }

    protected void fireComboBoxEvent(ComboBoxEvent comboBoxEvent) {
        if (this.cbListeners == null) {
            return;
        }
        int n = this.cbListeners.size();
        for (int i = 0; i < n; ++i) {
            ComboBoxListener comboBoxListener = (ComboBoxListener)this.cbListeners.elementAt(i);
            comboBoxListener.comboBoxEvent(comboBoxEvent);
        }
    }

    private void handleChanged() {
        this.fireComboBoxEvent(new ComboBoxEvent(this, ComboBoxEvent.Type.CHANGED));
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("changed", "handleChanged", (EventType)ComboBoxEvent.Type.CHANGED, ComboBox.class$("org.gnu.gtk.event.ComboBoxListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static final native int gtk_combo_box_get_type();

    protected static final native Handle gtk_combo_box_new();

    protected static final native Handle gtk_combo_box_new_with_model(Handle var0);

    protected static final native int gtk_combo_box_get_wrap_width(Handle var0);

    protected static final native void gtk_combo_box_set_wrap_width(Handle var0, int var1);

    protected static final native int gtk_combo_box_get_row_span_column(Handle var0);

    protected static final native void gtk_combo_box_set_row_span_column(Handle var0, int var1);

    protected static final native int gtk_combo_box_get_column_span_column(Handle var0);

    protected static final native void gtk_combo_box_set_column_span_column(Handle var0, int var1);

    protected static final native boolean gtk_combo_box_get_add_tearoffs(Handle var0);

    protected static final native void gtk_combo_box_set_add_tearoffs(Handle var0, boolean var1);

    protected static final native boolean gtk_combo_box_get_focus_on_click(Handle var0);

    protected static final native void gtk_combo_box_set_focus_on_click(Handle var0, boolean var1);

    protected static final native int gtk_combo_box_get_active(Handle var0);

    protected static final native void gtk_combo_box_set_active(Handle var0, int var1);

    protected static final native Handle gtk_combo_box_get_active_iter(Handle var0);

    protected static final native void gtk_combo_box_set_active_iter(Handle var0, Handle var1);

    protected static final native void gtk_combo_box_set_model(Handle var0, Handle var1);

    protected static final native Handle gtk_combo_box_get_model(Handle var0);

    protected static final native Handle gtk_combo_box_new_text();

    protected static final native void gtk_combo_box_append_text(Handle var0, String var1);

    protected static final native void gtk_combo_box_insert_text(Handle var0, int var1, String var2);

    protected static final native void gtk_combo_box_prepend_text(Handle var0, String var1);

    protected static final native void gtk_combo_box_remove_text(Handle var0, int var1);

    protected static final native String gtk_combo_box_get_active_text(Handle var0);

    protected static final native void gtk_combo_box_popup(Handle var0);

    protected static final native void gtk_combo_box_popdown(Handle var0);

    protected static final native Handle gtk_combo_box_get_popup_accessible(Handle var0);

    private static final native void gtk_combo_box_set_row_separator_func(Handle var0, ComboBox var1, String var2);

    static {
        ComboBox.addEvents(evtMap);
    }
}

