/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.gdk.Color;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.gtk.Button;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.ColorButtonEvent;
import org.gnu.gtk.event.ColorButtonListener;

public class ColorButton
extends Button {
    private Vector cbListeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.cbListeners = null;
    }

    public ColorButton() {
        super(ColorButton.gtk_color_button_new());
        this.finit$();
    }

    public ColorButton(Color color) {
        super(ColorButton.gtk_color_button_new_with_color(color.getHandle()));
        this.finit$();
    }

    public ColorButton(Handle handle) {
        super(handle);
        this.finit$();
    }

    public static ColorButton getColorButton(Handle handle) {
        if (handle == null) {
            return null;
        }
        ColorButton colorButton = (ColorButton)GObject.getGObjectFromHandle((Handle)handle);
        if (colorButton == null) {
            colorButton = new ColorButton(handle);
        }
        return colorButton;
    }

    public void setColor(Color color) {
        ColorButton.gtk_color_button_set_color(this.getHandle(), color.getHandle());
    }

    public Color getColor() {
        return new Color(ColorButton.gtk_color_button_get_color(this.getHandle()));
    }

    public void setAlpha(int n) {
        ColorButton.gtk_color_button_set_alpha(this.getHandle(), n);
    }

    public int getAlpha() {
        return ColorButton.gtk_color_button_get_alpha(this.getHandle());
    }

    public void setUseAlpha(boolean bl) {
        ColorButton.gtk_color_button_set_use_alpha(this.getHandle(), bl);
    }

    public boolean getUseAlpha() {
        return ColorButton.gtk_color_button_get_use_alpha(this.getHandle());
    }

    public void setTitle(String string) {
        ColorButton.gtk_color_button_set_title(this.getHandle(), string);
    }

    public String getTitle() {
        return ColorButton.gtk_color_button_get_title(this.getHandle());
    }

    public void addListener(ColorButtonListener colorButtonListener) {
        int n = Widget.findListener(this.cbListeners, colorButtonListener);
        if (n == -1) {
            if (this.cbListeners == null) {
                evtMap.initialize((GObject)this, (EventType)ColorButtonEvent.Type.COLOR_SET);
                this.cbListeners = new Vector();
            }
            this.cbListeners.addElement(colorButtonListener);
        }
    }

    public void removeListener(ColorButtonListener colorButtonListener) {
        int n = Widget.findListener(this.cbListeners, colorButtonListener);
        if (n > -1) {
            this.cbListeners.remove(n);
        }
        if (this.cbListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)ColorButtonEvent.Type.COLOR_SET);
            this.cbListeners = null;
        }
    }

    protected void fireColorButtonEvent(ColorButtonEvent colorButtonEvent) {
        if (this.cbListeners == null) {
            return;
        }
        int n = this.cbListeners.size();
        for (int i = 0; i < n; ++i) {
            ColorButtonListener colorButtonListener = (ColorButtonListener)this.cbListeners.elementAt(i);
            colorButtonListener.colorButtonEvent(colorButtonEvent);
        }
    }

    private void handleColorSet() {
        this.fireColorButtonEvent(new ColorButtonEvent((Object)this, ColorButtonEvent.Type.COLOR_SET));
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("color_set", "handleColorSet", (EventType)ColorButtonEvent.Type.COLOR_SET, ColorButton.class$("org.gnu.gtk.event.ColorButtonListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static final native int gtk_color_button_get_type();

    protected static final native Handle gtk_color_button_new();

    protected static final native Handle gtk_color_button_new_with_color(Handle var0);

    protected static final native void gtk_color_button_set_color(Handle var0, Handle var1);

    protected static final native void gtk_color_button_set_alpha(Handle var0, int var1);

    protected static final native Handle gtk_color_button_get_color(Handle var0);

    protected static final native int gtk_color_button_get_alpha(Handle var0);

    protected static final native void gtk_color_button_set_use_alpha(Handle var0, boolean var1);

    protected static final native boolean gtk_color_button_get_use_alpha(Handle var0);

    protected static final native void gtk_color_button_set_title(Handle var0, String var1);

    protected static final native String gtk_color_button_get_title(Handle var0);

    static {
        ColorButton.addEvents(evtMap);
    }
}

