/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import org.gnu.gdk.Atom;
import org.gnu.gdk.Display;
import org.gnu.gdk.Pixbuf;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.gtk.SelectionData;
import org.gnu.gtk.TargetEntry;

public class Clipboard
extends GObject {
    protected Clipboard(Handle handle) {
        super(handle);
    }

    protected static Clipboard getClipboard(Handle handle) {
        if (handle == null) {
            return null;
        }
        Clipboard clipboard = (Clipboard)GObject.getGObjectFromHandle((Handle)handle);
        if (clipboard == null) {
            clipboard = new Clipboard(handle);
        }
        return clipboard;
    }

    public void clear() {
        Clipboard.gtk_clipboard_clear(this.getHandle());
    }

    public static Clipboard get(Atom atom) {
        Handle handle = Clipboard.gtk_clipboard_get(atom.getHandle());
        return Clipboard.getClipboard(handle);
    }

    public static Clipboard getForDisplay(Display display, Atom atom) {
        return Clipboard.getClipboard(Clipboard.gtk_clipboard_get_for_display(display.getHandle(), atom.getHandle()));
    }

    public Display getDisplay() {
        return Display.getDisplayFromHandle(Clipboard.gtk_clipboard_get_display(this.getHandle()));
    }

    public SelectionData getContents(Atom atom) {
        return null;
    }

    public boolean isTextAvailable() {
        return Clipboard.gtk_clipboard_wait_is_text_available(this.getHandle());
    }

    public boolean isImageAvailable() {
        return Clipboard.gtk_clipboard_wait_is_image_available(this.getHandle());
    }

    public void setText(String string) {
        Clipboard.gtk_clipboard_set_text(this.getHandle(), string, string.length());
    }

    public String getText() {
        return Clipboard.gtk_clipboard_wait_for_text(this.getHandle());
    }

    public void setImage(Pixbuf pixbuf) {
        Clipboard.gtk_clipboard_set_image(this.getHandle(), pixbuf.getHandle());
    }

    public Pixbuf getImage() {
        Handle handle = Clipboard.gtk_clipboard_wait_for_image(this.getHandle());
        return Pixbuf.getPixbufFromHandle(handle);
    }

    public void setCanStore(TargetEntry[] targetEntryArray) {
        if (targetEntryArray == null) {
            return;
        }
        Handle[] handleArray = new Handle[targetEntryArray.length];
        for (int i = 0; i < targetEntryArray.length; ++i) {
            handleArray[i] = targetEntryArray[i].getHandle();
        }
        Clipboard.gtk_clipboard_set_can_store(this.getHandle(), handleArray);
    }

    public void store() {
        Clipboard.gtk_clipboard_store(this.getHandle());
    }

    protected void finalize() throws Throwable {
    }

    protected static final native Handle gtk_clipboard_get(Handle var0);

    protected static final native Handle gtk_clipboard_get_display(Handle var0);

    protected static final native Handle gtk_clipboard_get_owner(Handle var0);

    protected static final native void gtk_clipboard_clear(Handle var0);

    protected static final native void gtk_clipboard_set_text(Handle var0, String var1, int var2);

    protected static final native void gtk_clipboard_set_image(Handle var0, Handle var1);

    protected static final native String gtk_clipboard_wait_for_text(Handle var0);

    protected static final native Handle gtk_clipboard_wait_for_image(Handle var0);

    protected static final native boolean gtk_clipboard_wait_is_text_available(Handle var0);

    protected static final native boolean gtk_clipboard_wait_is_image_available(Handle var0);

    protected static final native boolean gtk_clipboard_wait_is_target_available(Handle var0, Handle var1);

    protected static final native void gtk_clipboard_set_can_store(Handle var0, Handle[] var1);

    protected static final native void gtk_clipboard_store(Handle var0);

    private static final native Handle gtk_clipboard_get_for_display(Handle var0, Handle var1);
}

