/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.MenuItem;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.CheckMenuItemEvent;
import org.gnu.gtk.event.CheckMenuItemListener;

public class CheckMenuItem
extends MenuItem {
    private Vector listeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.listeners = null;
    }

    public CheckMenuItem() {
        super(CheckMenuItem.gtk_check_menu_item_new());
        this.finit$();
    }

    public CheckMenuItem(Handle handle) {
        super(handle);
        this.finit$();
    }

    public static CheckMenuItem getCheckMenuItem(Handle handle) {
        if (handle == null) {
            return null;
        }
        CheckMenuItem checkMenuItem = (CheckMenuItem)GObject.getGObjectFromHandle((Handle)handle);
        if (checkMenuItem == null) {
            checkMenuItem = new CheckMenuItem(handle);
        }
        return checkMenuItem;
    }

    public CheckMenuItem(String string, boolean bl) {
        super(CheckMenuItem.init(string, bl));
        this.finit$();
    }

    private static Handle init(String string, boolean bl) {
        if (bl) {
            return CheckMenuItem.gtk_check_menu_item_new_with_mnemonic(string);
        }
        return CheckMenuItem.gtk_check_menu_item_new_with_label(string);
    }

    public void setActive(boolean bl) {
        CheckMenuItem.gtk_check_menu_item_set_active(this.getHandle(), bl);
    }

    public boolean getActive() {
        return CheckMenuItem.gtk_check_menu_item_get_active(this.getHandle());
    }

    public void setInconsistent(boolean bl) {
        CheckMenuItem.gtk_check_menu_item_set_inconsistent(this.getHandle(), bl);
    }

    public boolean getInconsistent() {
        return CheckMenuItem.gtk_check_menu_item_get_inconsistent(this.getHandle());
    }

    public void setDrawAsRadio(boolean bl) {
        CheckMenuItem.gtk_check_menu_item_set_draw_as_radio(this.getHandle(), bl);
    }

    public boolean getDrawAsRadio() {
        return CheckMenuItem.gtk_check_menu_item_get_draw_as_radio(this.getHandle());
    }

    public static Type getType() {
        return new Type(CheckMenuItem.gtk_check_menu_item_get_type());
    }

    public void addListener(CheckMenuItemListener checkMenuItemListener) {
        int n = Widget.findListener(this.listeners, checkMenuItemListener);
        if (n == -1) {
            if (this.listeners == null) {
                evtMap.initialize((GObject)this, (EventType)CheckMenuItemEvent.Type.TOGGLED);
                this.listeners = new Vector();
            }
            this.listeners.addElement(checkMenuItemListener);
        }
    }

    public void removeListener(CheckMenuItemListener checkMenuItemListener) {
        int n = Widget.findListener(this.listeners, checkMenuItemListener);
        if (n > -1) {
            this.listeners.remove(n);
        }
        if (this.listeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)CheckMenuItemEvent.Type.TOGGLED);
            this.listeners = null;
        }
    }

    protected void fireCheckMenuItemEvent(CheckMenuItemEvent checkMenuItemEvent) {
        if (this.listeners == null) {
            return;
        }
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            CheckMenuItemListener checkMenuItemListener = (CheckMenuItemListener)this.listeners.elementAt(i);
            checkMenuItemListener.checkMenuItemEvent(checkMenuItemEvent);
        }
    }

    private void handleToggled() {
        this.fireCheckMenuItemEvent(new CheckMenuItemEvent((Object)this, CheckMenuItemEvent.Type.TOGGLED));
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("toggled", "handleToggled", (EventType)CheckMenuItemEvent.Type.TOGGLED, CheckMenuItem.class$("org.gnu.gtk.event.CheckMenuItemListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static final native int gtk_check_menu_item_get_type();

    protected static final native Handle gtk_check_menu_item_new();

    protected static final native Handle gtk_check_menu_item_new_with_label(String var0);

    protected static final native Handle gtk_check_menu_item_new_with_mnemonic(String var0);

    protected static final native void gtk_check_menu_item_set_active(Handle var0, boolean var1);

    protected static final native boolean gtk_check_menu_item_get_active(Handle var0);

    protected static final native void gtk_check_menu_item_toggled(Handle var0);

    protected static final native void gtk_check_menu_item_set_inconsistent(Handle var0, boolean var1);

    protected static final native boolean gtk_check_menu_item_get_inconsistent(Handle var0);

    protected static final native void gtk_check_menu_item_set_draw_as_radio(Handle var0, boolean var1);

    protected static final native boolean gtk_check_menu_item_get_draw_as_radio(Handle var0);

    static {
        CheckMenuItem.addEvents(evtMap);
    }
}

