/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import org.gnu.gdk.Color;
import org.gnu.gdk.Pixbuf;
import org.gnu.glib.Handle;
import org.gnu.gtk.CellRenderer;
import org.gnu.gtk.Requisition;
import org.gnu.gtk.TreeModel;
import org.gnu.gtk.TreePath;
import org.gnu.gtk.Widget;

public class CellView
extends Widget {
    public CellView() {
        super(CellView.gtk_cell_view_new());
    }

    public CellView(String string, boolean bl) {
        super(CellView.init(string, bl));
    }

    public CellView(Pixbuf pixbuf) {
        super(CellView.gtk_cell_view_new_with_pixbuf(pixbuf.getHandle()));
    }

    private static Handle init(String string, boolean bl) {
        if (bl) {
            return CellView.gtk_cell_view_new_with_markup(string);
        }
        return CellView.gtk_cell_view_new_with_text(string);
    }

    public void setModel(TreeModel treeModel) {
        CellView.gtk_cell_view_set_model(this.getHandle(), treeModel.getHandle());
    }

    public void setDisplayedRow(TreePath treePath) {
        CellView.gtk_cell_view_set_displayed_row(this.getHandle(), treePath.getHandle());
    }

    public TreePath getDisplayedRow() {
        Handle handle = CellView.gtk_cell_view_get_displayed_row(this.getHandle());
        return TreePath.getTreePath(handle);
    }

    public void setBackgroundColor(Color color) {
        CellView.gtk_cell_view_set_background_color(this.getHandle(), color.getHandle());
    }

    public Requisition getSizeOfRow(TreePath treePath) {
        Handle handle = CellView.gtk_cell_view_get_size_of_row(this.getHandle(), treePath.getHandle());
        return Requisition.getRequisition(handle);
    }

    public CellRenderer[] getCellRenderers() {
        Handle[] handleArray = CellView.gtk_cell_view_get_cell_renderers(this.getHandle());
        if (handleArray == null) {
            return null;
        }
        CellRenderer[] cellRendererArray = new CellRenderer[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            cellRendererArray[i] = CellRenderer.getCellRenderer(handleArray[i]);
        }
        return cellRendererArray;
    }

    protected static final native int gtk_cell_view_get_type();

    protected static final native Handle gtk_cell_view_new();

    protected static final native Handle gtk_cell_view_new_with_text(String var0);

    protected static final native Handle gtk_cell_view_new_with_markup(String var0);

    protected static final native Handle gtk_cell_view_new_with_pixbuf(Handle var0);

    protected static final native void gtk_cell_view_set_model(Handle var0, Handle var1);

    protected static final native void gtk_cell_view_set_displayed_row(Handle var0, Handle var1);

    protected static final native Handle gtk_cell_view_get_displayed_row(Handle var0);

    protected static final native Handle gtk_cell_view_get_size_of_row(Handle var0, Handle var1);

    protected static final native void gtk_cell_view_set_background_color(Handle var0, Handle var1);

    protected static final native Handle[] gtk_cell_view_get_cell_renderers(Handle var0);
}

