/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.gdk.Event;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.event.CellEditableEvent;
import org.gnu.gtk.event.CellEditableListener;

public class CellEditable
extends GObject {
    private Vector listeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.listeners = null;
    }

    public CellEditable() {
        super(CellEditable.newObject());
        this.finit$();
    }

    public static Type getType() {
        return new Type(CellEditable.gtk_cell_editable_get_type());
    }

    public void startEditing(Event event) {
        CellEditable.gtk_cell_editable_start_editing(this.getHandle(), event.getHandle());
    }

    public void editingDone() {
        CellEditable.gtk_cell_editable_editing_done(this.getHandle());
    }

    public void removeWidget() {
        CellEditable.gtk_cell_editable_remove_widget(this.getHandle());
    }

    public void addListener(CellEditableListener cellEditableListener) {
        int n = CellEditable.findListener(this.listeners, cellEditableListener);
        if (n == -1) {
            if (this.listeners == null) {
                evtMap.initialize((GObject)this, (EventType)CellEditableEvent.Type.EDITING_DONE);
                evtMap.initialize((GObject)this, (EventType)CellEditableEvent.Type.REMOVE_WIDGET);
                this.listeners = new Vector();
            }
            this.listeners.addElement(cellEditableListener);
        }
    }

    public void removeListener(CellEditableListener cellEditableListener) {
        int n = CellEditable.findListener(this.listeners, cellEditableListener);
        if (n > -1) {
            this.listeners.remove(n);
        }
        if (this.listeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)CellEditableEvent.Type.EDITING_DONE);
            evtMap.uninitialize((GObject)this, (EventType)CellEditableEvent.Type.REMOVE_WIDGET);
            this.listeners = null;
        }
    }

    protected static int findListener(Vector vector, Object object) {
        if (vector == null || object == null) {
            return -1;
        }
        return vector.indexOf(object);
    }

    protected void fireCellEditableEvent(CellEditableEvent cellEditableEvent) {
        if (this.listeners == null) {
            return;
        }
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            CellEditableListener cellEditableListener = (CellEditableListener)this.listeners.elementAt(i);
            cellEditableListener.cellEditableEvent(cellEditableEvent);
        }
    }

    private void handleEditingDone() {
        CellEditableEvent cellEditableEvent = new CellEditableEvent((Object)this, CellEditableEvent.Type.EDITING_DONE);
        this.fireCellEditableEvent(cellEditableEvent);
    }

    private void handleRemoveWidget() {
        CellEditableEvent cellEditableEvent = new CellEditableEvent((Object)this, CellEditableEvent.Type.REMOVE_WIDGET);
        this.fireCellEditableEvent(cellEditableEvent);
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("editing_done", "handleEditingDone", (EventType)CellEditableEvent.Type.EDITING_DONE, CellEditable.class$("org.gnu.gtk.event.CellEditableListener"));
        eventMap.addEvent("remove_widget", "handleRemoveWidget", (EventType)CellEditableEvent.Type.REMOVE_WIDGET, CellEditable.class$("org.gnu.gtk.event.CellEditableListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static final native Handle newObject();

    protected static final native int gtk_cell_editable_get_type();

    protected static final native void gtk_cell_editable_start_editing(Handle var0, Handle var1);

    protected static final native void gtk_cell_editable_editing_done(Handle var0);

    protected static final native void gtk_cell_editable_remove_widget(Handle var0);

    static {
        CellEditable.addEvents(evtMap);
    }
}

