/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.CalendarDisplayOptions;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.CalendarEvent;
import org.gnu.gtk.event.CalendarListener;

public class Calendar
extends Widget {
    private Vector calendarListeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.calendarListeners = null;
    }

    public Calendar() {
        super(Calendar.gtk_calendar_new());
        this.finit$();
    }

    public Calendar(Handle handle) {
        super(handle);
        this.finit$();
    }

    public static Calendar getCalendar(Handle handle) {
        if (handle == null) {
            return null;
        }
        Calendar calendar = (Calendar)GObject.getGObjectFromHandle((Handle)handle);
        if (calendar == null) {
            calendar = new Calendar(handle);
        }
        return calendar;
    }

    public void selectMonth(int n, int n2) {
        Calendar.gtk_calendar_select_month(this.getHandle(), n, n2);
    }

    public void selectDay(int n) {
        Calendar.gtk_calendar_select_day(this.getHandle(), n);
    }

    public void markDay(int n) {
        Calendar.gtk_calendar_mark_day(this.getHandle(), n);
    }

    public void unmarkDay(int n) {
        Calendar.gtk_calendar_unmark_day(this.getHandle(), n);
    }

    public void clearMarks() {
        Calendar.gtk_calendar_clear_marks(this.getHandle());
    }

    public void setDisplayOptions(CalendarDisplayOptions calendarDisplayOptions) {
        Calendar.gtk_calendar_set_display_options(this.getHandle(), calendarDisplayOptions.getValue());
    }

    public CalendarDisplayOptions getDisplayOptions() {
        return CalendarDisplayOptions.intern(Calendar.gtk_calendar_get_display_options(this.getHandle()));
    }

    public int[] getDate() {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        Calendar.gtk_calendar_get_date(this.getHandle(), nArray);
        int n = nArray[0];
        int n2 = nArray[1] + 1;
        int n3 = nArray[2];
        nArray2[0] = n;
        nArray2[1] = n2;
        nArray2[2] = n3;
        return nArray2;
    }

    public void freeze() {
        Calendar.gtk_calendar_freeze(this.getHandle());
    }

    public void thaw() {
        Calendar.gtk_calendar_thaw(this.getHandle());
    }

    public void addListener(CalendarListener calendarListener) {
        int n = Widget.findListener(this.calendarListeners, calendarListener);
        if (n == -1) {
            if (this.calendarListeners == null) {
                evtMap.initialize((GObject)this, (EventType)CalendarEvent.Type.DAY_SELECTED);
                evtMap.initialize((GObject)this, (EventType)CalendarEvent.Type.DAY_SELECTED_DOUBLE_CLICK);
                evtMap.initialize((GObject)this, (EventType)CalendarEvent.Type.MONTH_CHANGED_NEXT);
                evtMap.initialize((GObject)this, (EventType)CalendarEvent.Type.MONTH_CHANGED_PREV);
                evtMap.initialize((GObject)this, (EventType)CalendarEvent.Type.YEAR_CHANGED_NEXT);
                evtMap.initialize((GObject)this, (EventType)CalendarEvent.Type.YEAR_CHANGED_PREV);
                this.calendarListeners = new Vector();
            }
            this.calendarListeners.addElement(calendarListener);
        }
    }

    public void removeListener(CalendarListener calendarListener) {
        int n = Widget.findListener(this.calendarListeners, calendarListener);
        if (n > -1) {
            this.calendarListeners.remove(n);
        }
        if (this.calendarListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)CalendarEvent.Type.DAY_SELECTED);
            evtMap.uninitialize((GObject)this, (EventType)CalendarEvent.Type.DAY_SELECTED_DOUBLE_CLICK);
            evtMap.uninitialize((GObject)this, (EventType)CalendarEvent.Type.MONTH_CHANGED_NEXT);
            evtMap.uninitialize((GObject)this, (EventType)CalendarEvent.Type.MONTH_CHANGED_PREV);
            evtMap.uninitialize((GObject)this, (EventType)CalendarEvent.Type.YEAR_CHANGED_NEXT);
            evtMap.uninitialize((GObject)this, (EventType)CalendarEvent.Type.YEAR_CHANGED_PREV);
            this.calendarListeners = null;
        }
    }

    private void fireCalendarEvent(CalendarEvent calendarEvent) {
        if (this.calendarListeners == null) {
            return;
        }
        int n = this.calendarListeners.size();
        for (int i = 0; i < n; ++i) {
            CalendarListener calendarListener = (CalendarListener)this.calendarListeners.elementAt(i);
            calendarListener.calendarEvent(calendarEvent);
        }
    }

    private void handleDaySelected() {
        this.fireCalendarEvent(new CalendarEvent((Object)this, CalendarEvent.Type.DAY_SELECTED));
    }

    private void handleDaySelectedDC() {
        this.fireCalendarEvent(new CalendarEvent((Object)this, CalendarEvent.Type.DAY_SELECTED_DOUBLE_CLICK));
    }

    private void handleNextMonth() {
        this.fireCalendarEvent(new CalendarEvent((Object)this, CalendarEvent.Type.MONTH_CHANGED_NEXT));
    }

    private void handlePrevMonth() {
        this.fireCalendarEvent(new CalendarEvent((Object)this, CalendarEvent.Type.MONTH_CHANGED_PREV));
    }

    private void handleNextYear() {
        this.fireCalendarEvent(new CalendarEvent((Object)this, CalendarEvent.Type.YEAR_CHANGED_NEXT));
    }

    private void handlePrevYear() {
        this.fireCalendarEvent(new CalendarEvent((Object)this, CalendarEvent.Type.YEAR_CHANGED_PREV));
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("day_selected", "handleDaySelected", (EventType)CalendarEvent.Type.DAY_SELECTED, Calendar.class$("org.gnu.gtk.event.CalendarListener"));
        eventMap.addEvent("day_selected_double_click", "handleDaySelectedDC", (EventType)CalendarEvent.Type.DAY_SELECTED_DOUBLE_CLICK, Calendar.class$("org.gnu.gtk.event.CalendarListener"));
        eventMap.addEvent("next_year", "handleNextYear", (EventType)CalendarEvent.Type.YEAR_CHANGED_NEXT, Calendar.class$("org.gnu.gtk.event.CalendarListener"));
        eventMap.addEvent("prev_year", "handlePrevYear", (EventType)CalendarEvent.Type.YEAR_CHANGED_PREV, Calendar.class$("org.gnu.gtk.event.CalendarListener"));
        eventMap.addEvent("next_month", "handleNextMonth", (EventType)CalendarEvent.Type.MONTH_CHANGED_NEXT, Calendar.class$("org.gnu.gtk.event.CalendarListener"));
        eventMap.addEvent("prev_month", "handlePrevMonth", (EventType)CalendarEvent.Type.MONTH_CHANGED_PREV, Calendar.class$("org.gnu.gtk.event.CalendarListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Type getType() {
        return new Type(Calendar.gtk_calendar_get_type());
    }

    protected static final native int gtk_calendar_get_type();

    protected static final native Handle gtk_calendar_new();

    protected static final native int gtk_calendar_select_month(Handle var0, int var1, int var2);

    protected static final native void gtk_calendar_select_day(Handle var0, int var1);

    protected static final native int gtk_calendar_mark_day(Handle var0, int var1);

    protected static final native int gtk_calendar_unmark_day(Handle var0, int var1);

    protected static final native void gtk_calendar_clear_marks(Handle var0);

    protected static final native void gtk_calendar_set_display_options(Handle var0, int var1);

    protected static final native int gtk_calendar_get_display_options(Handle var0);

    private static final native void gtk_calendar_get_date(Handle var0, int[] var1);

    protected static final native void gtk_calendar_freeze(Handle var0);

    protected static final native void gtk_calendar_thaw(Handle var0);

    static {
        Calendar.addEvents(evtMap);
    }
}

