/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.Bin;
import org.gnu.gtk.GtkStockItem;
import org.gnu.gtk.ReliefStyle;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.ButtonEvent;
import org.gnu.gtk.event.ButtonListener;

public class Button
extends Bin {
    private Vector buttonListeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.buttonListeners = null;
    }

    public Button() {
        super(Button.gtk_button_new());
        this.finit$();
    }

    public Button(String string, boolean bl) {
        super(Button.init(string, bl));
        this.finit$();
    }

    private static Handle init(String string, boolean bl) {
        if (bl) {
            return Button.gtk_button_new_with_mnemonic(string);
        }
        return Button.gtk_button_new_with_label(string);
    }

    public Button(GtkStockItem gtkStockItem) {
        super(Button.gtk_button_new_from_stock(gtkStockItem.getString()));
        this.finit$();
    }

    public Button(String string) {
        super(Button.gtk_button_new_from_stock(string));
        this.finit$();
    }

    public Button(Handle handle) {
        super(handle);
        this.finit$();
    }

    public static Button getButton(Handle handle) {
        if (handle == null) {
            return null;
        }
        Button button = (Button)GObject.getGObjectFromHandle((Handle)handle);
        if (button == null) {
            button = new Button(handle);
        }
        return button;
    }

    public void press() {
        Button.gtk_button_pressed(this.getHandle());
    }

    public void release() {
        Button.gtk_button_released(this.getHandle());
    }

    public void click() {
        Button.gtk_button_clicked(this.getHandle());
    }

    public void enter() {
        Button.gtk_button_enter(this.getHandle());
    }

    public void leave() {
        Button.gtk_button_leave(this.getHandle());
    }

    public void setRelief(ReliefStyle reliefStyle) {
        Button.gtk_button_set_relief(this.getHandle(), reliefStyle.getValue());
    }

    public ReliefStyle getRelief() {
        return ReliefStyle.intern(Button.gtk_button_get_relief(this.getHandle()));
    }

    public void setLabel(String string) {
        Button.gtk_button_set_label(this.getHandle(), string);
    }

    public String getLabel() {
        return Button.gtk_button_get_label(this.getHandle());
    }

    public void setUseUnderline(boolean bl) {
        Button.gtk_button_set_use_underline(this.getHandle(), bl);
    }

    public boolean getUseUnderline() {
        return Button.gtk_button_get_use_underline(this.getHandle());
    }

    public void setUseStock(boolean bl) {
        Button.gtk_button_set_use_stock(this.getHandle(), bl);
    }

    public boolean getUseStock() {
        return Button.gtk_button_get_use_stock(this.getHandle());
    }

    public void setFocusOnClick(boolean bl) {
        Button.gtk_button_set_focus_on_click(this.getHandle(), bl);
    }

    public boolean getFocusOnClick() {
        return Button.gtk_button_get_focus_on_click(this.getHandle());
    }

    public void setAlignment(double d, double d2) {
        Button.gtk_button_set_alignment(this.getHandle(), d, d2);
    }

    public double getXAlignment() {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        Button.gtk_button_get_alignment(this.getHandle(), dArray, dArray2);
        return dArray[0];
    }

    public double getYAlignment() {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        Button.gtk_button_get_alignment(this.getHandle(), dArray, dArray2);
        return dArray2[0];
    }

    public void setImage(Widget widget) {
        Button.gtk_button_set_image(this.getHandle(), widget.getHandle());
    }

    public Widget getImage() {
        return Widget.getWidget(Button.gtk_button_get_image(this.getHandle()));
    }

    public void addListener(ButtonListener buttonListener) {
        int n = Widget.findListener(this.buttonListeners, buttonListener);
        if (n == -1) {
            if (this.buttonListeners == null) {
                evtMap.initialize((GObject)this, (EventType)ButtonEvent.Type.ACTIVATE);
                evtMap.initialize((GObject)this, (EventType)ButtonEvent.Type.CLICK);
                evtMap.initialize((GObject)this, (EventType)ButtonEvent.Type.ENTER);
                evtMap.initialize((GObject)this, (EventType)ButtonEvent.Type.LEAVE);
                evtMap.initialize((GObject)this, (EventType)ButtonEvent.Type.PRESS);
                evtMap.initialize((GObject)this, (EventType)ButtonEvent.Type.RELEASE);
                this.buttonListeners = new Vector();
            }
            this.buttonListeners.addElement(buttonListener);
        }
    }

    public void removeListener(ButtonListener buttonListener) {
        int n = Widget.findListener(this.buttonListeners, buttonListener);
        if (n > -1) {
            this.buttonListeners.remove(n);
        }
        if (this.buttonListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)ButtonEvent.Type.ACTIVATE);
            evtMap.uninitialize((GObject)this, (EventType)ButtonEvent.Type.CLICK);
            evtMap.uninitialize((GObject)this, (EventType)ButtonEvent.Type.ENTER);
            evtMap.uninitialize((GObject)this, (EventType)ButtonEvent.Type.LEAVE);
            evtMap.uninitialize((GObject)this, (EventType)ButtonEvent.Type.PRESS);
            evtMap.uninitialize((GObject)this, (EventType)ButtonEvent.Type.RELEASE);
            this.buttonListeners = null;
        }
    }

    protected void fireButtonEvent(ButtonEvent buttonEvent) {
        if (this.buttonListeners == null) {
            return;
        }
        int n = this.buttonListeners.size();
        for (int i = 0; i < n; ++i) {
            ButtonListener buttonListener = (ButtonListener)this.buttonListeners.elementAt(i);
            buttonListener.buttonEvent(buttonEvent);
        }
    }

    private void handleActivate() {
        this.fireButtonEvent(new ButtonEvent((Object)this, ButtonEvent.Type.ACTIVATE));
    }

    private void handleClick() {
        this.fireButtonEvent(new ButtonEvent((Object)this, ButtonEvent.Type.CLICK));
    }

    private void handleEnter() {
        this.fireButtonEvent(new ButtonEvent((Object)this, ButtonEvent.Type.ENTER));
    }

    private void handleLeave() {
        this.fireButtonEvent(new ButtonEvent((Object)this, ButtonEvent.Type.LEAVE));
    }

    private void handlePress() {
        this.fireButtonEvent(new ButtonEvent((Object)this, ButtonEvent.Type.PRESS));
    }

    private void handleRelease() {
        this.fireButtonEvent(new ButtonEvent((Object)this, ButtonEvent.Type.RELEASE));
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("activate", "handleActivate", (EventType)ButtonEvent.Type.ACTIVATE, Button.class$("org.gnu.gtk.event.ButtonListener"));
        eventMap.addEvent("clicked", "handleClick", (EventType)ButtonEvent.Type.CLICK, Button.class$("org.gnu.gtk.event.ButtonListener"));
        eventMap.addEvent("enter", "handleEnter", (EventType)ButtonEvent.Type.ENTER, Button.class$("org.gnu.gtk.event.ButtonListener"));
        eventMap.addEvent("leave", "handleLeave", (EventType)ButtonEvent.Type.LEAVE, Button.class$("org.gnu.gtk.event.ButtonListener"));
        eventMap.addEvent("pressed", "handlePress", (EventType)ButtonEvent.Type.PRESS, Button.class$("org.gnu.gtk.event.ButtonListener"));
        eventMap.addEvent("released", "handleRelease", (EventType)ButtonEvent.Type.RELEASE, Button.class$("org.gnu.gtk.event.ButtonListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Type getType() {
        return new Type(Button.gtk_button_get_type());
    }

    protected static final native int gtk_button_get_type();

    protected static final native Handle gtk_button_new();

    protected static final native Handle gtk_button_new_with_label(String var0);

    protected static final native Handle gtk_button_new_from_stock(String var0);

    protected static final native Handle gtk_button_new_with_mnemonic(String var0);

    protected static final native void gtk_button_pressed(Handle var0);

    protected static final native void gtk_button_released(Handle var0);

    protected static final native void gtk_button_clicked(Handle var0);

    protected static final native void gtk_button_enter(Handle var0);

    protected static final native void gtk_button_leave(Handle var0);

    protected static final native void gtk_button_set_relief(Handle var0, int var1);

    protected static final native int gtk_button_get_relief(Handle var0);

    protected static final native void gtk_button_set_label(Handle var0, String var1);

    protected static final native String gtk_button_get_label(Handle var0);

    protected static final native void gtk_button_set_use_underline(Handle var0, boolean var1);

    protected static final native boolean gtk_button_get_use_underline(Handle var0);

    protected static final native void gtk_button_set_use_stock(Handle var0, boolean var1);

    protected static final native boolean gtk_button_get_use_stock(Handle var0);

    protected static final native void gtk_button_set_focus_on_click(Handle var0, boolean var1);

    protected static final native boolean gtk_button_get_focus_on_click(Handle var0);

    protected static final native void gtk_button_set_alignment(Handle var0, double var1, double var3);

    protected static final native void gtk_button_get_alignment(Handle var0, double[] var1, double[] var2);

    protected static final native void gtk_button_set_image(Handle var0, Handle var1);

    protected static final native Handle gtk_button_get_image(Handle var0);

    static {
        Button.addEvents(evtMap);
    }
}

