/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import org.gnu.gdk.EventKey;
import org.gnu.gdk.KeySymbol;
import org.gnu.gdk.ModifierType;
import org.gnu.glib.Handle;
import org.gnu.glib.MemStruct;
import org.gnu.gtk.PathPriorityType;
import org.gnu.gtk.PathType;

public class BindingSet
extends MemStruct {
    private BindingSet(Handle handle) {
        super(handle);
    }

    public BindingSet(String string) {
        super(BindingSet.gtk_binding_set_new(string));
    }

    public static BindingSet findBindingSet(String string) {
        Handle handle = BindingSet.gtk_binding_set_find(string);
        return BindingSet.getBindingSet(handle);
    }

    private static BindingSet getBindingSet(Handle handle) {
        if (handle == null) {
            return null;
        }
        BindingSet bindingSet = (BindingSet)MemStruct.getMemStructFromHandle((Handle)handle);
        if (bindingSet == null) {
            bindingSet = new BindingSet(handle);
        }
        return bindingSet;
    }

    public boolean activateBindings(int n, ModifierType modifierType) {
        return BindingSet.gtk_bindings_activate(this.getHandle(), n, modifierType.getValue());
    }

    public boolean activateBindings(KeySymbol keySymbol, ModifierType modifierType) {
        return BindingSet.gtk_bindings_activate(this.getHandle(), keySymbol.getValue(), modifierType.getValue());
    }

    public boolean activateBindingSet(int n, ModifierType modifierType) {
        return BindingSet.gtk_binding_set_activate(this.getHandle(), n, modifierType.getValue(), this.getHandle());
    }

    public boolean activateBindingSet(KeySymbol keySymbol, ModifierType modifierType) {
        return BindingSet.gtk_binding_set_activate(this.getHandle(), keySymbol.getValue(), modifierType.getValue(), this.getHandle());
    }

    public void clearEntry(int n, ModifierType modifierType) {
        BindingSet.gtk_binding_entry_clear(this.getHandle(), n, modifierType.getValue());
    }

    public void clearEntry(KeySymbol keySymbol, ModifierType modifierType) {
        BindingSet.gtk_binding_entry_clear(this.getHandle(), keySymbol.getValue(), modifierType.getValue());
    }

    public void addPath(PathType pathType, String string, PathPriorityType pathPriorityType) {
        BindingSet.gtk_binding_set_add_path(this.getHandle(), pathType.getValue(), string, pathPriorityType.getValue());
    }

    public boolean activateEvent(EventKey eventKey) {
        return BindingSet.gtk_bindings_activate_event(this.getHandle(), eventKey.getHandle());
    }

    public void removeEntry(int n, ModifierType modifierType) {
        BindingSet.gtk_binding_entry_remove(this.getHandle(), n, modifierType.getValue());
    }

    public void removeEntry(KeySymbol keySymbol, ModifierType modifierType) {
        BindingSet.gtk_binding_entry_remove(this.getHandle(), keySymbol.getValue(), modifierType.getValue());
    }

    protected static final native Handle gtk_binding_set_new(String var0);

    protected static final native Handle gtk_binding_set_find(String var0);

    protected static final native boolean gtk_bindings_activate(Handle var0, int var1, int var2);

    protected static final native boolean gtk_binding_set_activate(Handle var0, int var1, int var2, Handle var3);

    protected static final native void gtk_binding_entry_clear(Handle var0, int var1, int var2);

    protected static final native void gtk_binding_set_add_path(Handle var0, int var1, String var2, int var3);

    private static final native boolean gtk_bindings_activate_event(Handle var0, Handle var1);

    private static final native void gtk_binding_entry_remove(Handle var0, int var1, int var2);
}

