/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.GtkObject;
import org.gnu.gtk.event.AdjustmentEvent;
import org.gnu.gtk.event.AdjustmentListener;

public class Adjustment
extends GtkObject {
    private Vector adjustmentListeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.adjustmentListeners = null;
    }

    public Adjustment(Handle handle) {
        super(handle);
        this.finit$();
    }

    public static Adjustment getAdjustment(Handle handle) {
        if (handle == null) {
            return null;
        }
        Adjustment adjustment = (Adjustment)GObject.getGObjectFromHandle((Handle)handle);
        if (adjustment == null) {
            adjustment = new Adjustment(handle);
        }
        return adjustment;
    }

    public Adjustment(double d, double d2, double d3, double d4, double d5, double d6) {
        super(Adjustment.gtk_adjustment_new(d, d2, d3, d4, d5, d6));
        this.finit$();
    }

    public void setValue(double d) {
        Adjustment.gtk_adjustment_set_value(this.getHandle(), d);
    }

    public double getValue() {
        return Adjustment.gtk_adjustment_get_value(this.getHandle());
    }

    public double getLower() {
        return Adjustment.getLower(this.getHandle());
    }

    public double getUpper() {
        return Adjustment.getUpper(this.getHandle());
    }

    public double getStepIncrement() {
        return Adjustment.getStepIncrement(this.getHandle());
    }

    public double getPageIncrement() {
        return Adjustment.getPageIncrement(this.getHandle());
    }

    public double getPageSize() {
        return Adjustment.getPageSize(this.getHandle());
    }

    public void clampPage(double d, double d2) {
        Adjustment.gtk_adjustment_clamp_page(this.getHandle(), d, d2);
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("value_changed", "handleValueChanged", (EventType)AdjustmentEvent.Type.VALUE_CHANGED, Adjustment.class$("org.gnu.gtk.event.AdjustmentListener"));
        eventMap.addEvent("changed", "handleChanged", (EventType)AdjustmentEvent.Type.CHANGED, Adjustment.class$("org.gnu.gtk.event.AdjustmentListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void addListener(AdjustmentListener adjustmentListener) {
        int n = Adjustment.findListener(this.adjustmentListeners, adjustmentListener);
        if (n == -1) {
            if (this.adjustmentListeners == null) {
                evtMap.initialize((GObject)this, (EventType)AdjustmentEvent.Type.VALUE_CHANGED);
                evtMap.initialize((GObject)this, (EventType)AdjustmentEvent.Type.CHANGED);
                this.adjustmentListeners = new Vector();
            }
            this.adjustmentListeners.addElement(adjustmentListener);
        }
    }

    public void removeListener(AdjustmentListener adjustmentListener) {
        int n = Adjustment.findListener(this.adjustmentListeners, adjustmentListener);
        if (n > -1) {
            this.adjustmentListeners.remove(n);
        }
        if (this.adjustmentListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)AdjustmentEvent.Type.VALUE_CHANGED);
            evtMap.uninitialize((GObject)this, (EventType)AdjustmentEvent.Type.CHANGED);
            this.adjustmentListeners = null;
        }
    }

    protected void fireAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        if (this.adjustmentListeners == null) {
            return;
        }
        int n = this.adjustmentListeners.size();
        for (int i = 0; i < n; ++i) {
            AdjustmentListener adjustmentListener = (AdjustmentListener)this.adjustmentListeners.elementAt(i);
            adjustmentListener.adjustmentEvent(adjustmentEvent);
        }
    }

    private void handleValueChanged() {
        this.fireAdjustmentEvent(new AdjustmentEvent((Object)this, AdjustmentEvent.Type.VALUE_CHANGED));
    }

    public void handleChanged() {
        this.fireAdjustmentEvent(new AdjustmentEvent((Object)this, AdjustmentEvent.Type.CHANGED));
    }

    protected static int findListener(Vector vector, Object object) {
        if (vector == null || object == null) {
            return -1;
        }
        return vector.indexOf(object);
    }

    public static Type getType() {
        return new Type(Adjustment.gtk_adjustment_get_type());
    }

    public void setLower(double d) {
        this.setDoubleProperty("lower", d);
    }

    public void setPageIncrement(double d) {
        this.setDoubleProperty("page-increment", d);
    }

    public void setPageSize(double d) {
        this.setDoubleProperty("page-size", d);
    }

    public void setStepIncrement(double d) {
        this.setDoubleProperty("step-increment", d);
    }

    public void setUpper(double d) {
        this.setDoubleProperty("upper", d);
    }

    protected static final native double getLower(Handle var0);

    protected static final native double getUpper(Handle var0);

    protected static final native double getStepIncrement(Handle var0);

    protected static final native double getPageIncrement(Handle var0);

    protected static final native double getPageSize(Handle var0);

    protected static final native int gtk_adjustment_get_type();

    protected static final native Handle gtk_adjustment_new(double var0, double var2, double var4, double var6, double var8, double var10);

    protected static final native void gtk_adjustment_changed(Handle var0);

    protected static final native void gtk_adjustment_value_changed(Handle var0);

    protected static final native void gtk_adjustment_clamp_page(Handle var0, double var1, double var3);

    protected static final native double gtk_adjustment_get_value(Handle var0);

    protected static final native void gtk_adjustment_set_value(Handle var0, double var1);

    static {
        Adjustment.addEvents(evtMap);
    }
}

