/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.AccelGroup;
import org.gnu.gtk.IconSize;
import org.gnu.gtk.MenuItem;
import org.gnu.gtk.ToolItem;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.ActionEvent;
import org.gnu.gtk.event.ActionListener;

public class Action
extends GObject {
    protected static EventMap evtMap = new EventMap();
    protected Vector actionListeners;

    private /* synthetic */ void finit$() {
        this.actionListeners = null;
    }

    public Action(String string, String string2, String string3, String string4) {
        super(Action.gtk_action_new(string, string2, string3, string4));
        this.finit$();
    }

    Action(Handle handle) {
        super(handle);
        this.finit$();
    }

    static Action getAction(Handle handle) {
        if (handle == null) {
            return null;
        }
        Action action = (Action)GObject.getGObjectFromHandle((Handle)handle);
        if (action == null) {
            action = new Action(handle);
        }
        return action;
    }

    public String getName() {
        return Action.gtk_action_get_name(this.getHandle());
    }

    public void activate() {
        Action.gtk_action_activate(this.getHandle());
    }

    public Widget createIcon(IconSize iconSize) {
        return new Widget(Action.gtk_action_create_icon(this.getHandle(), iconSize.getValue()));
    }

    public Widget createMenuItem() {
        return new MenuItem(Action.gtk_action_create_menu_item(this.getHandle()));
    }

    public Widget createToolItem() {
        return new ToolItem(Action.gtk_action_create_tool_item(this.getHandle()));
    }

    public void connectProxy(Widget widget) {
        Action.gtk_action_connect_proxy(this.getHandle(), widget.getHandle());
    }

    public void disconnectProxy(Widget widget) {
        Action.gtk_action_disconnect_proxy(this.getHandle(), widget.getHandle());
    }

    public List getProxies() {
        Handle[] handleArray = Action.gtk_action_get_proxies(this.getHandle());
        ArrayList<Widget> arrayList = new ArrayList<Widget>();
        for (int i = 0; i < handleArray.length; ++i) {
            arrayList.add(Widget.getWidget(handleArray[i]));
        }
        return arrayList;
    }

    public void connectAccelerator() {
        Action.gtk_action_connect_accelerator(this.getHandle());
    }

    public void disconnectAccelerator() {
        Action.gtk_action_disconnect_accelerator(this.getHandle());
    }

    public String getAcceleratorPath() {
        return Action.gtk_action_get_accel_path(this.getHandle());
    }

    public boolean isSensitive() {
        return Action.gtk_action_is_sensitive(this.getHandle());
    }

    public void setSensitive(boolean bl) {
        Action.gtk_action_set_sensitive(this.getHandle(), bl);
    }

    public boolean isVisible() {
        return Action.gtk_action_is_visible(this.getHandle());
    }

    public void setVisible(boolean bl) {
        Action.gtk_action_set_visible(this.getHandle(), bl);
    }

    public static Type getType() {
        return new Type(Action.gtk_action_get_type());
    }

    public void setAccelPath(String string) {
        Action.gtk_action_set_accel_path(this.getHandle(), string);
    }

    public void setAccelGroup(AccelGroup accelGroup) {
        if (accelGroup != null) {
            Action.gtk_action_set_accel_group(this.getHandle(), accelGroup.getHandle());
        } else {
            Action.gtk_action_set_accel_group(this.getHandle(), null);
        }
    }

    public void addListener(ActionListener actionListener) {
        int n = Action.findListener(this.actionListeners, actionListener);
        if (n == -1) {
            if (this.actionListeners == null) {
                evtMap.initialize((GObject)this, (EventType)ActionEvent.Type.ACTIVATE);
                this.actionListeners = new Vector();
            }
            this.actionListeners.addElement(actionListener);
        }
    }

    public void removeListener(ActionListener actionListener) {
        int n = Action.findListener(this.actionListeners, actionListener);
        if (n > -1) {
            this.actionListeners.remove(n);
        }
        if (this.actionListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)ActionEvent.Type.ACTIVATE);
            this.actionListeners = null;
        }
    }

    protected void fireActionEvent(ActionEvent actionEvent) {
        if (this.actionListeners == null) {
            return;
        }
        int n = this.actionListeners.size();
        for (int i = 0; i < n; ++i) {
            ActionListener actionListener = (ActionListener)this.actionListeners.elementAt(i);
            actionListener.actionEvent(actionEvent);
        }
    }

    protected void handleActivate() {
        this.fireActionEvent(new ActionEvent((Object)this, ActionEvent.Type.ACTIVATE));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static int findListener(Vector vector, Object object) {
        if (vector == null || object == null) {
            return -1;
        }
        return vector.indexOf(object);
    }

    protected static final native int gtk_action_get_type();

    protected static final native Handle gtk_action_new(String var0, String var1, String var2, String var3);

    protected static final native String gtk_action_get_name(Handle var0);

    protected static final native void gtk_action_activate(Handle var0);

    protected static final native Handle gtk_action_create_icon(Handle var0, int var1);

    protected static final native Handle gtk_action_create_menu_item(Handle var0);

    protected static final native Handle gtk_action_create_tool_item(Handle var0);

    protected static final native void gtk_action_connect_proxy(Handle var0, Handle var1);

    protected static final native void gtk_action_disconnect_proxy(Handle var0, Handle var1);

    protected static final native Handle[] gtk_action_get_proxies(Handle var0);

    protected static final native void gtk_action_connect_accelerator(Handle var0);

    protected static final native void gtk_action_disconnect_accelerator(Handle var0);

    protected static final native String gtk_action_get_accel_path(Handle var0);

    protected static final native void gtk_action_set_accel_path(Handle var0, String var1);

    protected static final native boolean gtk_action_is_sensitive(Handle var0);

    protected static final native boolean gtk_action_get_sensitive(Handle var0);

    protected static final native void gtk_action_set_sensitive(Handle var0, boolean var1);

    protected static final native boolean gtk_action_is_visible(Handle var0);

    protected static final native boolean gtk_action_get_visible(Handle var0);

    protected static final native void gtk_action_set_visible(Handle var0, boolean var1);

    protected static final native void gtk_action_set_accel_group(Handle var0, Handle var1);

    static {
        evtMap.addEvent("activate", "handleActivate", (EventType)ActionEvent.Type.ACTIVATE, Action.class$("org.gnu.gtk.event.ActionEvent"));
    }
}

