/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gdk;

import org.gnu.gdk.Colormap;
import org.gnu.gdk.Cursor;
import org.gnu.gdk.Dimension;
import org.gnu.gdk.Point;
import org.gnu.gdk.Visual;
import org.gnu.glib.Handle;
import org.gnu.glib.MemStruct;

public class WindowAttr
extends MemStruct {
    public WindowAttr(Handle handle) {
        super(handle);
    }

    public WindowAttr() {
        super(WindowAttr.gdk_window_attr_new());
    }

    public String getTitle() {
        return WindowAttr.getTitle(this.getHandle());
    }

    public void setTitle(String string) {
        if (string != null) {
            WindowAttr.setTitle(this.getHandle(), string);
        }
    }

    public int getEventMask() {
        return WindowAttr.getEventMask(this.getHandle());
    }

    public void setEventMask(int n) {
        WindowAttr.setEventMask(this.getHandle(), n);
    }

    public Point getPosition() {
        int n = WindowAttr.getX(this.getHandle());
        int n2 = WindowAttr.getY(this.getHandle());
        return new Point(n, n2);
    }

    public void setPosition(int n, int n2) {
        WindowAttr.setX(this.getHandle(), n);
        WindowAttr.setY(this.getHandle(), n2);
    }

    public void setDimension(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            WindowAttr.setWidth(this.getHandle(), n);
            WindowAttr.setHeight(this.getHandle(), n2);
        }
    }

    public Dimension getDimension() {
        int n = WindowAttr.getWidth(this.getHandle());
        int n2 = WindowAttr.getHeight(this.getHandle());
        return new Dimension(n, n2);
    }

    public Visual getVisual() {
        return Visual.getVisualFromHandle(WindowAttr.getVisual(this.getHandle()));
    }

    public void setVisual(Visual visual) {
        WindowAttr.setVisual(this.getHandle(), visual.getHandle());
    }

    public Colormap getColormap() {
        return Colormap.getColormapFromHandle(WindowAttr.getColormap(this.getHandle()));
    }

    public void setColormap(Colormap colormap) {
        WindowAttr.setColormap(this.getHandle(), colormap.getHandle());
    }

    public Cursor getCursor() {
        return Cursor.getCursorFromHandle(WindowAttr.getCursor(this.getHandle()));
    }

    public void setCursor(Cursor cursor) {
        WindowAttr.setCursor(this.getHandle(), cursor.getHandle());
    }

    protected static final native Handle gdk_window_attr_new();

    protected static final native String getTitle(Handle var0);

    protected static final native void setTitle(Handle var0, String var1);

    protected static final native int getEventMask(Handle var0);

    protected static final native void setEventMask(Handle var0, int var1);

    protected static final native int getX(Handle var0);

    protected static final native void setX(Handle var0, int var1);

    protected static final native int getY(Handle var0);

    protected static final native void setY(Handle var0, int var1);

    protected static final native int getWidth(Handle var0);

    protected static final native void setWidth(Handle var0, int var1);

    protected static final native int getHeight(Handle var0);

    protected static final native void setHeight(Handle var0, int var1);

    protected static final native int getWclass(Handle var0);

    protected static final native void setWclass(Handle var0, int var1);

    protected static final native Handle getVisual(Handle var0);

    protected static final native void setVisual(Handle var0, Handle var1);

    protected static final native Handle getColormap(Handle var0);

    protected static final native void setColormap(Handle var0, Handle var1);

    protected static final native int getWindowType(Handle var0);

    protected static final native void setWindowType(Handle var0, int var1);

    protected static final native Handle getCursor(Handle var0);

    protected static final native void setCursor(Handle var0, Handle var1);

    protected static final native String getWmclassName(Handle var0);

    protected static final native void setWmclassName(Handle var0, String var1);

    protected static final native String getWmclassClass(Handle var0);

    protected static final native void setWmclassClass(Handle var0, String var1);

    protected static final native boolean getOverrideRedirect(Handle var0);

    protected static final native void setOverrideRedirect(Handle var0, boolean var1);
}

