/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gdk;

import org.gnu.gdk.Bitmap;
import org.gnu.gdk.Color;
import org.gnu.gdk.Cursor;
import org.gnu.gdk.Drawable;
import org.gnu.gdk.EventMask;
import org.gnu.gdk.Geometry;
import org.gnu.gdk.GrabStatus;
import org.gnu.gdk.ModifierType;
import org.gnu.gdk.Pixbuf;
import org.gnu.gdk.Pixmap;
import org.gnu.gdk.Point;
import org.gnu.gdk.Rectangle;
import org.gnu.gdk.Region;
import org.gnu.gdk.WindowAttr;
import org.gnu.gdk.WindowHints;
import org.gnu.gdk.WindowState;
import org.gnu.gdk.WindowTypeHint;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;

public class Window
extends Drawable {
    public Window(Handle handle) {
        super(handle);
    }

    public Window(Window window, WindowAttr windowAttr, int n) {
        super(Window.gdk_window_new(window.getHandle(), windowAttr.getHandle(), n));
    }

    public void destroy() {
        Window.gdk_window_destroy(this.getHandle());
    }

    public Window getWindowAt(int n, int n2) {
        return Window.getWindowFromHandle(Window.gdk_window_at_pointer());
    }

    public Window getWindowAtPointer() {
        return Window.getWindowFromHandle(Window.gdk_window_at_pointer());
    }

    public void show() {
        Window.gdk_window_show(this.getHandle());
    }

    public void hide() {
        Window.gdk_window_hide(this.getHandle());
    }

    public void withdraw() {
        Window.gdk_window_withdraw(this.getHandle());
    }

    public void showUnraised() {
        Window.gdk_window_show_unraised(this.getHandle());
    }

    public void move(int n, int n2) {
        Window.gdk_window_move(this.getHandle(), n, n2);
    }

    public void resize(int n, int n2) {
        Window.gdk_window_resize(this.getHandle(), n, n2);
    }

    public void moveAndResize(int n, int n2, int n3, int n4) {
        Window.gdk_window_move_resize(this.getHandle(), n, n2, n3, n4);
    }

    public void reparent(Window window, int n, int n2) {
        Window.gdk_window_reparent(this.getHandle(), window.getHandle(), n, n2);
    }

    public void clear() {
        Window.gdk_window_clear(this.getHandle());
    }

    public void clearArea(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            Window.gdk_window_clear_area_e(this.getHandle(), n, n2, n3, n4);
        } else {
            Window.gdk_window_clear_area(this.getHandle(), n, n2, n3, n4);
        }
    }

    public void raise() {
        Window.gdk_window_raise(this.getHandle());
    }

    public void lower() {
        Window.gdk_window_lower(this.getHandle());
    }

    public void getKeyboardFocus() {
        Window.gdk_window_focus(this.getHandle());
    }

    public void setUnmanaged(boolean bl) {
        Window.gdk_window_set_override_redirect(this.getHandle(), bl);
    }

    public void scrollContent(int n, int n2) {
        Window.gdk_window_scroll(this.getHandle(), n, n2);
    }

    public void setBitmapMask(Bitmap bitmap, int n, int n2) {
        Window.gdk_window_shape_combine_mask(this.getHandle(), bitmap.getHandle(), n, n2);
    }

    public void setRegionMask(Region region, int n, int n2) {
        Window.gdk_window_shape_combine_region(this.getHandle(), region.getHandle(), n, n2);
    }

    public void setChildMask(boolean bl) {
        if (bl) {
            Window.gdk_window_set_child_shapes(this.getHandle());
        }
    }

    public void mergeChildShapes() {
        Window.gdk_window_merge_child_shapes(this.getHandle());
    }

    public boolean isVisible() {
        return Window.gdk_window_is_visible(this.getHandle());
    }

    public boolean isViewable() {
        return Window.gdk_window_is_viewable(this.getHandle());
    }

    public WindowState getWindowState() {
        return WindowState.intern(Window.gdk_window_get_state(this.getHandle()));
    }

    public void setHint(WindowTypeHint windowTypeHint) {
        if (windowTypeHint != null && !this.isVisible()) {
            Window.gdk_window_set_type_hint(this.getHandle(), windowTypeHint.getValue());
        }
    }

    public static Window[] getTopLevelWindows() {
        Handle[] handleArray = Window.gdk_window_get_toplevels();
        Window[] windowArray = new Window[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            windowArray[i] = Window.getWindowFromHandle(handleArray[i]);
        }
        return windowArray;
    }

    public int getWidth() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        Window.gdk_window_get_geometry(this.getHandle(), nArray, nArray2, nArray3, nArray4, nArray5);
        return nArray3[0];
    }

    public int getHeight() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        Window.gdk_window_get_geometry(this.getHandle(), nArray, nArray2, nArray3, nArray4, nArray5);
        return nArray4[0];
    }

    public void setEvents(EventMask eventMask) {
        Window.gdk_window_set_events(this.getHandle(), eventMask.getValue());
    }

    public EventMask getEvents() {
        return EventMask.intern(Window.gdk_window_get_events(this.getHandle()));
    }

    public boolean setStaticGravities(boolean bl) {
        return Window.gdk_window_set_static_gravities(this.getHandle(), bl);
    }

    public void setModalHint(boolean bl) {
        Window.gdk_window_set_modal_hint(this.getHandle(), bl);
    }

    public void setGeometryHints(Geometry geometry, WindowHints windowHints) {
        Window.gdk_window_set_geometry_hints(this.getHandle(), geometry.getHandle(), windowHints.getValue());
    }

    public void beginPaintRectangle(Rectangle rectangle) {
        Window.gdk_window_begin_paint_rect(this.getHandle(), rectangle.getHandle());
    }

    public void beginPaintRegion(Region region) {
        Window.gdk_window_begin_paint_region(this.getHandle(), region.getHandle());
    }

    public void endPaint() {
        Window.gdk_window_end_paint(this.getHandle());
    }

    public void invalidateRect(Rectangle rectangle, boolean bl) {
        Window.gdk_window_invalidate_rect(this.getHandle(), rectangle.getHandle(), bl);
    }

    public void invalidateRegion(Region region, boolean bl) {
        Window.gdk_window_invalidate_region(this.getHandle(), region.getHandle(), bl);
    }

    public void setTitle(String string) {
        Window.gdk_window_set_title(this.getHandle(), string);
    }

    public void setRole(String string) {
        Window.gdk_window_set_role(this.getHandle(), string);
    }

    public void setTransientOf(Window window) {
        Window.gdk_window_set_transient_for(this.getHandle(), window.getHandle());
    }

    public void setBackground(Color color) {
        Window.gdk_window_set_background(this.getHandle(), color.getHandle());
    }

    public void setBackground(Pixmap pixmap, boolean bl) {
        Window.gdk_window_set_back_pixmap(this.getHandle(), pixmap.getHandle(), bl);
    }

    public void setCursor(Cursor cursor) {
        Window.gdk_window_set_cursor(this.getHandle(), cursor.getHandle());
    }

    public Point getPosition() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Window.gdk_window_get_position(this.getHandle(), nArray, nArray2);
        return new Point(nArray[0], nArray2[0]);
    }

    public Point getOrigin() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Window.gdk_window_get_origin(this.getHandle(), nArray, nArray2);
        return new Point(nArray[0], nArray2[0]);
    }

    public Point getRootOrigin() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Window.gdk_window_get_root_origin(this.getHandle(), nArray, nArray2);
        return new Point(nArray[0], nArray2[0]);
    }

    public Rectangle getFrameExtents() {
        Handle handle = Window.gdk_window_get_frame_extents(this.getHandle());
        return Rectangle.getRectangleFromHandle(handle);
    }

    public Window getParent() {
        return Window.getWindowFromHandle(Window.gdk_window_get_parent(this.getHandle()));
    }

    public Window getToplevel() {
        return Window.getWindowFromHandle(Window.gdk_window_get_toplevel(this.getHandle()));
    }

    public Window[] getChildren() {
        Handle[] handleArray = Window.gdk_window_get_children(this.getHandle());
        if (handleArray == null) {
            return null;
        }
        Window[] windowArray = new Window[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            windowArray[i] = Window.getWindowFromHandle(handleArray[i]);
        }
        return windowArray;
    }

    public void setIconList(Pixbuf[] pixbufArray) {
        if (pixbufArray == null) {
            return;
        }
        Handle[] handleArray = new Handle[pixbufArray.length];
        for (int i = 0; i < pixbufArray.length; ++i) {
            handleArray[i] = pixbufArray[i].getHandle();
        }
        Window.gdk_window_set_icon_list(this.getHandle(), handleArray);
    }

    public void setIcon(Window window, Pixmap pixmap, Bitmap bitmap) {
        Window.gdk_window_set_icon(this.getHandle(), window.getHandle(), pixmap.getHandle(), bitmap.getHandle());
    }

    public void setIconName(String string) {
        Window.gdk_window_set_icon_name(this.getHandle(), string);
    }

    public void iconify() {
        Window.gdk_window_iconify(this.getHandle());
    }

    public void deiconify() {
        Window.gdk_window_deiconify(this.getHandle());
    }

    public void stick() {
        Window.gdk_window_stick(this.getHandle());
    }

    public void unstick() {
        Window.gdk_window_unstick(this.getHandle());
    }

    public void maximize() {
        Window.gdk_window_maximize(this.getHandle());
    }

    public void unmaximize() {
        Window.gdk_window_unmaximize(this.getHandle());
    }

    public GrabStatus grabPointer(boolean bl, EventMask eventMask, Window window, Cursor cursor, int n) {
        return GrabStatus.intern(Window.gdk_pointer_grab(this.getHandle(), bl, eventMask.getValue(), window.getHandle(), cursor.getHandle(), n));
    }

    public void ungrabPointer(int n) {
        Window.gdk_pointer_ungrab(n);
    }

    public boolean pointerIsGrabbed() {
        return Window.gdk_pointer_is_grabbed();
    }

    public GrabStatus grabKeyboard(boolean bl, int n) {
        return GrabStatus.intern(Window.gdk_keyboard_grab(this.getHandle(), bl, n));
    }

    public void ungrabKeyboard(int n) {
        Window.gdk_keyboard_ungrab(n);
    }

    public static Type getType() {
        return new Type(Window.gdk_window_object_get_type());
    }

    public static Window getWindowFromHandle(Handle handle) {
        if (handle != null) {
            GObject gObject = GObject.getGObjectFromHandle((Handle)handle);
            if (gObject != null) {
                return (Window)gObject;
            }
            return new Window(handle);
        }
        return null;
    }

    public Window getPointerWindow() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        Handle handle = Window.gdk_window_get_pointer(this.getHandle(), nArray, nArray2, nArray3);
        return Window.getWindowFromHandle(handle);
    }

    public Point getPointerLocation() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        Window.gdk_window_get_pointer(this.getHandle(), nArray, nArray2, nArray3);
        return new Point(nArray[0], nArray2[0]);
    }

    public ModifierType getPointerModifierType() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        Window.gdk_window_get_pointer(this.getHandle(), nArray, nArray2, nArray3);
        return ModifierType.intern(nArray3[0]);
    }

    protected static final native Handle gdk_window_new(Handle var0, Handle var1, int var2);

    protected static final native int gdk_window_get_window_type(Handle var0);

    protected static final native void gdk_window_destroy(Handle var0);

    protected static final native Handle gdk_window_at_pointer();

    protected static final native void gdk_window_show(Handle var0);

    protected static final native void gdk_window_hide(Handle var0);

    protected static final native void gdk_window_withdraw(Handle var0);

    protected static final native void gdk_window_show_unraised(Handle var0);

    protected static final native void gdk_window_move(Handle var0, int var1, int var2);

    protected static final native void gdk_window_resize(Handle var0, int var1, int var2);

    protected static final native void gdk_window_move_resize(Handle var0, int var1, int var2, int var3, int var4);

    protected static final native void gdk_window_reparent(Handle var0, Handle var1, int var2, int var3);

    protected static final native void gdk_window_clear(Handle var0);

    protected static final native void gdk_window_clear_area(Handle var0, int var1, int var2, int var3, int var4);

    protected static final native void gdk_window_clear_area_e(Handle var0, int var1, int var2, int var3, int var4);

    protected static final native void gdk_window_raise(Handle var0);

    protected static final native void gdk_window_lower(Handle var0);

    protected static final native void gdk_window_focus(Handle var0);

    protected static final native void gdk_window_set_user_data(Handle var0, Object var1);

    protected static final native void gdk_window_set_override_redirect(Handle var0, boolean var1);

    protected static final native void gdk_window_scroll(Handle var0, int var1, int var2);

    protected static final native void gdk_window_shape_combine_mask(Handle var0, Handle var1, int var2, int var3);

    protected static final native void gdk_window_shape_combine_region(Handle var0, Handle var1, int var2, int var3);

    protected static final native void gdk_window_set_child_shapes(Handle var0);

    protected static final native void gdk_window_merge_child_shapes(Handle var0);

    protected static final native boolean gdk_window_is_visible(Handle var0);

    protected static final native boolean gdk_window_is_viewable(Handle var0);

    protected static final native int gdk_window_get_state(Handle var0);

    protected static final native boolean gdk_window_set_static_gravities(Handle var0, boolean var1);

    protected static final native Handle gdk_window_foreign_new(int var0);

    protected static final native void gdk_window_set_type_hint(Handle var0, int var1);

    protected static final native void gdk_window_set_modal_hint(Handle var0, boolean var1);

    protected static final native void gdk_window_set_geometry_hints(Handle var0, Handle var1, int var2);

    protected static final native void gdk_window_begin_paint_rect(Handle var0, Handle var1);

    protected static final native void gdk_window_begin_paint_region(Handle var0, Handle var1);

    protected static final native void gdk_window_end_paint(Handle var0);

    protected static final native void gdk_window_set_title(Handle var0, String var1);

    protected static final native void gdk_window_set_role(Handle var0, String var1);

    protected static final native void gdk_window_set_transient_for(Handle var0, Handle var1);

    protected static final native void gdk_window_set_background(Handle var0, Handle var1);

    protected static final native void gdk_window_set_back_pixmap(Handle var0, Handle var1, boolean var2);

    protected static final native void gdk_window_set_cursor(Handle var0, Handle var1);

    protected static final native void gdk_window_get_geometry(Handle var0, int[] var1, int[] var2, int[] var3, int[] var4, int[] var5);

    protected static final native void gdk_window_get_position(Handle var0, int[] var1, int[] var2);

    protected static final native int gdk_window_get_origin(Handle var0, int[] var1, int[] var2);

    protected static final native void gdk_window_get_root_origin(Handle var0, int[] var1, int[] var2);

    protected static final native Handle gdk_window_get_frame_extents(Handle var0);

    protected static final native Handle gdk_window_get_parent(Handle var0);

    protected static final native Handle gdk_window_get_toplevel(Handle var0);

    protected static final native Handle[] gdk_window_get_children(Handle var0);

    protected static final native Handle[] gdk_window_peek_children(Handle var0);

    protected static final native int gdk_window_get_events(Handle var0);

    protected static final native void gdk_window_set_events(Handle var0, int var1);

    protected static final native void gdk_window_set_icon_list(Handle var0, Handle[] var1);

    protected static final native void gdk_window_set_icon(Handle var0, Handle var1, Handle var2, Handle var3);

    protected static final native void gdk_window_set_icon_name(Handle var0, String var1);

    protected static final native void gdk_window_set_group(Handle var0, Handle var1);

    protected static final native void gdk_window_set_decorations(Handle var0, int var1);

    protected static final native void gdk_window_set_functions(Handle var0, int var1);

    protected static final native Handle[] gdk_window_get_toplevels();

    protected static final native void gdk_window_iconify(Handle var0);

    protected static final native void gdk_window_deiconify(Handle var0);

    protected static final native void gdk_window_stick(Handle var0);

    protected static final native void gdk_window_unstick(Handle var0);

    protected static final native void gdk_window_maximize(Handle var0);

    protected static final native void gdk_window_unmaximize(Handle var0);

    protected static final native void gdk_window_register_dnd(Handle var0);

    protected static final native void gdk_window_begin_resize_drag(Handle var0, int var1, int var2, int var3, int var4, int var5);

    protected static final native void gdk_window_begin_move_drag(Handle var0, int var1, int var2, int var3, int var4);

    protected static final native void gdk_window_invalidate_rect(Handle var0, Handle var1, boolean var2);

    protected static final native void gdk_window_invalidate_region(Handle var0, Handle var1, boolean var2);

    protected static final native Handle gdk_window_get_update_area(Handle var0);

    protected static final native void gdk_window_freeze_updates(Handle var0);

    protected static final native void gdk_window_thaw_updates(Handle var0);

    protected static final native void gdk_window_process_all_updates();

    protected static final native void gdk_window_process_updates(Handle var0, boolean var1);

    protected static final native void gdk_window_set_debug_updates(boolean var0);

    protected static final native void gdk_window_constrain_size(Handle var0, int var1, int var2, int var3, int[] var4, int[] var5);

    protected static final native void gdk_window_get_internal_paint_info(Handle var0, Handle var1, int[] var2, int[] var3);

    private static final native int gdk_window_object_get_type();

    private static final native int gdk_pointer_grab(Handle var0, boolean var1, int var2, Handle var3, Handle var4, int var5);

    private static final native int gdk_keyboard_grab(Handle var0, boolean var1, int var2);

    private static final native void gdk_pointer_ungrab(int var0);

    private static final native void gdk_keyboard_ungrab(int var0);

    private static final native boolean gdk_pointer_is_grabbed();

    private static final native Handle gdk_window_get_pointer(Handle var0, int[] var1, int[] var2, int[] var3);
}

