/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gdk;

import org.gnu.gdk.ByteOrder;
import org.gnu.gdk.Screen;
import org.gnu.gdk.VisualType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;

public class Visual
extends GObject {
    protected Visual(Handle handle) {
        super(handle);
    }

    public static int getBestDepth() {
        return Visual.gdk_visual_get_best_depth();
    }

    public static VisualType getBestVisualType() {
        return VisualType.getVisualType(Visual.gdk_visual_get_best_type());
    }

    public static Visual getSystemVisual() {
        return Visual.getVisualFromHandle(Visual.gdk_visual_get_system());
    }

    public static Visual getVisual() {
        return Visual.getVisualFromHandle(Visual.gdk_visual_get_best());
    }

    public static Visual getVisual(int n) {
        return Visual.getVisualFromHandle(Visual.gdk_visual_get_best_with_depth(n));
    }

    public static Visual getVisual(VisualType visualType) {
        return Visual.getVisualFromHandle(Visual.gdk_visual_get_best_with_type(visualType.getValue()));
    }

    public static Visual getVisual(int n, VisualType visualType) {
        return Visual.getVisualFromHandle(Visual.gdk_visual_get_best_with_both(n, visualType.getValue()));
    }

    public int getDepth() {
        return Visual.getDepth(this.getHandle());
    }

    public ByteOrder getByteOrder() {
        return ByteOrder.intern(Visual.getByteOrder(this.getHandle()));
    }

    public int getColormapSize() {
        return Visual.getColormapSize(this.getHandle());
    }

    public int getBitsPerRGB() {
        return Visual.getBitsPerRgb(this.getHandle());
    }

    public int getRedMask() {
        return Visual.getRedMask(this.getHandle());
    }

    public int getRedShift() {
        return Visual.getRedShift(this.getHandle());
    }

    public int getRedPrec() {
        return Visual.getRedPrec(this.getHandle());
    }

    public int getGreenMask() {
        return Visual.getGreenMask(this.getHandle());
    }

    public int getGreenShift() {
        return Visual.getGreenShift(this.getHandle());
    }

    public int getGreenPrec() {
        return Visual.getGreenPrec(this.getHandle());
    }

    public int getBlueMask() {
        return Visual.getBlueMask(this.getHandle());
    }

    public int getBlueShift() {
        return Visual.getBlueShift(this.getHandle());
    }

    public int getBluePrec() {
        return Visual.getBluePrec(this.getHandle());
    }

    public Screen getScreen() {
        return Screen.getScreenFromHandle(Visual.gdk_visual_get_screen(this.getHandle()));
    }

    static Visual getVisualFromHandle(Handle handle) {
        if (handle != null) {
            GObject gObject = GObject.getGObjectFromHandle((Handle)handle);
            if (gObject != null) {
                return (Visual)gObject;
            }
            return new Visual(handle);
        }
        return null;
    }

    protected static final native int getDepth(Handle var0);

    protected static final native int getByteOrder(Handle var0);

    protected static final native int getColormapSize(Handle var0);

    protected static final native int getBitsPerRgb(Handle var0);

    protected static final native int getRedMask(Handle var0);

    protected static final native int getRedShift(Handle var0);

    protected static final native int getRedPrec(Handle var0);

    protected static final native int getGreenMask(Handle var0);

    protected static final native int getGreenShift(Handle var0);

    protected static final native int getGreenPrec(Handle var0);

    protected static final native int getBlueMask(Handle var0);

    protected static final native int getBlueShift(Handle var0);

    protected static final native int getBluePrec(Handle var0);

    protected static final native int gdk_visual_get_type();

    protected static final native int gdk_visual_get_best_depth();

    protected static final native int gdk_visual_get_best_type();

    protected static final native Handle gdk_visual_get_system();

    protected static final native Handle gdk_visual_get_best();

    protected static final native Handle gdk_visual_get_best_with_depth(int var0);

    protected static final native Handle gdk_visual_get_best_with_type(int var0);

    protected static final native Handle gdk_visual_get_best_with_both(int var0, int var1);

    protected static final native Handle gdk_visual_get_screen(Handle var0);
}

