/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gdk;

import org.gnu.gdk.Colormap;
import org.gnu.gdk.Display;
import org.gnu.gdk.Event;
import org.gnu.gdk.Rectangle;
import org.gnu.gdk.Visual;
import org.gnu.gdk.Window;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;

public class Screen
extends GObject {
    public Screen() {
        super(Screen.gdk_screen_get_default());
    }

    public Screen(Handle handle) {
        super(handle);
    }

    public Colormap getDefaultColormap() {
        return Colormap.getColormapFromHandle(Screen.gdk_screen_get_default_colormap(this.getHandle()));
    }

    public void setDefaultColormap(Colormap colormap) {
        Screen.gdk_screen_set_default_colormap(this.getHandle(), colormap.getHandle());
    }

    public Colormap getSystemColormap() {
        return Colormap.getColormapFromHandle(Screen.gdk_screen_get_system_colormap(this.getHandle()));
    }

    public Visual getSystemVisual() {
        return Visual.getVisualFromHandle(Screen.gdk_screen_get_system_visual(this.getHandle()));
    }

    public Colormap getRGBColormap() {
        return Colormap.getColormapFromHandle(Screen.gdk_screen_get_rgb_colormap(this.getHandle()));
    }

    public Colormap getRGBAColormap() {
        return Colormap.getColormapFromHandle(Screen.gdk_screen_get_rgba_colormap(this.getHandle()));
    }

    public Visual getRGBVisual() {
        return Visual.getVisualFromHandle(Screen.gdk_screen_get_rgb_visual(this.getHandle()));
    }

    public Visual getRGBAVisual() {
        return Visual.getVisualFromHandle(Screen.gdk_screen_get_rgba_visual(this.getHandle()));
    }

    public Window getRootWindow() {
        return Window.getWindowFromHandle(Screen.gdk_screen_get_root_window(this.getHandle()));
    }

    public Display getDisplay() {
        return Display.getDisplayFromHandle(Screen.gdk_screen_get_display(this.getHandle()));
    }

    public int getNumber() {
        return Screen.gdk_screen_get_number(this.getHandle());
    }

    public int getHeight() {
        return Screen.gdk_screen_get_height(this.getHandle());
    }

    public int getWidth() {
        return Screen.gdk_screen_get_width(this.getHandle());
    }

    public int getHeightMM() {
        return Screen.gdk_screen_get_height_mm(this.getHandle());
    }

    public int getWidthMM() {
        return Screen.gdk_screen_get_width_mm(this.getHandle());
    }

    public Visual[] listVisuals() {
        Handle[] handleArray = Screen.gdk_screen_list_visuals(this.getHandle());
        Visual[] visualArray = new Visual[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            visualArray[i] = Visual.getVisualFromHandle(handleArray[i]);
        }
        return visualArray;
    }

    public Window[] getToplevelWindows() {
        Handle[] handleArray = Screen.gdk_screen_get_toplevel_windows(this.getHandle());
        Window[] windowArray = new Window[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            windowArray[i] = Window.getWindowFromHandle(handleArray[i]);
        }
        return windowArray;
    }

    public String makeDisplayName() {
        return Screen.gdk_screen_make_display_name(this.getHandle());
    }

    public int getNumMonitors() {
        return Screen.gdk_screen_get_n_monitors(this.getHandle());
    }

    public Rectangle getMonitorGeometry(int n) {
        Handle handle = Screen.gdk_screen_get_monitor_geometry(this.getHandle(), n);
        return Rectangle.getRectangleFromHandle(handle);
    }

    public int getMonitorAtPoint(int n, int n2) {
        return Screen.gdk_screen_get_monitor_at_point(this.getHandle(), n, n2);
    }

    public int getMonitorAtWindow(Window window) {
        return Screen.gdk_screen_get_monitor_at_window(this.getHandle(), window.getHandle());
    }

    public void broadcastClientMessage(Event event) {
        Screen.gdk_screen_broadcast_client_message(this.getHandle(), event.getHandle());
    }

    public Type getType() {
        return new Type(Screen.gdk_screen_get_type());
    }

    public static Screen getScreenFromHandle(Handle handle) {
        if (handle == null) {
            return null;
        }
        Screen screen = (Screen)GObject.getGObjectFromHandle((Handle)handle);
        if (screen == null) {
            screen = new Screen(handle);
        }
        return screen;
    }

    protected static final native int gdk_screen_get_type();

    protected static final native Handle gdk_screen_get_default_colormap(Handle var0);

    protected static final native void gdk_screen_set_default_colormap(Handle var0, Handle var1);

    protected static final native Handle gdk_screen_get_system_colormap(Handle var0);

    protected static final native Handle gdk_screen_get_system_visual(Handle var0);

    protected static final native Handle gdk_screen_get_rgb_colormap(Handle var0);

    protected static final native Handle gdk_screen_get_rgba_colormap(Handle var0);

    protected static final native Handle gdk_screen_get_rgb_visual(Handle var0);

    protected static final native Handle gdk_screen_get_rgba_visual(Handle var0);

    protected static final native Handle gdk_screen_get_root_window(Handle var0);

    protected static final native Handle gdk_screen_get_display(Handle var0);

    protected static final native int gdk_screen_get_number(Handle var0);

    static final native int gdk_screen_get_height(Handle var0);

    static final native int gdk_screen_get_width(Handle var0);

    protected static final native int gdk_screen_get_height_mm(Handle var0);

    protected static final native int gdk_screen_get_width_mm(Handle var0);

    protected static final native Handle[] gdk_screen_list_visuals(Handle var0);

    protected static final native Handle[] gdk_screen_get_toplevel_windows(Handle var0);

    protected static final native String gdk_screen_make_display_name(Handle var0);

    protected static final native int gdk_screen_get_n_monitors(Handle var0);

    protected static final native Handle gdk_screen_get_monitor_geometry(Handle var0, int var1);

    protected static final native int gdk_screen_get_monitor_at_point(Handle var0, int var1, int var2);

    protected static final native int gdk_screen_get_monitor_at_window(Handle var0, Handle var1);

    protected static final native void gdk_screen_broadcast_client_message(Handle var0, Handle var1);

    static final native Handle gdk_screen_get_default();
}

