/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gdk;

import org.gnu.gdk.FillRule;
import org.gnu.gdk.OverlapType;
import org.gnu.gdk.Point;
import org.gnu.gdk.Rectangle;
import org.gnu.glib.Handle;
import org.gnu.glib.MemStruct;

public class Region
extends MemStruct {
    Region(Handle handle) {
        super(handle);
    }

    public Region() {
        super(Region.gdk_region_new());
    }

    public Region(Point[] pointArray, FillRule fillRule) {
        super(Region.init(pointArray, fillRule));
    }

    public Region(Region region) {
        super(Region.gdk_region_copy(region.getHandle()));
    }

    public Region(Rectangle rectangle) {
        super(Region.gdk_region_rectangle(rectangle.getHandle()));
    }

    public Rectangle getClipbox() {
        Handle handle = Rectangle.gdk_rectangle_new();
        Region.gdk_region_get_clipbox(this.getHandle(), handle);
        return Rectangle.getRectangleFromHandle(handle);
    }

    public Rectangle[] getRectangles() {
        Handle[] handleArray = Region.gdk_region_get_rectangles(this.getHandle());
        if (handleArray == null) {
            return null;
        }
        Rectangle[] rectangleArray = new Rectangle[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            rectangleArray[i] = Rectangle.getRectangleFromHandle(handleArray[i]);
        }
        return rectangleArray;
    }

    public boolean isEmpty() {
        return Region.gdk_region_empty(this.getHandle());
    }

    public boolean isEqual(Region region) {
        return Region.gdk_region_equal(this.getHandle(), region.getHandle());
    }

    public boolean containsPoint(int n, int n2) {
        return Region.gdk_region_point_in(this.getHandle(), n, n2);
    }

    public OverlapType containsRectangle(Rectangle rectangle) {
        return OverlapType.intern(Region.gdk_region_rect_in(this.getHandle(), rectangle.getHandle()));
    }

    public void offset(int n, int n2) {
        Region.gdk_region_offset(this.getHandle(), n, n2);
    }

    public void shrink(int n, int n2) {
        Region.gdk_region_shrink(this.getHandle(), n, n2);
    }

    public void unionWithRect(Rectangle rectangle) {
        Region.gdk_region_union_with_rect(this.getHandle(), rectangle.getHandle());
    }

    public void intersect(Region region) {
        Region.gdk_region_intersect(this.getHandle(), region.getHandle());
    }

    public void union(Region region) {
        Region.gdk_region_union(this.getHandle(), region.getHandle());
    }

    public void subtract(Region region) {
        Region.gdk_region_subtract(this.getHandle(), region.getHandle());
    }

    public void xor(Region region) {
        Region.gdk_region_xor(this.getHandle(), region.getHandle());
    }

    private static Handle init(Point[] pointArray, FillRule fillRule) {
        Handle[] handleArray = new Handle[pointArray.length];
        for (int i = 0; i < pointArray.length; ++i) {
            handleArray[i] = pointArray[i].getHandle();
        }
        return Region.gdk_region_polygon(handleArray, fillRule.getValue());
    }

    static Region getRegionFromHandle(Handle handle) {
        if (handle != null) {
            MemStruct memStruct = MemStruct.getMemStructFromHandle((Handle)handle);
            if (memStruct != null) {
                return (Region)memStruct;
            }
            return new Region(handle);
        }
        return null;
    }

    protected static final native Handle gdk_region_new();

    protected static final native Handle gdk_region_polygon(Handle[] var0, int var1);

    protected static final native Handle gdk_region_copy(Handle var0);

    protected static final native Handle gdk_region_rectangle(Handle var0);

    protected static final native void gdk_region_get_clipbox(Handle var0, Handle var1);

    protected static final native Handle[] gdk_region_get_rectangles(Handle var0);

    protected static final native boolean gdk_region_empty(Handle var0);

    protected static final native boolean gdk_region_equal(Handle var0, Handle var1);

    protected static final native boolean gdk_region_point_in(Handle var0, int var1, int var2);

    protected static final native int gdk_region_rect_in(Handle var0, Handle var1);

    protected static final native void gdk_region_offset(Handle var0, int var1, int var2);

    protected static final native void gdk_region_shrink(Handle var0, int var1, int var2);

    protected static final native void gdk_region_union_with_rect(Handle var0, Handle var1);

    protected static final native void gdk_region_intersect(Handle var0, Handle var1);

    protected static final native void gdk_region_union(Handle var0, Handle var1);

    protected static final native void gdk_region_subtract(Handle var0, Handle var1);

    protected static final native void gdk_region_xor(Handle var0, Handle var1);
}

