/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gdk;

import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;

public class Rectangle
extends Boxed {
    public Rectangle() {
        super(Rectangle.gdk_rectangle_new());
    }

    public Rectangle(int n, int n2, int n3, int n4) {
        super(Rectangle.gdk_rectangle_new());
        this.setX(n);
        this.setY(n2);
        this.setWidth(n3);
        this.setHeight(n4);
    }

    public Rectangle(Handle handle) {
        super(handle);
    }

    public static Rectangle getRectangle(Handle handle) {
        if (handle == null) {
            return null;
        }
        Rectangle rectangle = (Rectangle)Boxed.getBoxedFromHandle((Handle)handle);
        if (rectangle == null) {
            rectangle = new Rectangle(handle);
        }
        return rectangle;
    }

    public int getX() {
        return Rectangle.getX(this.getHandle());
    }

    public void setX(int n) {
        this.setX(this.getHandle(), n);
    }

    public int getY() {
        return Rectangle.getY(this.getHandle());
    }

    public void setY(int n) {
        this.setY(this.getHandle(), n);
    }

    public int getWidth() {
        return Rectangle.getWidth(this.getHandle());
    }

    public void setWidth(int n) {
        this.setWidth(this.getHandle(), n);
    }

    public int getHeight() {
        return Rectangle.getHeight(this.getHandle());
    }

    public void setHeight(int n) {
        this.setHeight(this.getHandle(), n);
    }

    public Rectangle intersect(Rectangle rectangle) {
        Handle handle = Rectangle.gdk_rectangle_intersect(this.getHandle(), rectangle.getHandle());
        return Rectangle.getRectangle(handle);
    }

    public Rectangle union(Rectangle rectangle) {
        Handle handle = Rectangle.gdk_rectangle_union(this.getHandle(), rectangle.getHandle());
        return Rectangle.getRectangle(handle);
    }

    public static Type getType() {
        return new Type(Rectangle.gdk_rectangle_get_type());
    }

    static Rectangle getRectangleFromHandle(Handle handle) {
        if (handle != null) {
            Boxed boxed = Boxed.getBoxedFromHandle((Handle)handle);
            if (boxed != null) {
                return (Rectangle)boxed;
            }
            return new Rectangle(handle);
        }
        return null;
    }

    protected static final native int getX(Handle var0);

    protected final native void setX(Handle var1, int var2);

    protected static final native int getY(Handle var0);

    protected final native void setY(Handle var1, int var2);

    protected static final native int getWidth(Handle var0);

    protected final native void setWidth(Handle var1, int var2);

    protected static final native int getHeight(Handle var0);

    protected final native void setHeight(Handle var1, int var2);

    protected static final native Handle gdk_rectangle_intersect(Handle var0, Handle var1);

    protected static final native Handle gdk_rectangle_union(Handle var0, Handle var1);

    protected static final native Handle gdk_rectangle_new();

    protected static final native void gdk_rectangle_free(Handle var0);

    protected static final native int gdk_rectangle_get_type();
}

