/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gdk;

import java.io.IOException;
import java.io.InputStream;
import org.gnu.gdk.Pixbuf;
import org.gnu.gdk.PixbufAnimation;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;

public class PixbufLoader
extends GObject {
    public PixbufLoader() {
        super(PixbufLoader.gdk_pixbuf_loader_new());
    }

    public PixbufLoader(String string) {
        super(PixbufLoader.gdk_pixbuf_loader_new_with_type(string, 0));
    }

    public boolean write(byte[] byArray) {
        int n = 0;
        return PixbufLoader.gdk_pixbuf_loader_write(this.getHandle(), byArray, byArray.length, n);
    }

    public boolean write(byte[] byArray, int n) {
        int n2 = 0;
        return PixbufLoader.gdk_pixbuf_loader_write(this.getHandle(), byArray, n, n2);
    }

    public boolean write(InputStream inputStream) {
        boolean bl = true;
        int n = 0;
        byte[] byArray = new byte[1024];
        try {
            while ((n = inputStream.read(byArray)) != -1) {
                bl = bl && this.write(byArray, n);
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public Pixbuf getPixbuf() {
        return Pixbuf.getPixbufFromHandle(PixbufLoader.gdk_pixbuf_loader_get_pixbuf(this.getHandle()));
    }

    public PixbufAnimation getPixbufAnimation() {
        Handle handle = PixbufLoader.gdk_pixbuf_loader_get_animation(this.getHandle());
        if (handle != null) {
            GObject gObject = GObject.getGObjectFromHandle((Handle)handle);
            if (gObject != null) {
                return (PixbufAnimation)gObject;
            }
            return new PixbufAnimation(handle);
        }
        return null;
    }

    public boolean close() {
        int n = 0;
        return PixbufLoader.gdk_pixbuf_loader_close(this.getHandle(), n);
    }

    protected static final native int gdk_pixbuf_loader_get_type();

    protected static final native Handle gdk_pixbuf_loader_new();

    protected static final native Handle gdk_pixbuf_loader_new_with_type(String var0, int var1);

    protected static final native boolean gdk_pixbuf_loader_write(Handle var0, byte[] var1, int var2, int var3);

    protected static final native Handle gdk_pixbuf_loader_get_pixbuf(Handle var0);

    protected static final native Handle gdk_pixbuf_loader_get_animation(Handle var0);

    protected static final native boolean gdk_pixbuf_loader_close(Handle var0, int var1);
}

