/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gdk;

import org.gnu.gdk.Pixbuf;
import org.gnu.gdk.PixbufAnimationIter;
import org.gnu.glib.Error;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.JGException;
import org.gnu.glib.Struct;

public class PixbufAnimation
extends GObject {
    public PixbufAnimation(String string) throws JGException {
        super(PixbufAnimation.init(string));
    }

    public PixbufAnimation(Handle handle) {
        super(handle);
    }

    private static Handle init(String string) throws JGException {
        Handle handle = Struct.getNullHandle();
        Handle handle2 = PixbufAnimation.gdk_pixbuf_animation_new_from_file(string, handle);
        if (!handle.isNull()) {
            throw new JGException(new Error(handle));
        }
        return handle2;
    }

    public int width() {
        return PixbufAnimation.gdk_pixbuf_animation_get_width(this.getHandle());
    }

    public int height() {
        return PixbufAnimation.gdk_pixbuf_animation_get_height(this.getHandle());
    }

    public PixbufAnimationIter getIter(long l, long l2) {
        Handle handle = PixbufAnimation.gdk_pixbuf_animation_get_iter(this.getHandle(), l, l2);
        if (handle != null) {
            GObject gObject = GObject.getGObjectFromHandle((Handle)handle);
            if (gObject != null) {
                return (PixbufAnimationIter)gObject;
            }
            return new PixbufAnimationIter(handle);
        }
        return null;
    }

    public boolean isStaticImage() {
        return PixbufAnimation.gdk_pixbuf_animation_is_static_image(this.getHandle());
    }

    public Pixbuf getStaticImage() {
        return Pixbuf.getPixbufFromHandle(PixbufAnimation.gdk_pixbuf_animation_get_static_image(this.getHandle()));
    }

    protected static final native int gdk_pixbuf_animation_get_type();

    protected static final native Handle gdk_pixbuf_animation_new_from_file(String var0, Handle var1);

    protected static final native int gdk_pixbuf_animation_get_width(Handle var0);

    protected static final native int gdk_pixbuf_animation_get_height(Handle var0);

    protected static final native Handle gdk_pixbuf_animation_get_iter(Handle var0, long var1, long var3);

    protected static final native boolean gdk_pixbuf_animation_is_static_image(Handle var0);

    protected static final native Handle gdk_pixbuf_animation_get_static_image(Handle var0);
}

