/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gdk;

import java.io.File;
import java.io.FileNotFoundException;
import org.gnu.gdk.Colormap;
import org.gnu.gdk.Colorspace;
import org.gnu.gdk.Drawable;
import org.gnu.gdk.Image;
import org.gnu.gdk.InterpType;
import org.gnu.gdk.PixbufFormat;
import org.gnu.gdk.PixbufRotation;
import org.gnu.glib.Error;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.JGException;
import org.gnu.glib.Struct;
import org.gnu.glib.Type;

public class Pixbuf
extends GObject {
    public Pixbuf(Handle handle) {
        super(handle);
    }

    public Pixbuf(String string) throws FileNotFoundException, JGException {
        super(Pixbuf.createWithFile(string));
    }

    public Pixbuf(String string, int n, int n2, boolean bl) throws FileNotFoundException, JGException {
        super(Pixbuf.createWithFileSized(string, n, n2, bl));
    }

    public Pixbuf(Colorspace colorspace, boolean bl, int n, int n2, int n3) {
        super(Pixbuf.gdk_pixbuf_new(colorspace.getValue(), bl, n, n2, n3));
    }

    public Pixbuf(byte[] byArray) {
        super(Pixbuf.gdk_pixbuf_new_from_xpm_data(byArray));
    }

    public Pixbuf(byte[] byArray, boolean bl) throws JGException {
        super(Pixbuf.createInline(byArray, bl));
    }

    public Pixbuf(Pixbuf pixbuf, int n, int n2, int n3, int n4) {
        super(Pixbuf.gdk_pixbuf_new_subpixbuf(pixbuf.getHandle(), n, n2, n3, n4));
    }

    public Pixbuf(Drawable drawable, Colormap colormap, int n, int n2, int n3, int n4, int n5, int n6) {
        super(Pixbuf.gdk_pixbuf_get_from_drawable(drawable.getHandle(), colormap.getHandle(), n, n2, n3, n4, n5, n6));
    }

    public Pixbuf(Image image, Colormap colormap, int n, int n2, int n3, int n4, int n5, int n6) {
        super(Pixbuf.gdk_pixbuf_get_from_drawable(image.getHandle(), colormap.getHandle(), n, n2, n3, n4, n5, n6));
    }

    private static Handle createInline(byte[] byArray, boolean bl) throws JGException {
        Handle handle = Struct.getNullHandle();
        Handle handle2 = Pixbuf.gdk_pixbuf_new_from_inline(byArray.length, byArray, bl, handle);
        if (!handle.isNull()) {
            throw new JGException(new Error(handle));
        }
        return handle2;
    }

    private static Handle createWithFile(String string) throws FileNotFoundException, JGException {
        Pixbuf.checkFileExists(string);
        Handle handle = Struct.getNullHandle();
        Handle handle2 = Pixbuf.gdk_pixbuf_new_from_file(string, handle);
        if (!handle.isNull()) {
            throw new JGException(new Error(handle));
        }
        return handle2;
    }

    private static Handle createWithFileSized(String string, int n, int n2, boolean bl) throws FileNotFoundException, JGException {
        Pixbuf.checkFileExists(string);
        Handle handle = Struct.getNullHandle();
        Handle handle2 = bl ? Pixbuf.gdk_pixbuf_new_from_file_at_scale(string, n, n2, bl, handle) : Pixbuf.gdk_pixbuf_new_from_file_at_size(string, n, n2, handle);
        if (!handle.isNull()) {
            throw new JGException(new Error(handle));
        }
        return handle2;
    }

    private static void checkFileExists(String string) throws FileNotFoundException {
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException(string);
        }
    }

    public static PixbufFormat getFileInformation(String string) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Handle handle = Pixbuf.gdk_pixbuf_get_file_info(string, nArray, nArray2);
        return PixbufFormat.getPixbufFormat(handle);
    }

    public Pixbuf copy() {
        return Pixbuf.getPixbufFromHandle(Pixbuf.gdk_pixbuf_copy(this.getHandle()));
    }

    public void copyArea(int n, int n2, int n3, int n4, Pixbuf pixbuf, int n5, int n6) {
        Pixbuf.gdk_pixbuf_copy_area(this.getHandle(), n, n2, n3, n4, pixbuf.getHandle(), n5, n6);
    }

    public int width() {
        return Pixbuf.gdk_pixbuf_get_width(this.getHandle());
    }

    public int height() {
        return Pixbuf.gdk_pixbuf_get_height(this.getHandle());
    }

    public Pixbuf scale(int n, int n2, InterpType interpType) {
        return Pixbuf.getPixbufFromHandle(Pixbuf.gdk_pixbuf_scale_simple(this.getHandle(), n, n2, interpType.getValue()));
    }

    public Pixbuf scale(Pixbuf pixbuf, int n, int n2, int n3, int n4, double d, double d2, double d3, double d4, InterpType interpType) {
        Pixbuf.gdk_pixbuf_scale(this.getHandle(), pixbuf.getHandle(), n, n2, n3, n4, d, d2, d3, d4, interpType.getValue());
        return pixbuf;
    }

    public Pixbuf composite(int n, int n2, InterpType interpType, int n3, int n4, int n5, int n6) {
        return Pixbuf.getPixbufFromHandle(Pixbuf.gdk_pixbuf_composite_color_simple(this.getHandle(), n, n2, interpType.getValue(), n3, n4, n5, n6));
    }

    public Pixbuf composite(Pixbuf pixbuf, int n, int n2, int n3, int n4, double d, double d2, double d3, double d4, InterpType interpType, int n5) {
        Pixbuf.gdk_pixbuf_composite(this.getHandle(), pixbuf.getHandle(), n, n2, n3, n4, d, d2, d3, d4, interpType.getValue(), n5);
        return pixbuf;
    }

    public Pixbuf composite(Pixbuf pixbuf, int n, int n2, int n3, int n4, double d, double d2, double d3, double d4, InterpType interpType, int n5, int n6, int n7, int n8, int n9, int n10) {
        Pixbuf.gdk_pixbuf_composite_color(this.getHandle(), pixbuf.getHandle(), n, n2, n3, n4, d, d2, d3, d4, interpType.getValue(), n5, n6, n7, n8, n9, n10);
        return pixbuf;
    }

    public Pixbuf rotate(PixbufRotation pixbufRotation) {
        return Pixbuf.getPixbufFromHandle(Pixbuf.gdk_pixbuf_rotate_simple(this.getHandle(), pixbufRotation.getValue()));
    }

    public Pixbuf flip(boolean bl) {
        return Pixbuf.getPixbufFromHandle(Pixbuf.gdk_pixbuf_flip(this.getHandle(), bl));
    }

    public Colorspace getColorspace() {
        return Colorspace.intern(Pixbuf.gdk_pixbuf_get_colorspace(this.getHandle()));
    }

    public int getNumChannels() {
        return Pixbuf.gdk_pixbuf_get_n_channels(this.getHandle());
    }

    public boolean hasAlpha() {
        return Pixbuf.gdk_pixbuf_get_has_alpha(this.getHandle());
    }

    public int getBitsPerSample() {
        return Pixbuf.gdk_pixbuf_get_bits_per_sample(this.getHandle());
    }

    public byte[] getPixels() {
        return Pixbuf.gdk_pixbuf_get_pixels(this.getHandle());
    }

    public int getRowstride() {
        return Pixbuf.gdk_pixbuf_get_rowstride(this.getHandle());
    }

    public String getOption(String string) {
        return Pixbuf.gdk_pixbuf_get_option(this.getHandle(), string);
    }

    public void save(String string, String string2, String[] stringArray, String[] stringArray2) throws JGException {
        Handle handle = Struct.getNullHandle();
        boolean bl = Pixbuf.gdk_pixbuf_savev(this.getHandle(), string, string2, stringArray, stringArray2, handle);
        if (!bl) {
            throw new JGException(new Error(handle));
        }
    }

    public byte[] saveToBuffer(String string, String[] stringArray, String[] stringArray2) throws JGException {
        Handle handle = Struct.getNullHandle();
        byte[] byArray = Pixbuf.gdk_pixbuf_save_to_bufferv(this.getHandle(), string, stringArray, stringArray2, handle);
        if (!handle.isNull()) {
            throw new JGException(new Error(handle));
        }
        return byArray;
    }

    public Pixbuf addAlpha(boolean bl, int n, int n2, int n3) {
        return Pixbuf.getPixbufFromHandle(Pixbuf.gdk_pixbuf_add_alpha(this.getHandle(), bl, n, n2, n3));
    }

    public void fill(int n) {
        Pixbuf.gdk_pixbuf_fill(this.getHandle(), n);
    }

    public Pixbuf saturateAndPixelate(Pixbuf pixbuf, double d, boolean bl) {
        Pixbuf.gdk_pixbuf_saturate_and_pixelate(this.getHandle(), pixbuf.getHandle(), d, bl);
        return pixbuf;
    }

    public static Type getType() {
        return new Type(Pixbuf.gdk_pixbuf_get_type());
    }

    public static Pixbuf getPixbufFromHandle(Handle handle) {
        if (handle != null) {
            GObject gObject = GObject.getGObjectFromHandle((Handle)handle);
            if (gObject != null) {
                return (Pixbuf)gObject;
            }
            return new Pixbuf(handle);
        }
        return null;
    }

    protected static final native Handle gdk_pixbuf_get_from_drawable(Handle var0, Handle var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected static final native Handle gdk_pixbuf_get_from_image(Handle var0, Handle var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected static final native int gdk_pixbuf_get_colorspace(Handle var0);

    protected static final native int gdk_pixbuf_get_n_channels(Handle var0);

    protected static final native boolean gdk_pixbuf_get_has_alpha(Handle var0);

    protected static final native int gdk_pixbuf_get_bits_per_sample(Handle var0);

    protected static final native byte[] gdk_pixbuf_get_pixels(Handle var0);

    protected static final native int gdk_pixbuf_get_width(Handle var0);

    protected static final native int gdk_pixbuf_get_height(Handle var0);

    protected static final native int gdk_pixbuf_get_rowstride(Handle var0);

    protected static final native Handle gdk_pixbuf_new(int var0, boolean var1, int var2, int var3, int var4);

    protected static final native Handle gdk_pixbuf_copy(Handle var0);

    protected static final native Handle gdk_pixbuf_new_subpixbuf(Handle var0, int var1, int var2, int var3, int var4);

    protected static final native Handle gdk_pixbuf_new_from_file(String var0, Handle var1);

    protected static final native Handle gdk_pixbuf_new_from_file_at_size(String var0, int var1, int var2, Handle var3);

    protected static final native Handle gdk_pixbuf_new_from_file_at_scale(String var0, int var1, int var2, boolean var3, Handle var4);

    protected static final native Handle gdk_pixbuf_get_file_info(String var0, int[] var1, int[] var2);

    protected static final native Handle gdk_pixbuf_new_from_xpm_data(byte[] var0);

    protected static final native Handle gdk_pixbuf_new_from_inline(int var0, byte[] var1, boolean var2, Handle var3);

    protected static final native boolean gdk_pixbuf_savev(Handle var0, String var1, String var2, String[] var3, String[] var4, Handle var5);

    protected static final native byte[] gdk_pixbuf_save_to_bufferv(Handle var0, String var1, String[] var2, String[] var3, Handle var4);

    protected static final native Handle gdk_pixbuf_rotate_simple(Handle var0, int var1);

    protected static final native Handle gdk_pixbuf_flip(Handle var0, boolean var1);

    protected static final native void gdk_pixbuf_fill(Handle var0, int var1);

    protected static final native Handle gdk_pixbuf_add_alpha(Handle var0, boolean var1, int var2, int var3, int var4);

    protected static final native void gdk_pixbuf_copy_area(Handle var0, int var1, int var2, int var3, int var4, Handle var5, int var6, int var7);

    protected static final native void gdk_pixbuf_saturate_and_pixelate(Handle var0, Handle var1, double var2, boolean var4);

    protected static final native void gdk_pixbuf_scale(Handle var0, Handle var1, int var2, int var3, int var4, int var5, double var6, double var8, double var10, double var12, int var14);

    protected static final native void gdk_pixbuf_composite(Handle var0, Handle var1, int var2, int var3, int var4, int var5, double var6, double var8, double var10, double var12, int var14, int var15);

    protected static final native void gdk_pixbuf_composite_color(Handle var0, Handle var1, int var2, int var3, int var4, int var5, double var6, double var8, double var10, double var12, int var14, int var15, int var16, int var17, int var18, int var19, int var20);

    protected static final native Handle gdk_pixbuf_scale_simple(Handle var0, int var1, int var2, int var3);

    protected static final native Handle gdk_pixbuf_composite_color_simple(Handle var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected static final native String gdk_pixbuf_get_option(Handle var0, String var1);

    private static final native int gdk_pixbuf_get_type();
}

