/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gdk;

import org.gnu.gdk.Bitmap;
import org.gnu.gdk.CapStyle;
import org.gnu.gdk.Color;
import org.gnu.gdk.Colormap;
import org.gnu.gdk.Drawable;
import org.gnu.gdk.Fill;
import org.gnu.gdk.Function;
import org.gnu.gdk.JoinStyle;
import org.gnu.gdk.LineStyle;
import org.gnu.gdk.Pixmap;
import org.gnu.gdk.Rectangle;
import org.gnu.gdk.Region;
import org.gnu.gdk.Screen;
import org.gnu.gdk.SubwindowMode;
import org.gnu.gdk.Window;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;

public class GC
extends GObject {
    public GC(Handle handle) {
        super(handle);
    }

    public GC(Window window) {
        super(GC.gdk_gc_new(window.getHandle()));
    }

    public GC(Drawable drawable) {
        super(GC.gdk_gc_new(drawable.getHandle()));
    }

    public static GC getDefaultGC(Drawable drawable) {
        return new GC(GC.gdk_gc_new(drawable.getHandle()));
    }

    public int getClipXOrigin() {
        return GC.getClipXOrigin(this.getHandle());
    }

    public int getClipYOrigin() {
        return GC.getClipYOrigin(this.getHandle());
    }

    public int getTsXOrigin() {
        return GC.getTsXOrigin(this.getHandle());
    }

    public int getTsYOrigin() {
        return GC.getTsYOrigin(this.getHandle());
    }

    public void setForeground(Color color) {
        GC.gdk_gc_set_foreground(this.getHandle(), color.getHandle());
    }

    public void setBackground(Color color) {
        GC.gdk_gc_set_background(this.getHandle(), color.getHandle());
    }

    public void setRGBForeground(Color color) {
        GC.gdk_gc_set_rgb_fg_color(this.getHandle(), color.getHandle());
    }

    public void setRGBBackground(Color color) {
        GC.gdk_gc_set_rgb_bg_color(this.getHandle(), color.getHandle());
    }

    public void setFunction(Function function) {
        GC.gdk_gc_set_function(this.getHandle(), function.getValue());
    }

    public void setFillMode(Fill fill) {
        GC.gdk_gc_set_fill(this.getHandle(), fill.getValue());
    }

    public void setTile(Pixmap pixmap) {
        GC.gdk_gc_set_tile(this.getHandle(), pixmap.getHandle());
    }

    public void setStipple(Pixmap pixmap) {
        GC.gdk_gc_set_stipple(this.getHandle(), pixmap.getHandle());
    }

    public void setOrigin(int n, int n2) {
        GC.gdk_gc_set_ts_origin(this.getHandle(), n, n2);
    }

    public void setClipOrigin(int n, int n2) {
        GC.gdk_gc_set_clip_origin(this.getHandle(), n, n2);
    }

    public void setClipRectangle(Rectangle rectangle) {
        GC.gdk_gc_set_clip_rectangle(this.getHandle(), rectangle.getHandle());
    }

    public void setClipRegion(Region region) {
        GC.gdk_gc_set_clip_region(this.getHandle(), region.getHandle());
    }

    public void setClipMask(Bitmap bitmap) {
        GC.gdk_gc_set_clip_mask(this.getHandle(), bitmap.getHandle());
    }

    public void setSubwindow(SubwindowMode subwindowMode) {
        GC.gdk_gc_set_subwindow(this.getHandle(), subwindowMode.getValue());
    }

    public void setExposures(boolean bl) {
        GC.gdk_gc_set_exposures(this.getHandle(), bl);
    }

    public void setLineAttributes(int n, LineStyle lineStyle, CapStyle capStyle, JoinStyle joinStyle) {
        GC.gdk_gc_set_line_attributes(this.getHandle(), n, lineStyle.getValue(), capStyle.getValue(), joinStyle.getValue());
    }

    public void setDashes(int n, int[] nArray) {
        GC.gdk_gc_set_dashes(this.getHandle(), n, nArray, nArray.length);
    }

    public void offset(int n, int n2) {
        GC.gdk_gc_offset(this.getHandle(), n, n2);
    }

    public void copy(GC gC) {
        GC.gdk_gc_copy(this.getHandle(), gC.getHandle());
    }

    public void setColormap(Colormap colormap) {
        GC.gdk_gc_set_colormap(this.getHandle(), colormap.getHandle());
    }

    public Colormap getColormap() {
        return Colormap.getColormapFromHandle(GC.gdk_gc_get_colormap(this.getHandle()));
    }

    public Screen getScreen() {
        return Screen.getScreenFromHandle(GC.gdk_gc_get_screen(this.getHandle()));
    }

    protected static final native int getClipXOrigin(Handle var0);

    protected static final native int getClipYOrigin(Handle var0);

    protected static final native int getTsXOrigin(Handle var0);

    protected static final native int getTsYOrigin(Handle var0);

    protected static final native int gdk_gc_get_type();

    protected static final native Handle gdk_gc_new(Handle var0);

    protected static final native Handle gdk_gc_get_screen(Handle var0);

    protected static final native void gdk_gc_set_foreground(Handle var0, Handle var1);

    protected static final native void gdk_gc_set_background(Handle var0, Handle var1);

    protected static final native void gdk_gc_set_rgb_fg_color(Handle var0, Handle var1);

    protected static final native void gdk_gc_set_rgb_bg_color(Handle var0, Handle var1);

    protected static final native void gdk_gc_set_function(Handle var0, int var1);

    protected static final native void gdk_gc_set_fill(Handle var0, int var1);

    protected static final native void gdk_gc_set_tile(Handle var0, Handle var1);

    protected static final native void gdk_gc_set_stipple(Handle var0, Handle var1);

    protected static final native void gdk_gc_set_ts_origin(Handle var0, int var1, int var2);

    protected static final native void gdk_gc_set_clip_origin(Handle var0, int var1, int var2);

    protected static final native void gdk_gc_set_clip_mask(Handle var0, Handle var1);

    protected static final native void gdk_gc_set_clip_rectangle(Handle var0, Handle var1);

    protected static final native void gdk_gc_set_clip_region(Handle var0, Handle var1);

    protected static final native void gdk_gc_set_subwindow(Handle var0, int var1);

    protected static final native void gdk_gc_set_exposures(Handle var0, boolean var1);

    protected static final native void gdk_gc_set_line_attributes(Handle var0, int var1, int var2, int var3, int var4);

    protected static final native void gdk_gc_set_dashes(Handle var0, int var1, int[] var2, int var3);

    protected static final native void gdk_gc_copy(Handle var0, Handle var1);

    protected static final native void gdk_gc_set_colormap(Handle var0, Handle var1);

    protected static final native Handle gdk_gc_get_colormap(Handle var0);

    protected static final native void gdk_gc_offset(Handle var0, int var1, int var2);
}

