/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gdk;

import org.gnu.gdk.EventExpose;
import org.gnu.gdk.EventType;
import org.gnu.gdk.Window;
import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;

public class Event
extends Boxed {
    public Event(EventType eventType) {
        super(Event.gdk_event_new(eventType.getValue()));
    }

    public Event(Event event) {
        super(Event.gdk_event_copy(event.getHandle()));
    }

    Event(Handle handle) {
        super(handle);
    }

    public static boolean eventsPending() {
        return Event.gdk_events_pending();
    }

    public static Event peek() {
        return Event.getEventFromHandle(Event.gdk_event_peek());
    }

    public static Event get() {
        return Event.getEventFromHandle(Event.gdk_event_get());
    }

    public static EventExpose getGraphicsExpose(Window window) {
        Handle handle = Event.gdk_event_get_graphics_expose(window.getHandle());
        if (handle == null) {
            return null;
        }
        return new EventExpose(handle);
    }

    public static void put(Event event) {
        Event.gdk_event_put(event.getHandle());
    }

    public int getTime() {
        return Event.gdk_event_get_time(this.getHandle());
    }

    static Event getEventFromHandle(Handle handle) {
        if (handle != null) {
            Boxed boxed = Boxed.getBoxedFromHandle((Handle)handle);
            if (boxed != null) {
                return (Event)boxed;
            }
            return new Event(handle);
        }
        return null;
    }

    protected static final native int getType(Handle var0);

    protected static final native Handle gdk_event_get();

    protected static final native Handle gdk_event_peek();

    protected static final native Handle gdk_event_get_graphics_expose(Handle var0);

    protected static final native void gdk_event_put(Handle var0);

    protected static final native Handle gdk_event_new(int var0);

    protected static final native Handle gdk_event_copy(Handle var0);

    protected static final native int gdk_event_get_time(Handle var0);

    protected static final native boolean gdk_event_get_coords(Handle var0, double[] var1, double[] var2);

    protected static final native boolean gdk_event_get_root_coords(Handle var0, double[] var1, double[] var2);

    protected static final native boolean gdk_event_get_axis(Handle var0, int var1, double[] var2);

    protected static final native boolean gdk_events_pending();
}

