/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gdk;

import org.gnu.gdk.Color;
import org.gnu.gdk.Colormap;
import org.gnu.gdk.Dimension;
import org.gnu.gdk.Display;
import org.gnu.gdk.GC;
import org.gnu.gdk.Image;
import org.gnu.gdk.Pixbuf;
import org.gnu.gdk.Point;
import org.gnu.gdk.Region;
import org.gnu.gdk.RgbCmap;
import org.gnu.gdk.RgbDither;
import org.gnu.gdk.Screen;
import org.gnu.gdk.Segment;
import org.gnu.gdk.Visual;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.pango.Font;
import org.gnu.pango.GlyphString;
import org.gnu.pango.Layout;
import org.gnu.pango.LayoutLine;

public class Drawable
extends GObject {
    Drawable(Handle handle) {
        super(handle);
    }

    public Dimension getSize() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Drawable.gdk_drawable_get_size(this.getHandle(), nArray, nArray2);
        return new Dimension(nArray[0], nArray2[0]);
    }

    public int getWidth() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Drawable.gdk_drawable_get_size(this.getHandle(), nArray, nArray2);
        return nArray[0];
    }

    public int getHeight() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Drawable.gdk_drawable_get_size(this.getHandle(), nArray, nArray2);
        return nArray2[0];
    }

    public void setColormap(Colormap colormap) {
        Drawable.gdk_drawable_set_colormap(this.getHandle(), colormap.getHandle());
    }

    public Colormap getColormap() {
        return Colormap.getColormapFromHandle(Drawable.gdk_drawable_get_colormap(this.getHandle()));
    }

    public Visual getVisual() {
        return Visual.getVisualFromHandle(Drawable.gdk_drawable_get_visual(this.getHandle()));
    }

    public int getDepth() {
        return Drawable.gdk_drawable_get_depth(this.getHandle());
    }

    public Image getImage(int n, int n2, int n3, int n4) {
        Handle handle = Drawable.gdk_drawable_get_image(this.getHandle(), n, n2, n3, n4);
        if (handle != null) {
            GObject gObject = GObject.getGObjectFromHandle((Handle)handle);
            if (gObject != null) {
                return (Image)gObject;
            }
            return new Image(handle);
        }
        return null;
    }

    public Region getClipRegion() {
        return Region.getRegionFromHandle(Drawable.gdk_drawable_get_clip_region(this.getHandle()));
    }

    public Region getVisibleRegion() {
        return Region.getRegionFromHandle(Drawable.gdk_drawable_get_visible_region(this.getHandle()));
    }

    public void drawRGBImage(GC gC, int n, int n2, int n3, int n4, RgbDither rgbDither, byte[] byArray, int n5) {
        Drawable.gdk_draw_rgb_image(this.getHandle(), gC.getHandle(), n, n2, n3, n4, rgbDither.getValue(), byArray, n5);
    }

    public void drawRGBImage(int n, int n2, int n3, int n4, RgbDither rgbDither, byte[] byArray, int n5) {
        this.drawRGBImage(GC.getDefaultGC(this), n, n2, n3, n4, rgbDither, byArray, n5);
    }

    public void drawRGBImageDitherAlign(GC gC, int n, int n2, int n3, int n4, RgbDither rgbDither, byte[] byArray, int n5, int n6, int n7) {
        Drawable.gdk_draw_rgb_image_dithalign(this.getHandle(), gC.getHandle(), n, n2, n3, n4, rgbDither.getValue(), byArray, n5, n6, n7);
    }

    public void drawRGBImageDitherAlign(int n, int n2, int n3, int n4, RgbDither rgbDither, byte[] byArray, int n5, int n6, int n7) {
        this.drawRGBImageDitherAlign(GC.getDefaultGC(this), n, n2, n3, n4, rgbDither, byArray, n5, n6, n7);
    }

    public void drawRGB32Image(GC gC, int n, int n2, int n3, int n4, RgbDither rgbDither, byte[] byArray, int n5) {
        Drawable.gdk_draw_rgb_32_image(this.getHandle(), gC.getHandle(), n, n2, n3, n4, rgbDither.getValue(), byArray, n5);
    }

    public void drawRGB32Image(int n, int n2, int n3, int n4, RgbDither rgbDither, byte[] byArray, int n5) {
        this.drawRGB32Image(GC.getDefaultGC(this), n, n2, n3, n4, rgbDither, byArray, n5);
    }

    public void drawRGB32ImageDitherAlign(GC gC, int n, int n2, int n3, int n4, RgbDither rgbDither, byte[] byArray, int n5, int n6, int n7) {
        Drawable.gdk_draw_rgb_32_image_dithalign(this.getHandle(), gC.getHandle(), n, n2, n3, n4, rgbDither.getValue(), byArray, n5, n6, n7);
    }

    public void drawRGB32ImageDitherAlign(int n, int n2, int n3, int n4, RgbDither rgbDither, byte[] byArray, int n5, int n6, int n7) {
        this.drawRGB32ImageDitherAlign(GC.getDefaultGC(this), n, n2, n3, n4, rgbDither, byArray, n5, n6, n7);
    }

    public void drawGrayImage(GC gC, int n, int n2, int n3, int n4, RgbDither rgbDither, byte[] byArray, int n5) {
        Drawable.gdk_draw_gray_image(this.getHandle(), gC.getHandle(), n, n2, n3, n4, rgbDither.getValue(), byArray, n5);
    }

    public void drawGrayImage(int n, int n2, int n3, int n4, RgbDither rgbDither, byte[] byArray, int n5) {
        this.drawGrayImage(GC.getDefaultGC(this), n, n2, n3, n4, rgbDither, byArray, n5);
    }

    public void drawIndexedImage(GC gC, int n, int n2, int n3, int n4, RgbDither rgbDither, byte[] byArray, int n5, RgbCmap rgbCmap) {
        Drawable.gdk_draw_indexed_image(this.getHandle(), gC.getHandle(), n, n2, n3, n4, rgbDither.getValue(), byArray, n5, rgbCmap.getHandle());
    }

    public void drawIndexedImage(int n, int n2, int n3, int n4, RgbDither rgbDither, byte[] byArray, int n5, RgbCmap rgbCmap) {
        this.drawIndexedImage(GC.getDefaultGC(this), n, n2, n3, n4, rgbDither, byArray, n5, rgbCmap);
    }

    public void drawPolygon(GC gC, boolean bl, Point[] pointArray) {
        Handle[] handleArray = new Handle[pointArray.length];
        for (int i = 0; i < pointArray.length; ++i) {
            handleArray[i] = pointArray[i].getHandle();
        }
        Drawable.gdk_draw_polygon(this.getHandle(), gC.getHandle(), bl, handleArray);
    }

    public void drawPolygon(boolean bl, Point[] pointArray) {
        this.drawPolygon(GC.getDefaultGC(this), bl, pointArray);
    }

    public void drawDrawable(GC gC, Drawable drawable, int n, int n2, int n3, int n4, int n5, int n6) {
        Drawable.gdk_draw_drawable(this.getHandle(), gC.getHandle(), drawable.getHandle(), n, n2, n3, n4, n5, n6);
    }

    public void drawDrawable(Drawable drawable, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawDrawable(GC.getDefaultGC(this), drawable, n, n2, n3, n4, n5, n6);
    }

    public void drawImage(GC gC, Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        Drawable.gdk_draw_image(this.getHandle(), gC.getHandle(), image.getHandle(), n, n2, n3, n4, n5, n6);
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawImage(GC.getDefaultGC(this), image, n, n2, n3, n4, n5, n6);
    }

    public void drawPoints(GC gC, Point[] pointArray) {
        Handle[] handleArray = new Handle[pointArray.length];
        for (int i = 0; i < pointArray.length; ++i) {
            handleArray[i] = pointArray[i].getHandle();
        }
        Drawable.gdk_draw_points(this.getHandle(), gC.getHandle(), handleArray);
    }

    public void drawPoints(Point[] pointArray) {
        this.drawPoints(GC.getDefaultGC(this), pointArray);
    }

    public void drawSegments(GC gC, Segment[] segmentArray) {
        Handle[] handleArray = new Handle[segmentArray.length];
        for (int i = 0; i < segmentArray.length; ++i) {
            handleArray[i] = segmentArray[i].getHandle();
        }
        Drawable.gdk_draw_segments(this.getHandle(), gC.getHandle(), handleArray);
    }

    public void drawSegments(Segment[] segmentArray) {
        this.drawSegments(GC.getDefaultGC(this), segmentArray);
    }

    public void drawLines(GC gC, Point[] pointArray) {
        Handle[] handleArray = new Handle[pointArray.length];
        for (int i = 0; i < pointArray.length; ++i) {
            handleArray[i] = pointArray[i].getHandle();
        }
        Drawable.gdk_draw_lines(this.getHandle(), gC.getHandle(), handleArray);
    }

    public void drawLines(Point[] pointArray) {
        this.drawLines(GC.getDefaultGC(this), pointArray);
    }

    public void drawGlyphs(GC gC, Font font, int n, int n2, GlyphString glyphString) {
        Drawable.gdk_draw_glyphs(this.getHandle(), gC.getHandle(), font.getHandle(), n, n2, glyphString.getHandle());
    }

    public void drawGlyphs(Font font, int n, int n2, GlyphString glyphString) {
        this.drawGlyphs(GC.getDefaultGC(this), font, n, n2, glyphString);
    }

    public void drawLayoutLine(GC gC, int n, int n2, LayoutLine layoutLine) {
        Drawable.gdk_draw_layout_line(this.getHandle(), gC.getHandle(), n, n2, layoutLine.getHandle());
    }

    public void drawLayoutLine(int n, int n2, LayoutLine layoutLine) {
        this.drawLayoutLine(GC.getDefaultGC(this), n, n2, layoutLine);
    }

    public void drawLayout(GC gC, int n, int n2, Layout layout) {
        Drawable.gdk_draw_layout(this.getHandle(), gC.getHandle(), n, n2, layout.getHandle());
    }

    public void drawLayout(int n, int n2, Layout layout) {
        this.drawLayout(GC.getDefaultGC(this), n, n2, layout);
    }

    public void drawLayoutLineWithColors(GC gC, int n, int n2, LayoutLine layoutLine, Color color, Color color2) {
        Drawable.gdk_draw_layout_line_with_colors(this.getHandle(), gC.getHandle(), n, n2, layoutLine.getHandle(), color.getHandle(), color2.getHandle());
    }

    public void drawLayoutLineWithColors(int n, int n2, LayoutLine layoutLine, Color color, Color color2) {
        this.drawLayoutLineWithColors(GC.getDefaultGC(this), n, n2, layoutLine, color, color2);
    }

    public void drawLayoutWithColors(GC gC, int n, int n2, Layout layout, Color color, Color color2) {
        Drawable.gdk_draw_layout_with_colors(this.getHandle(), gC.getHandle(), n, n2, layout.getHandle(), color.getHandle(), color2.getHandle());
    }

    public void drawLayoutWithColors(int n, int n2, Layout layout, Color color, Color color2) {
        this.drawLayoutWithColors(GC.getDefaultGC(this), n, n2, layout, color, color2);
    }

    public Display getDisplay() {
        Handle handle = Drawable.gdk_drawable_get_display(this.getHandle());
        if (handle != null) {
            GObject gObject = GObject.getGObjectFromHandle((Handle)handle);
            if (gObject != null) {
                return (Display)gObject;
            }
            return new Display(handle);
        }
        return null;
    }

    public Screen getScreen() {
        return Screen.getScreenFromHandle(Drawable.gdk_drawable_get_screen(this.getHandle()));
    }

    public void drawPoint(GC gC, int n, int n2) {
        Drawable.gdk_draw_point(this.getHandle(), gC.getHandle(), n, n2);
    }

    public void drawPoint(int n, int n2) {
        this.drawPoint(GC.getDefaultGC(this), n, n2);
    }

    public void drawLine(GC gC, int n, int n2, int n3, int n4) {
        Drawable.gdk_draw_line(this.getHandle(), gC.getHandle(), n, n2, n3, n4);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.drawLine(GC.getDefaultGC(this), n, n2, n3, n4);
    }

    public void drawPixbuf(GC gC, Pixbuf pixbuf, int n, int n2, int n3, int n4, int n5, int n6, RgbDither rgbDither, int n7, int n8) {
        Drawable.gdk_draw_pixbuf(this.getHandle(), gC.getHandle(), pixbuf.getHandle(), n, n2, n3, n4, n5, n6, rgbDither.getValue(), n7, n8);
    }

    public void drawPixbuf(Pixbuf pixbuf, int n, int n2, int n3, int n4, int n5, int n6, RgbDither rgbDither, int n7, int n8) {
        this.drawPixbuf(GC.getDefaultGC(this), pixbuf, n, n2, n3, n4, n5, n6, rgbDither, n7, n8);
    }

    public void drawRectangle(GC gC, boolean bl, int n, int n2, int n3, int n4) {
        Drawable.gdk_draw_rectangle(this.getHandle(), gC.getHandle(), bl, n, n2, n3, n4);
    }

    public void drawRectangle(boolean bl, int n, int n2, int n3, int n4) {
        this.drawRectangle(GC.getDefaultGC(this), bl, n, n2, n3, n4);
    }

    public void drawArc(GC gC, boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        Drawable.gdk_draw_arc(this.getHandle(), gC.getHandle(), bl, n, n2, n3, n4, n5, n6);
    }

    public void drawArc(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawArc(GC.getDefaultGC(this), bl, n, n2, n3, n4, n5, n6);
    }

    public static Type getType() {
        return new Type(Drawable.gdk_drawable_get_type());
    }

    protected static final native int gdk_drawable_get_type();

    protected static final native Handle gdk_drawable_get_display(Handle var0);

    protected static final native Handle gdk_drawable_get_screen(Handle var0);

    protected static final native Handle gdk_drawable_get_visual(Handle var0);

    protected static final native void gdk_drawable_set_colormap(Handle var0, Handle var1);

    protected static final native Handle gdk_drawable_get_colormap(Handle var0);

    protected static final native int gdk_drawable_get_depth(Handle var0);

    protected static final native void gdk_drawable_get_size(Handle var0, int[] var1, int[] var2);

    protected static final native Handle gdk_drawable_get_clip_region(Handle var0);

    protected static final native Handle gdk_drawable_get_visible_region(Handle var0);

    protected static final native Handle gdk_drawable_get_image(Handle var0, int var1, int var2, int var3, int var4);

    protected static final native void gdk_draw_point(Handle var0, Handle var1, int var2, int var3);

    protected static final native void gdk_draw_points(Handle var0, Handle var1, Handle[] var2);

    protected static final native void gdk_draw_line(Handle var0, Handle var1, int var2, int var3, int var4, int var5);

    protected static final native void gdk_draw_lines(Handle var0, Handle var1, Handle[] var2);

    protected static final native void gdk_draw_pixbuf(Handle var0, Handle var1, Handle var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    protected static final native void gdk_draw_segments(Handle var0, Handle var1, Handle[] var2);

    protected static final native void gdk_draw_rectangle(Handle var0, Handle var1, boolean var2, int var3, int var4, int var5, int var6);

    protected static final native void gdk_draw_arc(Handle var0, Handle var1, boolean var2, int var3, int var4, int var5, int var6, int var7, int var8);

    protected static final native void gdk_draw_polygon(Handle var0, Handle var1, boolean var2, Handle[] var3);

    protected static final native void gdk_draw_glyphs(Handle var0, Handle var1, Handle var2, int var3, int var4, Handle var5);

    protected static final native void gdk_draw_layout_line(Handle var0, Handle var1, int var2, int var3, Handle var4);

    protected static final native void gdk_draw_layout_line_with_colors(Handle var0, Handle var1, int var2, int var3, Handle var4, Handle var5, Handle var6);

    protected static final native void gdk_draw_layout(Handle var0, Handle var1, int var2, int var3, Handle var4);

    protected static final native void gdk_draw_layout_with_colors(Handle var0, Handle var1, int var2, int var3, Handle var4, Handle var5, Handle var6);

    protected static final native void gdk_draw_drawable(Handle var0, Handle var1, Handle var2, int var3, int var4, int var5, int var6, int var7, int var8);

    protected static final native void gdk_draw_image(Handle var0, Handle var1, Handle var2, int var3, int var4, int var5, int var6, int var7, int var8);

    protected static final native void gdk_draw_rgb_image(Handle var0, Handle var1, int var2, int var3, int var4, int var5, int var6, byte[] var7, int var8);

    protected static final native void gdk_draw_rgb_image_dithalign(Handle var0, Handle var1, int var2, int var3, int var4, int var5, int var6, byte[] var7, int var8, int var9, int var10);

    protected static final native void gdk_draw_rgb_32_image(Handle var0, Handle var1, int var2, int var3, int var4, int var5, int var6, byte[] var7, int var8);

    protected static final native void gdk_draw_rgb_32_image_dithalign(Handle var0, Handle var1, int var2, int var3, int var4, int var5, int var6, byte[] var7, int var8, int var9, int var10);

    protected static final native void gdk_draw_gray_image(Handle var0, Handle var1, int var2, int var3, int var4, int var5, int var6, byte[] var7, int var8);

    protected static final native void gdk_draw_indexed_image(Handle var0, Handle var1, int var2, int var3, int var4, int var5, int var6, byte[] var7, int var8, Handle var9);
}

