/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gdk;

import org.gnu.gdk.Atom;
import org.gnu.gdk.DragAction;
import org.gnu.gdk.DragProtocol;
import org.gnu.gdk.Window;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;

public class DragContext
extends GObject {
    public DragContext() {
        super(DragContext.gdk_drag_context_new());
    }

    public DragContext(Handle handle) {
        super(handle);
    }

    public Window getSource() {
        return Window.getWindowFromHandle(DragContext.getSourceWindow(this.getHandle()));
    }

    public Window getDestination() {
        return Window.getWindowFromHandle(DragContext.getDestWindow(this.getHandle()));
    }

    public DragProtocol getProtocol() {
        return DragProtocol.intern(DragContext.getProtocol(this.getHandle()));
    }

    public boolean isSource() {
        return DragContext.getIsSource(this.getHandle());
    }

    public DragAction getSuggestedAction() {
        return DragAction.intern(DragContext.getSuggestedAction(this.getHandle()));
    }

    public DragAction getAction() {
        return DragAction.intern(DragContext.getAction(this.getHandle()));
    }

    public Atom[] getTargets() {
        Handle[] handleArray = DragContext.getTargets(this.getHandle());
        if (handleArray == null) {
            return new Atom[0];
        }
        Atom[] atomArray = new Atom[handleArray.length];
        int n = atomArray.length;
        for (int i = 0; i < n; ++i) {
            atomArray[i] = new Atom(handleArray[i]);
        }
        return atomArray;
    }

    public void finish(boolean bl, boolean bl2, int n) {
        DragContext.gtk_drag_finish(this.getHandle(), bl, bl2, n);
    }

    private static final native Handle[] getTargets(Handle var0);

    protected static final native int getProtocol(Handle var0);

    protected static final native boolean getIsSource(Handle var0);

    protected static final native Handle getSourceWindow(Handle var0);

    protected static final native Handle getDestWindow(Handle var0);

    protected static final native int getActions(Handle var0);

    protected static final native int getSuggestedAction(Handle var0);

    protected static final native int getAction(Handle var0);

    protected static final native int gdk_drag_context_get_type();

    protected static final native Handle gdk_drag_context_new();

    private static final native void gtk_drag_finish(Handle var0, boolean var1, boolean var2, int var3);
}

