/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gdk;

import org.gnu.gdk.Atom;
import org.gnu.gdk.Device;
import org.gnu.gdk.Event;
import org.gnu.gdk.Point;
import org.gnu.gdk.Screen;
import org.gnu.gdk.Window;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Struct;
import org.gnu.glib.Type;

public class Display
extends GObject {
    public Display() {
        super(Display.gdk_display_get_default());
    }

    public Display(String string) {
        super(Display.gdk_display_open(string));
    }

    public Display(Handle handle) {
        super(handle);
    }

    public static Display open(String string) {
        Handle handle = Display.gdk_display_open(string);
        return Display.getDisplayFromHandle(handle);
    }

    public String getName() {
        return Display.gdk_display_get_name(this.getHandle());
    }

    public int getNumScreens() {
        return Display.gdk_display_get_n_screens(this.getHandle());
    }

    public Screen getScreen(int n) {
        return Screen.getScreenFromHandle(Display.gdk_display_get_screen(this.getHandle(), n));
    }

    public Screen getDefaultScreen() {
        return Screen.getScreenFromHandle(Display.gdk_display_get_default_screen(this.getHandle()));
    }

    public void ungrabPointer() {
        Display.gdk_display_pointer_ungrab(this.getHandle(), 0);
    }

    public void ungrabKeyboard() {
        Display.gdk_display_keyboard_ungrab(this.getHandle(), 0);
    }

    public boolean pointerIsGrabbed() {
        return Display.gdk_display_pointer_is_grabbed(this.getHandle());
    }

    public void beep() {
        Display.gdk_display_beep(this.getHandle());
    }

    public void sync() {
        Display.gdk_display_sync(this.getHandle());
    }

    public void flush() {
        Display.gdk_display_flush(this.getHandle());
    }

    public void close() {
        Display.gdk_display_close(this.getHandle());
    }

    public Device[] listDevice() {
        Handle[] handleArray = Display.gdk_display_list_devices(this.getHandle());
        if (handleArray == null) {
            return null;
        }
        Device[] deviceArray = new Device[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            deviceArray[i] = Device.getDeviceFromHandle(handleArray[i]);
        }
        return deviceArray;
    }

    public Event getEvent() {
        return new Event(Display.gdk_display_get_event(this.getHandle()));
    }

    public Event peekEvent() {
        return new Event(Display.gdk_display_peek_event(this.getHandle()));
    }

    public void putEvent(Event event) {
        Display.gdk_display_put_event(this.getHandle(), event.getHandle());
    }

    public Point getPointerLocation() {
        Handle handle = Struct.getNullHandle();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        Display.gdk_display_get_pointer(this.getHandle(), handle, nArray, nArray2, nArray3);
        return new Point(nArray[0], nArray2[0]);
    }

    public Screen getPointerScreen() {
        Handle handle = Struct.getNullHandle();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        Display.gdk_display_get_pointer(this.getHandle(), handle, nArray, nArray2, nArray3);
        return new Screen(handle);
    }

    public Device getCorePointer() {
        return Device.getDeviceFromHandle(Display.gdk_display_get_core_pointer(this.getHandle()));
    }

    public Window getWindowAtPointer() {
        return Window.getWindowFromHandle(Display.gdk_display_get_window_at_pointer(this.getHandle(), 0, 0));
    }

    public boolean supportsCursorAlpha() {
        return Display.gdk_display_supports_cursor_alpha(this.getHandle());
    }

    public boolean supportsCursorColor() {
        return Display.gdk_display_supports_cursor_color(this.getHandle());
    }

    public int getDefaultCursorSize() {
        return Display.gdk_display_get_default_cursor_size(this.getHandle());
    }

    public int getMaxCursorWidth() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Display.gdk_display_get_maximum_cursor_size(this.getHandle(), nArray, nArray2);
        return nArray[0];
    }

    public int getMaxCursorHeight() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Display.gdk_display_get_maximum_cursor_size(this.getHandle(), nArray, nArray2);
        return nArray2[0];
    }

    public Window getDefaultGroup() {
        return Window.getWindowFromHandle(Display.gdk_display_get_default_group(this.getHandle()));
    }

    public boolean supportsSelectionNotification() {
        return Display.gdk_display_supports_selection_notification(this.getHandle());
    }

    public boolean requestSelectionNotification(Atom atom) {
        return Display.gdk_display_request_selection_notification(this.getHandle(), atom.getHandle());
    }

    public boolean supportsClipboardPersistence() {
        return Display.gdk_display_supports_clipboard_persistence(this.getHandle());
    }

    public void storeClipboard(Window window, Atom[] atomArray) {
        Handle[] handleArray = new Handle[atomArray.length];
        for (int i = 0; i < atomArray.length; ++i) {
            handleArray[i] = atomArray[i].getHandle();
        }
        Display.gdk_display_store_clipboard(this.getHandle(), window.getHandle(), 0, handleArray);
    }

    public void warpPointer(Screen screen, int n, int n2) {
        Display.gdk_display_warp_pointer(this.getHandle(), screen.getHandle(), n, n2);
    }

    public void setDoubleClickTime(int n) {
        Display.gdk_display_set_double_click_time(this.getHandle(), n);
    }

    public void setDoubleClickDistance(int n) {
        Display.gdk_display_set_double_click_distance(this.getHandle(), n);
    }

    public Type getType() {
        return new Type(Display.gdk_display_get_type());
    }

    public static Display getDisplayFromHandle(Handle handle) {
        if (handle != null) {
            GObject gObject = GObject.getGObjectFromHandle((Handle)handle);
            if (gObject != null) {
                return (Display)gObject;
            }
            return new Display(handle);
        }
        return null;
    }

    protected static final native int gdk_display_get_type();

    protected static final native Handle gdk_display_open(String var0);

    protected static final native String gdk_display_get_name(Handle var0);

    protected static final native int gdk_display_get_n_screens(Handle var0);

    protected static final native Handle gdk_display_get_screen(Handle var0, int var1);

    protected static final native Handle gdk_display_get_default_screen(Handle var0);

    protected static final native void gdk_display_pointer_ungrab(Handle var0, int var1);

    protected static final native void gdk_display_keyboard_ungrab(Handle var0, int var1);

    protected static final native boolean gdk_display_pointer_is_grabbed(Handle var0);

    protected static final native void gdk_display_beep(Handle var0);

    protected static final native void gdk_display_sync(Handle var0);

    protected static final native void gdk_display_flush(Handle var0);

    protected static final native void gdk_display_close(Handle var0);

    protected static final native Handle[] gdk_display_list_devices(Handle var0);

    protected static final native Handle gdk_display_get_event(Handle var0);

    protected static final native Handle gdk_display_peek_event(Handle var0);

    protected static final native void gdk_display_put_event(Handle var0, Handle var1);

    protected static final native Handle gdk_display_get_default();

    protected static final native Handle gdk_display_get_core_pointer(Handle var0);

    protected static final native void gdk_display_get_pointer(Handle var0, Handle var1, int[] var2, int[] var3, int[] var4);

    protected static final native Handle gdk_display_get_window_at_pointer(Handle var0, int var1, int var2);

    protected static final native boolean gdk_display_supports_cursor_alpha(Handle var0);

    protected static final native boolean gdk_display_supports_cursor_color(Handle var0);

    protected static final native int gdk_display_get_default_cursor_size(Handle var0);

    protected static final native void gdk_display_get_maximum_cursor_size(Handle var0, int[] var1, int[] var2);

    protected static final native boolean gdk_display_supports_selection_notification(Handle var0);

    protected static final native boolean gdk_display_request_selection_notification(Handle var0, Handle var1);

    protected static final native boolean gdk_display_supports_clipboard_persistence(Handle var0);

    protected static final native void gdk_display_store_clipboard(Handle var0, Handle var1, int var2, Handle[] var3);

    protected static final native Handle gdk_display_get_default_group(Handle var0);

    protected static final native void gdk_display_set_double_click_time(Handle var0, int var1);

    protected static final native void gdk_display_set_double_click_distance(Handle var0, int var1);

    protected static final native void gdk_display_warp_pointer(Handle var0, Handle var1, int var2, int var3);
}

