/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gdk;

import java.util.ArrayList;
import java.util.List;
import org.gnu.gdk.AxisUse;
import org.gnu.gdk.InputMode;
import org.gnu.gdk.InputSource;
import org.gnu.gdk.ModifierType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;

public class Device
extends GObject {
    public Device(Handle handle) {
        super(handle);
    }

    public String getName() {
        return Device.getName(this.getHandle());
    }

    public InputSource getSource() {
        int n = Device.getSource(this.getHandle());
        return InputSource.intern(n);
    }

    public InputMode getMode() {
        int n = Device.getMode(this.getHandle());
        return InputMode.intern(n);
    }

    public boolean hasCursor() {
        return Device.getHasCursor(this.getHandle());
    }

    public static List getDevices() {
        Handle[] handleArray = Device.gdk_devices_list();
        ArrayList<Device> arrayList = new ArrayList<Device>();
        for (int i = 0; i < handleArray.length; ++i) {
            arrayList.add(Device.getDeviceFromHandle(handleArray[i]));
        }
        return arrayList;
    }

    public static org.gnu.glib.List getDevicesList() {
        return null;
    }

    public void setSource(InputSource inputSource) {
        Device.gdk_device_set_source(this.getHandle(), inputSource.getValue());
    }

    public void setMode(InputMode inputMode) {
        Device.gdk_device_set_mode(this.getHandle(), inputMode.getValue());
    }

    public void setKeyValue(int n, int n2, ModifierType modifierType) {
        Device.gdk_device_set_key(this.getHandle(), n, n2, modifierType.getValue());
    }

    public void setAxisUse(int n, AxisUse axisUse) {
        Device.gdk_device_set_axis_use(this.getHandle(), n, axisUse.getValue());
    }

    public static Device getCorePointer() {
        return Device.getDeviceFromHandle(Device.gdk_device_get_core_pointer());
    }

    static Device getDeviceFromHandle(Handle handle) {
        if (handle != null) {
            GObject gObject = GObject.getGObjectFromHandle((Handle)handle);
            if (gObject != null) {
                return (Device)gObject;
            }
            return new Device(handle);
        }
        return null;
    }

    protected static final native String getName(Handle var0);

    protected static final native int getSource(Handle var0);

    protected static final native int getMode(Handle var0);

    protected static final native boolean getHasCursor(Handle var0);

    protected static final native int gdk_device_get_type();

    protected static final native Handle[] gdk_devices_list();

    protected static final native void gdk_device_set_source(Handle var0, int var1);

    protected static final native void gdk_device_set_mode(Handle var0, int var1);

    protected static final native void gdk_device_set_key(Handle var0, int var1, int var2, int var3);

    protected static final native void gdk_device_set_axis_use(Handle var0, int var1, int var2);

    protected static final native boolean gdk_device_get_axis(Handle var0, double[] var1, int var2, double[] var3);

    protected static final native Handle gdk_device_get_core_pointer();
}

