/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gdk;

import org.gnu.gdk.Color;
import org.gnu.gdk.Screen;
import org.gnu.gdk.Visual;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;

public class Colormap
extends GObject {
    public Colormap() {
        super(Colormap.gdk_colormap_get_system());
    }

    public Colormap(Handle handle) {
        super(handle);
    }

    public Colormap(Visual visual, boolean bl) {
        super(Colormap.gdk_colormap_new(visual.getHandle(), bl));
    }

    public static Colormap getSystem() {
        return Colormap.getColormapFromHandle(Colormap.gdk_colormap_get_system());
    }

    public Visual getVisual() {
        return Visual.getVisualFromHandle(Colormap.gdk_colormap_get_visual(this.getHandle()));
    }

    public Screen getScreen() {
        return Screen.getScreenFromHandle(Colormap.gdk_colormap_get_screen(this.getHandle()));
    }

    public boolean allocateColor(Color color, boolean bl, boolean bl2) {
        return Colormap.gdk_colormap_alloc_color(this.getHandle(), color.getHandle(), bl, bl2);
    }

    public boolean[] allocateColors(Color[] colorArray, boolean bl, boolean bl2) {
        Handle[] handleArray = new Handle[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            handleArray[i] = colorArray[i].getHandle();
        }
        boolean[] blArray = new boolean[colorArray.length];
        Colormap.gdk_colormap_alloc_colors(this.getHandle(), handleArray, bl, bl2, blArray);
        return blArray;
    }

    public void freeColors(Color[] colorArray) {
        Handle[] handleArray = new Handle[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            handleArray[i] = colorArray[i].getHandle();
        }
        Colormap.gdk_colormap_free_colors(this.getHandle(), handleArray);
    }

    public Color queryColor(long l) {
        Handle handle = Colormap.gdk_colormap_query_color(this.getHandle(), l);
        return Color.getColorFromHandle(handle);
    }

    public Color[] getColors() {
        Handle[] handleArray = Colormap.get_colors(this.getHandle());
        if (handleArray == null) {
            return null;
        }
        Color[] colorArray = new Color[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            colorArray[i] = Color.getColorFromHandle(handleArray[i]);
        }
        return colorArray;
    }

    public Type getType() {
        return new Type(Colormap.gdk_colormap_get_type());
    }

    public static Colormap getColormapFromHandle(Handle handle) {
        if (handle != null) {
            GObject gObject = GObject.getGObjectFromHandle((Handle)handle);
            if (gObject != null) {
                return (Colormap)gObject;
            }
            return new Colormap(handle);
        }
        return null;
    }

    protected static final native int gdk_colormap_get_type();

    protected static final native Handle gdk_colormap_new(Handle var0, boolean var1);

    protected static final native Handle gdk_colormap_get_system();

    protected static final native Handle gdk_colormap_get_screen(Handle var0);

    protected static final native int gdk_colormap_alloc_colors(Handle var0, Handle[] var1, boolean var2, boolean var3, boolean[] var4);

    protected static final native boolean gdk_colormap_alloc_color(Handle var0, Handle var1, boolean var2, boolean var3);

    protected static final native void gdk_colormap_free_colors(Handle var0, Handle[] var1);

    protected static final native Handle gdk_colormap_query_color(Handle var0, long var1);

    protected static final native Handle gdk_colormap_get_visual(Handle var0);

    protected static final native Handle[] get_colors(Handle var0);
}

