/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gdk;

import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;

public class Color
extends Boxed {
    public static final Color RED = new Color(65535, 0, 0);
    public static final Color BLUE = new Color(0, 0, 65535);
    public static final Color GREEN = new Color(0, 65535, 0);
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color YELLOW = new Color(65535, 65535, 0);
    public static final Color WHITE = new Color(65535, 65535, 65535);
    public static final Color ORANGE = new Color(65535, 51400, 0);

    public Color(Handle handle) {
        super(handle);
    }

    public Color(int n, int n2, int n3) {
        super(Color.allocHandle());
        Color.setRed(this.getHandle(), n);
        Color.setBlue(this.getHandle(), n3);
        Color.setGreen(this.getHandle(), n2);
    }

    public Object clone() {
        return Color.getColorFromHandle(Color.gdk_color_copy(this.getHandle()));
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return Color.gdk_color_equal(this.getHandle(), ((Color)((Object)object)).getHandle());
    }

    public int hashCode() {
        return Color.gdk_color_hash(this.getHandle());
    }

    public int getRed() {
        return Color.getRed(this.getHandle());
    }

    public void setRed(short s) {
        Color.setRed(this.getHandle(), s);
    }

    public int getGreen() {
        return Color.getGreen(this.getHandle());
    }

    public void setGreen(short s) {
        Color.setGreen(this.getHandle(), s);
    }

    public int getBlue() {
        return Color.getBlue(this.getHandle());
    }

    public void setBlue(short s) {
        Color.setBlue(this.getHandle(), s);
    }

    public String toString() {
        return "Red: " + this.getRed() + "\n" + "Green: " + this.getGreen() + "\n" + "Blue: " + this.getBlue() + "\n";
    }

    public static Color parse(String string) {
        return Color.getColorFromHandle(Color.gdk_color_parse(string));
    }

    public int getPixel() {
        return Color.getPixel(this.getHandle());
    }

    public Type getType() {
        return new Type(Color.gdk_color_get_type());
    }

    public static Color getColorFromHandle(Handle handle) {
        if (handle != null) {
            Boxed boxed = Boxed.getBoxedFromHandle((Handle)handle);
            if (boxed != null) {
                return (Color)boxed;
            }
            return new Color(handle);
        }
        return null;
    }

    private static native Handle allocHandle();

    protected static final native int getPixel(Handle var0);

    protected static final native int getRed(Handle var0);

    protected static final native void setRed(Handle var0, int var1);

    protected static final native int getGreen(Handle var0);

    protected static final native void setGreen(Handle var0, int var1);

    protected static final native int getBlue(Handle var0);

    protected static final native void setBlue(Handle var0, int var1);

    protected static final native int gdk_color_get_type();

    protected static final native Handle gdk_color_copy(Handle var0);

    protected static final native Handle gdk_color_parse(String var0);

    protected static final native int gdk_color_hash(Handle var0);

    protected static final native boolean gdk_color_equal(Handle var0, Handle var1);
}

