/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.atk;

import org.gnu.atk.Layer;
import org.gnu.atk.RelationType;
import org.gnu.atk.Role;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;

public class AtkObject
extends GObject {
    public AtkObject(Handle handle) {
        super(handle);
    }

    public String getName() {
        return AtkObject.atk_object_get_name(this.getHandle());
    }

    public void setName(String string) {
        AtkObject.atk_object_set_name(this.getHandle(), string);
    }

    public String getDescription() {
        return AtkObject.atk_object_get_description(this.getHandle());
    }

    public void setDescription(String string) {
        AtkObject.atk_object_set_description(this.getHandle(), string);
    }

    public AtkObject getParent() {
        return AtkObject.getAtkObjectFromHandle(AtkObject.atk_object_get_parent(this.getHandle()));
    }

    public void setParent(AtkObject atkObject) {
        AtkObject.atk_object_set_parent(this.getHandle(), atkObject.getHandle());
    }

    public int getNumChildren() {
        return AtkObject.atk_object_get_n_accessible_children(this.getHandle());
    }

    public AtkObject getChild(int n) {
        return AtkObject.getAtkObjectFromHandle(AtkObject.atk_object_ref_accessible_child(this.getHandle(), n));
    }

    public Role getRole() {
        return Role.intern(AtkObject.atk_object_get_role(this.getHandle()));
    }

    public void setRole(Role role) {
        AtkObject.atk_object_set_role(this.getHandle(), role.getValue());
    }

    public Layer getLayer() {
        return Layer.intern(AtkObject.atk_object_get_layer(this.getHandle()));
    }

    public int getMDIZorder() {
        return AtkObject.atk_object_get_mdi_zorder(this.getHandle());
    }

    public int getIndexInParent() {
        return AtkObject.atk_object_get_index_in_parent(this.getHandle());
    }

    public String getRoleName(Role role) {
        return AtkObject.atk_role_get_name(role.getValue());
    }

    public Role getRoleForName(String string) {
        return Role.intern(AtkObject.atk_role_for_name(string));
    }

    public boolean addRelationship(RelationType relationType, AtkObject atkObject) {
        return AtkObject.atk_object_add_relationship(this.getHandle(), relationType.getValue(), atkObject.getHandle());
    }

    public boolean removeRelationship(RelationType relationType, AtkObject atkObject) {
        return AtkObject.atk_object_remove_relationship(this.getHandle(), relationType.getValue(), atkObject.getHandle());
    }

    public String getLocalizedRoleName(Role role) {
        return AtkObject.atk_role_get_localized_name(role.getValue());
    }

    public static AtkObject getAtkObjectFromHandle(Handle handle) {
        if (handle != null) {
            GObject gObject = GObject.getGObjectFromHandle((Handle)handle);
            if (gObject != null) {
                return (AtkObject)gObject;
            }
            return new AtkObject(handle);
        }
        return null;
    }

    protected static final native int atk_object_get_type();

    protected static final native String atk_object_get_name(Handle var0);

    protected static final native String atk_object_get_description(Handle var0);

    protected static final native Handle atk_object_get_parent(Handle var0);

    protected static final native int atk_object_get_n_accessible_children(Handle var0);

    protected static final native Handle atk_object_ref_accessible_child(Handle var0, int var1);

    protected static final native Handle atk_object_ref_relation_set(Handle var0);

    protected static final native int atk_object_get_role(Handle var0);

    protected static final native int atk_object_get_layer(Handle var0);

    protected static final native int atk_object_get_mdi_zorder(Handle var0);

    protected static final native int atk_object_get_index_in_parent(Handle var0);

    protected static final native void atk_object_set_name(Handle var0, String var1);

    protected static final native void atk_object_set_description(Handle var0, String var1);

    protected static final native void atk_object_set_parent(Handle var0, Handle var1);

    protected static final native void atk_object_set_role(Handle var0, int var1);

    protected static final native void atk_object_remove_property_change_handler(Handle var0, int var1);

    protected static final native void atk_object_notify_state_change(Handle var0, int var1, boolean var2);

    protected static final native void atk_object_initialize(Handle var0, long var1);

    protected static final native String atk_role_get_name(int var0);

    protected static final native int atk_role_for_name(String var0);

    protected static final native boolean atk_object_add_relationship(Handle var0, int var1, Handle var2);

    protected static final native boolean atk_object_remove_relationship(Handle var0, int var1, Handle var2);

    protected static final native String atk_role_get_localized_name(int var0);

    protected static final native Handle atk_object_ref_state_set(Handle var0);
}

