/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gnome;

import java.util.Vector;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gnome.event.IconEntryEvent;
import org.gnu.gnome.event.IconEntryListener;
import org.gnu.gtk.VBox;
import org.gnu.gtk.Widget;

public class IconEntry
extends VBox {
    private Vector listeners;
    private static EventMap evtMap = new EventMap();

    public static IconEntry getIconEntry(Handle handle) {
        if (handle == null) {
            return null;
        }
        IconEntry iconEntry = (IconEntry)GObject.getGObjectFromHandle((Handle)handle);
        if (iconEntry == null) {
            iconEntry = new IconEntry(handle);
        }
        return iconEntry;
    }

    public IconEntry(String string, String string2) {
        super(IconEntry.gnome_icon_entry_new(string, string2));
    }

    public IconEntry(Handle handle) {
        super(handle);
    }

    public void setSubdirectory(String string) {
        IconEntry.gnome_icon_entry_set_pixmap_subdir(this.getHandle(), string);
    }

    public String getFilename() {
        return IconEntry.gnome_icon_entry_get_filename(this.getHandle());
    }

    public void setFilename(String string) {
        IconEntry.gnome_icon_entry_set_filename(this.getHandle(), string);
    }

    public static Type getType() {
        return new Type(IconEntry.gnome_icon_entry_get_type());
    }

    public void setBrowseDialogTitle(String string) {
        IconEntry.gnome_icon_entry_set_browse_dialog_title(this.getHandle(), string);
    }

    public void setHistoryId(String string) {
        IconEntry.gnome_icon_entry_set_history_id(this.getHandle(), string);
    }

    public void setMaxSaved(int n) {
        IconEntry.gnome_icon_entry_set_max_saved(this.getHandle(), n);
    }

    public void addListener(IconEntryListener iconEntryListener) {
        int n = Widget.findListener((Vector)this.listeners, (Object)iconEntryListener);
        if (n == -1) {
            if (this.listeners == null) {
                evtMap.initialize((GObject)this, (EventType)IconEntryEvent.Type.BROWSE);
                evtMap.initialize((GObject)this, (EventType)IconEntryEvent.Type.CHANGED);
                this.listeners = new Vector();
            }
            this.listeners.addElement(iconEntryListener);
        }
    }

    public void removeListener(IconEntryListener iconEntryListener) {
        int n = Widget.findListener((Vector)this.listeners, (Object)iconEntryListener);
        if (n > -1) {
            this.listeners.remove(n);
        }
        if (this.listeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)IconEntryEvent.Type.BROWSE);
            evtMap.uninitialize((GObject)this, (EventType)IconEntryEvent.Type.CHANGED);
            this.listeners = null;
        }
    }

    protected void fireIconEntryEvent(IconEntryEvent iconEntryEvent) {
        if (this.listeners == null) {
            return;
        }
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            IconEntryListener iconEntryListener = (IconEntryListener)this.listeners.elementAt(i);
            iconEntryListener.iconEntryEvent(iconEntryEvent);
        }
    }

    private void handleChanged() {
        this.fireIconEntryEvent(new IconEntryEvent((Object)this, IconEntryEvent.Type.CHANGED));
    }

    private void handleBrowse() {
        this.fireIconEntryEvent(new IconEntryEvent((Object)this, IconEntryEvent.Type.BROWSE));
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("changed", "handleChanged", (EventType)IconEntryEvent.Type.CHANGED, IconEntry.class$("org.gnu.gnome.event.IconEntryListener"));
        eventMap.addEvent("browse", "handleBrowse", (EventType)IconEntryEvent.Type.BROWSE, IconEntry.class$("org.gnu.gnome.event.IconEntryListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static final native int gnome_icon_entry_get_type();

    protected static final native Handle gnome_icon_entry_new(String var0, String var1);

    protected static final native void gnome_icon_entry_set_pixmap_subdir(Handle var0, String var1);

    protected static final native String gnome_icon_entry_get_filename(Handle var0);

    protected static final native boolean gnome_icon_entry_set_filename(Handle var0, String var1);

    protected static final native void gnome_icon_entry_set_browse_dialog_title(Handle var0, String var1);

    protected static final native void gnome_icon_entry_set_history_id(Handle var0, String var1);

    protected static final native Handle gnome_icon_entry_pick_dialog(Handle var0);

    protected static final native void gnome_icon_entry_set_max_saved(Handle var0, int var1);

    static {
        IconEntry.addEvents(evtMap);
    }
}

