/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gnome;

import org.gnu.gdk.Color;
import org.gnu.gdk.RgbDither;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gnome.CanvasGroup;
import org.gnu.gnome.CanvasItem;
import org.gnu.gtk.Layout;

public class Canvas
extends Layout {
    public Canvas(boolean bl) {
        super(Canvas.init(bl));
    }

    public Canvas() {
        super(Canvas.gnome_canvas_new());
    }

    public Canvas(Handle handle) {
        super(handle);
    }

    public static Canvas getCanvas(Handle handle) {
        if (handle == null) {
            return null;
        }
        Canvas canvas = (Canvas)GObject.getGObjectFromHandle((Handle)handle);
        if (canvas == null) {
            canvas = new Canvas(handle);
        }
        return canvas;
    }

    private static Handle init(boolean bl) {
        if (bl) {
            return Canvas.gnome_canvas_new_aa();
        }
        return Canvas.gnome_canvas_new();
    }

    public Color getColor(String string) {
        Handle[] handleArray = new Handle[1];
        if (Canvas.gnome_canvas_get_color(this.getHandle(), string, handleArray)) {
            return Color.getColorFromHandle((Handle)handleArray[0]);
        }
        return null;
    }

    public long getColorPixel(int n) {
        return Canvas.gnome_canvas_get_color_pixel(this.getHandle(), n);
    }

    public CanvasItem getCurrentCanvasItem() {
        Handle handle = Canvas.getCurrentItem(this.getHandle());
        return CanvasItem.getCanvasItem(handle);
    }

    public RgbDither getDither() {
        int n = Canvas.gnome_canvas_get_dither(this.getHandle());
        return RgbDither.intern((int)n);
    }

    public void setDither(RgbDither rgbDither) {
        Canvas.gnome_canvas_set_dither(this.getHandle(), rgbDither.getValue());
    }

    public CanvasItem getFocusedCanvasItem() {
        Handle handle = Canvas.getFocusedItem(this.getHandle());
        return CanvasItem.getCanvasItem(handle);
    }

    public CanvasItem getGrabbedCanvasItem() {
        Handle handle = Canvas.getGrabbedItem(this.getHandle());
        return CanvasItem.getCanvasItem(handle);
    }

    public CanvasItem getItemAt(double d, double d2) {
        Handle handle = Canvas.gnome_canvas_get_item_at(this.getHandle(), d, d2);
        return CanvasItem.getCanvasItem(handle);
    }

    public double getPixelsPerUnit() {
        return Canvas.getPixelsPerUnit(this.getHandle());
    }

    public void setPixelsPerUnit(double d) {
        Canvas.gnome_canvas_set_pixels_per_unit(this.getHandle(), d);
    }

    public CanvasGroup getRoot() {
        Handle handle = Canvas.gnome_canvas_root(this.getHandle());
        return CanvasGroup.getCanvasGroup(handle);
    }

    public double getScrollOffsetX() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Canvas.gnome_canvas_get_scroll_offsets(this.getHandle(), nArray, nArray2);
        return nArray[0];
    }

    public double getScrollOffsetY() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Canvas.gnome_canvas_get_scroll_offsets(this.getHandle(), nArray, nArray2);
        return nArray2[0];
    }

    public double getScrollX1() {
        return Canvas.getScrollX1(this.getHandle());
    }

    public void setScrollX1(double d) {
        Canvas.gnome_canvas_set_scroll_region(this.getHandle(), d, this.getScrollY1(), this.getScrollX2(), this.getScrollY2());
    }

    public double getScrollX2() {
        return Canvas.getScrollX2(this.getHandle());
    }

    public void setScrollX2(double d) {
        Canvas.gnome_canvas_set_scroll_region(this.getHandle(), this.getScrollX1(), this.getScrollY1(), d, this.getScrollY2());
    }

    public double getScrollY1() {
        return Canvas.getScrollY1(this.getHandle());
    }

    public void setScrollY1(double d) {
        Canvas.gnome_canvas_set_scroll_region(this.getHandle(), this.getScrollX1(), d, this.getScrollX2(), this.getScrollY2());
    }

    public double getScrollY2() {
        return Canvas.getScrollY2(this.getHandle());
    }

    public void setScrollY2(double d) {
        Canvas.gnome_canvas_set_scroll_region(this.getHandle(), this.getScrollX1(), this.getScrollY1(), this.getScrollX2(), d);
    }

    public void scrollTo(int n, int n2) {
        Canvas.gnome_canvas_scroll_to(this.getHandle(), n, n2);
    }

    public void setScrollRegion(double d, double d2, double d3, double d4) {
        Canvas.gnome_canvas_set_scroll_region(this.getHandle(), d, d2, d3, d4);
    }

    public void update() {
        Canvas.gnome_canvas_update_now(this.getHandle());
    }

    public static Type getType() {
        return new Type(Canvas.gnome_canvas_get_type());
    }

    public boolean getCenterScrollRegion() {
        return Canvas.gnome_canvas_get_center_scroll_region(this.getHandle());
    }

    public void setCenterScrollRegion(boolean bl) {
        Canvas.gnome_canvas_set_center_scroll_region(this.getHandle(), bl);
    }

    public void requestRedraw(int n, int n2, int n3, int n4) {
        Canvas.gnome_canvas_request_redraw(this.getHandle(), n, n2, n3, n4);
    }

    public double windowToWorldX(double d) {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        Canvas.gnome_canvas_window_to_world(this.getHandle(), d, 0.0, dArray, dArray2);
        return dArray[0];
    }

    public double windowToWorldY(double d) {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        Canvas.gnome_canvas_window_to_world(this.getHandle(), 0.0, d, dArray, dArray2);
        return dArray2[0];
    }

    public double worldToWindowX(double d) {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        Canvas.gnome_canvas_world_to_window(this.getHandle(), d, 0.0, dArray, dArray2);
        return dArray[0];
    }

    public double worldToWindowY(double d) {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        Canvas.gnome_canvas_world_to_window(this.getHandle(), 0.0, d, dArray, dArray2);
        return dArray2[0];
    }

    protected static final native double getScrollX1(Handle var0);

    protected static final native double getScrollY1(Handle var0);

    protected static final native double getScrollX2(Handle var0);

    protected static final native double getScrollY2(Handle var0);

    protected static final native double getPixelsPerUnit(Handle var0);

    protected static final native Handle getCurrentItem(Handle var0);

    protected static final native Handle getFocusedItem(Handle var0);

    protected static final native Handle getGrabbedItem(Handle var0);

    protected static final native int gnome_canvas_get_type();

    protected static final native Handle gnome_canvas_new();

    protected static final native Handle gnome_canvas_new_aa();

    protected static final native Handle gnome_canvas_root(Handle var0);

    protected static final native void gnome_canvas_set_scroll_region(Handle var0, double var1, double var3, double var5, double var7);

    protected static final native void gnome_canvas_get_scroll_region(Handle var0, double[] var1, double[] var2, double[] var3, double[] var4);

    protected static final native void gnome_canvas_set_center_scroll_region(Handle var0, boolean var1);

    protected static final native boolean gnome_canvas_get_center_scroll_region(Handle var0);

    protected static final native void gnome_canvas_set_pixels_per_unit(Handle var0, double var1);

    protected static final native void gnome_canvas_scroll_to(Handle var0, int var1, int var2);

    protected static final native void gnome_canvas_get_scroll_offsets(Handle var0, int[] var1, int[] var2);

    protected static final native void gnome_canvas_update_now(Handle var0);

    protected static final native Handle gnome_canvas_get_item_at(Handle var0, double var1, double var3);

    protected static final native void gnome_canvas_request_redraw(Handle var0, int var1, int var2, int var3, int var4);

    protected static final native void gnome_canvas_window_to_world(Handle var0, double var1, double var3, double[] var5, double[] var6);

    protected static final native void gnome_canvas_world_to_window(Handle var0, double var1, double var3, double[] var5, double[] var6);

    protected static final native boolean gnome_canvas_get_color(Handle var0, String var1, Handle[] var2);

    protected static final native long gnome_canvas_get_color_pixel(Handle var0, int var1);

    protected static final native void gnome_canvas_set_stipple_origin(Handle var0, Handle var1);

    protected static final native void gnome_canvas_set_dither(Handle var0, int var1);

    protected static final native int gnome_canvas_get_dither(Handle var0);
}

