/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.glade;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.gnu.glade.GladeXMLException;

public class LibGladeStubs {
    String gladeFile;
    String className;
    SignalDesc[] handlers;
    private static String signalStart = "<signal ";
    private static String signalEnd1 = "/>";
    private static String signalEnd2 = "</signal>";
    private static String nameDelims = "= \t\n\r\f";
    private static String valueDelims = "=\"";

    public static void execute(String string) {
        if (!new File(string).exists()) {
            LibGladeStubs.error("cannot access " + string);
        }
        new LibGladeStubs(string).generate();
    }

    public LibGladeStubs(String string) {
        this.gladeFile = string;
    }

    public void generate() {
        try {
            this.parseGladeFile();
            this.writeJavaFile();
        }
        catch (Exception exception) {
            LibGladeStubs.error(exception.toString());
        }
    }

    private void writeJavaFile() throws Exception {
        String string;
        String string2;
        String string3;
        int n = this.gladeFile.lastIndexOf(File.separatorChar);
        if (n > -1) {
            string3 = this.gladeFile.substring(0, n);
            string2 = this.gladeFile.substring(n + 1);
        } else {
            string3 = ".";
            string2 = this.gladeFile;
        }
        n = string2.indexOf(".glade");
        String string4 = n > -1 ? string2.substring(0, n) : string2;
        StringBuffer stringBuffer = new StringBuffer(string4);
        stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
        this.className = stringBuffer.toString();
        String string5 = string3 + File.separatorChar + this.className + ".java";
        InputStream inputStream = this.getClass().getResourceAsStream("GladeTemplate.j");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        PrintWriter printWriter = new PrintWriter(new FileWriter(string5));
        while ((string = bufferedReader.readLine()) != null) {
            printWriter.println(this.expandLine(string));
        }
        printWriter.close();
    }

    private String stripDir(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (n > -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    private String expandLine(String string) {
        String[][] stringArrayArray = new String[][]{{"__GLADE_FILE__", this.stripDir(this.gladeFile)}, {"__CLASS__", this.className}};
        if (string.indexOf("__INSERT_STUBS__") != -1) {
            return this.createStubs();
        }
        for (int i = 0; i < 2; ++i) {
            String string2 = stringArrayArray[i][0];
            String string3 = stringArrayArray[i][1];
            int n = string.indexOf(string2);
            if (n < 0) continue;
            String string4 = string.substring(0, n) + string3 + string.substring(n + string2.length());
            return this.expandLine(string4);
        }
        return string;
    }

    private String createStubs() {
        CharArrayWriter charArrayWriter = new CharArrayWriter(1024);
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        for (int i = 0; i < this.handlers.length; ++i) {
            SignalDesc signalDesc = this.handlers[i];
            printWriter.println("\n    /**");
            printWriter.print("     * " + signalDesc.handler);
            printWriter.println(" method to handle the \"" + signalDesc.signal + "\" signal.");
            printWriter.println("     *");
            printWriter.println("     * @param source the widget that fired this signal");
            printWriter.print("     * @param target an object defined as the ");
            printWriter.println("target of this signal, or null.");
            printWriter.println("     */");
            printWriter.print("    public void " + signalDesc.handler);
            if (signalDesc.target != null) {
                printWriter.println("(GtkEvent event, Object target) {");
            } else {
                printWriter.println("(GtkEvent event) {");
            }
            printWriter.println("        // TODO: handler code here");
            printWriter.println("    }");
        }
        printWriter.close();
        return charArrayWriter.toString();
    }

    private static void error(String string) {
        System.err.println(string);
        System.exit(1);
    }

    private void parseGladeFile() throws IOException {
        this.handlers = LibGladeStubs.getSignalHandlers(this.getXML());
    }

    private String getXML() throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.gladeFile));
        StringWriter stringWriter = new StringWriter(4096);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        while ((string = bufferedReader.readLine()) != null) {
            if (string.indexOf("<GTK-Interface>") != -1) {
                LibGladeStubs.error(this.gladeFile + ": obsolete version (use libglade-convert)");
            }
            printWriter.println(string);
        }
        bufferedReader.close();
        printWriter.close();
        return stringWriter.toString();
    }

    private static SignalDesc[] getSignalHandlers(String string) throws GladeXMLException {
        ArrayList<SignalDesc> arrayList = new ArrayList<SignalDesc>();
        int n = 0;
        while ((n = string.indexOf(signalStart, n)) != -1) {
            int n2 = n + signalStart.length();
            int n3 = string.indexOf(signalEnd1, n);
            if (n3 != -1) {
                n = n3 + signalEnd1.length();
            } else {
                n3 = string.indexOf(signalEnd2, n);
                if (n3 != -1) {
                    n = n3 + signalEnd2.length();
                } else {
                    throw new GladeXMLException("invalid XML signal definition");
                }
            }
            arrayList.add(LibGladeStubs.makeSignalDesc(string.substring(n2, n3)));
        }
        return arrayList.toArray(new SignalDesc[0]);
    }

    private static SignalDesc makeSignalDesc(String string) throws GladeXMLException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, nameDelims);
        while (stringTokenizer.hasMoreTokens()) {
            String string5;
            String string6 = stringTokenizer.nextToken(nameDelims);
            try {
                string5 = stringTokenizer.nextToken(valueDelims);
                stringTokenizer.nextToken(nameDelims);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new GladeXMLException("invalid XML signal definition");
            }
            if ("name".equals(string6)) {
                string2 = string5;
                continue;
            }
            if ("handler".equals(string6)) {
                string3 = string5;
                continue;
            }
            if (!"object".equals(string6)) continue;
            string4 = string5;
        }
        if (string2 == null || string3 == null) {
            throw new GladeXMLException("invalid XML signal definition");
        }
        return new SignalDesc(string2, string3, string4);
    }

    static class SignalDesc {
        String signal;
        String handler;
        String target;

        SignalDesc(String string, String string2, String string3) {
            this.signal = string;
            this.handler = string2;
            this.target = string3;
        }
    }
}

