/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.glade;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.gnu.glade.GladeXMLException;
import org.gnu.glade.ListenerDelegate;
import org.gnu.glib.Handle;
import org.gnu.gtk.Widget;

public class LibGlade {
    private Handle gladeHandle;
    protected Hashtable widgets;
    protected Object owner;

    private /* synthetic */ void finit$() {
        this.widgets = new Hashtable();
    }

    public LibGlade(String string, Object object) throws GladeXMLException, FileNotFoundException, IOException {
        this(string, object, null);
        this.owner = object;
    }

    public LibGlade(String string, Object object, String string2) throws GladeXMLException, FileNotFoundException, IOException {
        this.finit$();
        if (!new File(string).canRead()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.owner = object;
        this.gladeHandle = this.glade_xml_new(string, string2);
        this.glade_xml_signal_autoconnect_full();
    }

    public LibGlade(InputStream inputStream, Object object, String string) throws GladeXMLException, IOException {
        this.finit$();
        this.owner = object;
        byte[] byArray = this.scanXML(inputStream);
        this.gladeHandle = this.glade_xml_new_from_buffer(byArray, string);
        this.glade_xml_signal_autoconnect_full();
    }

    private byte[] scanXML(InputStream inputStream) throws GladeXMLException, IOException {
        String string;
        CharArrayWriter charArrayWriter = new CharArrayWriter(8192);
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.indexOf("<GTK-Interface>") != -1) {
                throw new GladeXMLException("obsolete Glade XML format");
            }
            printWriter.println(string);
        }
        printWriter.close();
        return charArrayWriter.toString().getBytes();
    }

    public Widget getWidget(String string) {
        Widget widget = (Widget)this.widgets.get(string);
        if (widget == null) {
            Handle handle = this.getNativeWidget(string);
            if (handle != null) {
                widget = this.getWidget(handle);
            } else {
                System.err.println("getWidget: failed getting " + string);
            }
        }
        return widget;
    }

    protected native Handle getNativeWidget(String var1);

    protected native String getWidgetName(Handle var1);

    protected void connect(String string, Handle handle, String string2, String string3, Handle handle2, boolean bl) throws GladeXMLException {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            throw new GladeXMLException("invalid source widget handle");
        }
        Widget widget2 = handle2 != null ? this.getWidget(handle2) : null;
        Class clazz = widget.getEventListenerClass(string2);
        if (clazz != null) {
            try {
                ListenerDelegate listenerDelegate = ListenerDelegate.create(string2, clazz, this.owner, string, widget2);
                Method method = widget.getClass().getMethod("addListener", clazz);
                method.invoke((Object)widget, listenerDelegate);
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
            }
        }
    }

    protected Widget getWidget(Handle handle) {
        String string = this.getWidgetName(handle);
        if (string == null) {
            return null;
        }
        Widget widget = (Widget)this.widgets.get(string);
        if (widget == null) {
            try {
                widget = Widget.makeWidget((Handle)handle);
                this.widgets.put(string, widget);
                this.widgets.put(this.getWidgetName(handle), widget);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("could not create widget: " + classNotFoundException.getMessage());
            }
        }
        return widget;
    }

    private native Handle glade_xml_new(String var1, String var2) throws GladeXMLException;

    private native Handle glade_xml_new_from_buffer(byte[] var1, String var2) throws GladeXMLException;

    private native void glade_xml_signal_autoconnect_full() throws GladeXMLException;

    private static native void initIDs();

    static {
        System.loadLibrary("gladejni-2.12");
        LibGlade.initIDs();
    }
}

