/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gconf;

import java.util.ArrayList;
import java.util.List;
import org.gnu.gconf.ConfSchema;
import org.gnu.gconf.ConfValueType;
import org.gnu.glib.Handle;
import org.gnu.glib.MemStruct;

public class ConfValue
extends MemStruct {
    public ConfValue(ConfValueType confValueType) {
        super(ConfValue.gconf_value_new(confValueType.getValue()));
    }

    public ConfValue(Handle handle) {
        super(handle);
    }

    static ConfValue getConfValue(Handle handle) {
        if (handle == null) {
            return null;
        }
        ConfValue confValue = (ConfValue)MemStruct.getMemStructFromHandle((Handle)handle);
        if (confValue == null) {
            confValue = new ConfValue(handle);
        }
        return confValue;
    }

    public String getString() {
        return ConfValue.gconf_value_get_string(this.getHandle());
    }

    public void setString(String string) {
        ConfValue.gconf_value_set_string(this.getHandle(), string);
    }

    public int getInt() {
        return ConfValue.gconf_value_get_int(this.getHandle());
    }

    public void setInt(int n) {
        ConfValue.gconf_value_set_int(this.getHandle(), n);
    }

    public double getDouble() {
        return ConfValue.gconf_value_get_float(this.getHandle());
    }

    public void setDouble(double d) {
        ConfValue.gconf_value_set_float(this.getHandle(), d);
    }

    public boolean getBoolean() {
        return ConfValue.gconf_value_get_bool(this.getHandle());
    }

    public void setBoolean(boolean bl) {
        ConfValue.gconf_value_set_bool(this.getHandle(), bl);
    }

    public ConfValueType getListType() {
        return ConfValueType.intern(ConfValue.gconf_value_get_list_type(this.getHandle()));
    }

    public void setListType(ConfValueType confValueType) {
        ConfValue.gconf_value_set_list_type(this.getHandle(), confValueType.getValue());
    }

    public List getList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = ConfValue.gconf_value_get_list(this.getHandle());
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    public void setList(List list) {
        Object[] objectArray = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            objectArray[i] = list.get(i);
        }
        ConfValue.gconf_value_set_list(this.getHandle(), objectArray);
    }

    public ConfValue getCar() {
        return ConfValue.getConfValue(ConfValue.gconf_value_get_car(this.getHandle()));
    }

    public void setCar(ConfValue confValue) {
        ConfValue.gconf_value_set_car(this.getHandle(), confValue.getHandle());
    }

    public ConfValue getCdr() {
        return ConfValue.getConfValue(ConfValue.gconf_value_get_cdr(this.getHandle()));
    }

    public void setCdr(ConfValue confValue) {
        ConfValue.gconf_value_set_cdr(this.getHandle(), confValue.getHandle());
    }

    public ConfSchema getSchema() {
        return ConfSchema.getConfSchema(ConfValue.gconf_value_get_schema(this.getHandle()));
    }

    public void setSchema(ConfSchema confSchema) {
        ConfValue.gconf_value_set_schema(this.getHandle(), confSchema.getHandle());
    }

    public String toString() {
        return ConfValue.gconf_value_to_string(this.getHandle());
    }

    protected static final native Handle gconf_value_new(int var0);

    protected static final native Handle gconf_value_copy(Handle var0);

    protected static final native void gconf_value_free(Handle var0);

    protected static final native String gconf_value_get_string(Handle var0);

    protected static final native int gconf_value_get_int(Handle var0);

    protected static final native double gconf_value_get_float(Handle var0);

    protected static final native int gconf_value_get_list_type(Handle var0);

    protected static final native Object[] gconf_value_get_list(Handle var0);

    protected static final native Handle gconf_value_get_car(Handle var0);

    protected static final native Handle gconf_value_get_cdr(Handle var0);

    protected static final native boolean gconf_value_get_bool(Handle var0);

    protected static final native Handle gconf_value_get_schema(Handle var0);

    protected static final native void gconf_value_set_int(Handle var0, int var1);

    protected static final native void gconf_value_set_string(Handle var0, String var1);

    protected static final native void gconf_value_set_bool(Handle var0, boolean var1);

    protected static final native void gconf_value_set_float(Handle var0, double var1);

    protected static final native void gconf_value_set_schema(Handle var0, Handle var1);

    protected static final native void gconf_value_set_car(Handle var0, Handle var1);

    protected static final native void gconf_value_set_cdr(Handle var0, Handle var1);

    protected static final native void gconf_value_set_list_type(Handle var0, int var1);

    protected static final native void gconf_value_set_list(Handle var0, Object[] var1);

    protected static final native String gconf_value_to_string(Handle var0);
}

