/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gconf;

import org.gnu.gconf.ConfValue;
import org.gnu.glib.Handle;
import org.gnu.glib.MemStruct;

public class ConfEntry
extends MemStruct {
    public ConfEntry(String string, ConfValue confValue) {
        super(ConfEntry.gconf_entry_new_nocopy(string, confValue.getHandle()));
    }

    public ConfEntry(Handle handle) {
        super(handle);
    }

    static ConfEntry getConfEntry(Handle handle) {
        if (handle == null) {
            return null;
        }
        ConfEntry confEntry = (ConfEntry)MemStruct.getMemStructFromHandle((Handle)handle);
        if (confEntry == null) {
            confEntry = new ConfEntry(handle);
        }
        return confEntry;
    }

    public String getKey() {
        return ConfEntry.gconf_entry_get_key(this.getHandle());
    }

    public ConfValue getValue() {
        Handle handle = ConfEntry.gconf_entry_get_value(this.getHandle());
        return ConfValue.getConfValue(handle);
    }

    public void setValue(ConfValue confValue) {
        ConfEntry.gconf_entry_set_value_nocopy(this.getHandle(), confValue.getHandle());
    }

    public ConfValue stealValue() {
        Handle handle = ConfEntry.gconf_entry_steal_value(this.getHandle());
        return ConfValue.getConfValue(handle);
    }

    public String getSchemaName() {
        return ConfEntry.gconf_entry_get_schema_name(this.getHandle());
    }

    public void setSchemaName(String string) {
        ConfEntry.gconf_entry_set_schema_name(this.getHandle(), string);
    }

    public boolean isDefault() {
        return ConfEntry.gconf_entry_get_is_default(this.getHandle());
    }

    public void setIsDefault(boolean bl) {
        ConfEntry.gconf_entry_set_is_default(this.getHandle(), bl);
    }

    protected static final native Handle gconf_entry_new_nocopy(String var0, Handle var1);

    protected static final native String gconf_entry_get_key(Handle var0);

    protected static final native Handle gconf_entry_get_value(Handle var0);

    protected static final native Handle gconf_entry_steal_value(Handle var0);

    protected static final native boolean gconf_entry_get_is_default(Handle var0);

    protected static final native String gconf_entry_get_schema_name(Handle var0);

    protected static final native void gconf_entry_set_is_default(Handle var0, boolean var1);

    protected static final native void gconf_entry_set_schema_name(Handle var0, String var1);

    protected static final native void gconf_entry_set_value_nocopy(Handle var0, Handle var1);
}

