/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gconf;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.gnu.gconf.ConfClientListener;
import org.gnu.gconf.ConfClientPreloadType;
import org.gnu.gconf.ConfEntry;
import org.gnu.gconf.ConfException;
import org.gnu.gconf.ConfSchema;
import org.gnu.gconf.ConfValue;
import org.gnu.gconf.ConfValueType;
import org.gnu.glib.Error;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Struct;

public class ConfClient
extends GObject {
    private Hashtable listeners;

    private /* synthetic */ void finit$() {
        this.listeners = null;
    }

    private ConfClient(Handle handle) {
        super(handle);
        this.finit$();
    }

    private static ConfClient getConfClient(Handle handle) {
        if (handle == null) {
            return null;
        }
        ConfClient confClient = (ConfClient)GObject.getGObjectFromHandle((Handle)handle);
        if (confClient == null) {
            confClient = new ConfClient(handle);
        }
        return confClient;
    }

    public static ConfClient getInstance() {
        return ConfClient.getConfClient(ConfClient.gconf_client_get_default());
    }

    public void addDirectory(String string, ConfClientPreloadType confClientPreloadType) throws ConfException {
        Handle handle = ConfClient.gconf_client_add_dir(this.getHandle(), string, confClientPreloadType.getValue());
        this.checkError(handle);
    }

    public void removeDirectory(String string) throws ConfException {
        Handle handle = ConfClient.gconf_client_remove_dir(this.getHandle(), string);
        this.checkError(handle);
    }

    public void addListener(ConfClientListener confClientListener, String string) throws ConfException {
        Handle handle = Struct.getNullHandle();
        int n = this.gconf_client_notify_add(this.getHandle(), string, handle);
        this.checkError(handle);
        NotifyData notifyData = null;
        if (this.listeners == null) {
            this.listeners = new Hashtable();
        } else {
            notifyData = (NotifyData)this.listeners.get(string);
        }
        if (notifyData == null) {
            notifyData = new NotifyData(this);
            notifyData.namespace = string;
            notifyData.listeners = new Vector();
            this.listeners.put(string, notifyData);
        }
        NotifyClient notifyClient = new NotifyClient(this);
        notifyClient.id = n;
        notifyClient.lis = confClientListener;
        notifyData.listeners.addElement(notifyClient);
    }

    public void removeListener(ConfClientListener confClientListener, String string) {
        int n = -1;
        if (this.listeners == null) {
            return;
        }
        NotifyData notifyData = (NotifyData)this.listeners.get(string);
        if (notifyData == null) {
            return;
        }
        for (int i = 0; i < notifyData.listeners.size(); ++i) {
            NotifyClient notifyClient = (NotifyClient)notifyData.listeners.elementAt(i);
            if (notifyClient.lis != confClientListener) continue;
            n = notifyClient.id;
            notifyData.listeners.remove(notifyClient.lis);
            break;
        }
        if (-1 == n) {
            return;
        }
        ConfClient.gconf_client_notify_remove(this.getHandle(), n);
    }

    public void clearCache() {
        ConfClient.gconf_client_clear_cache(this.getHandle());
    }

    public void preload(String string, ConfClientPreloadType confClientPreloadType) throws ConfException {
        Handle handle = Struct.getNullHandle();
        ConfClient.gconf_client_preload(this.getHandle(), string, confClientPreloadType.getValue(), handle);
        this.checkError(handle);
    }

    public void set(String string, ConfValue confValue) throws ConfException {
        Handle handle = Struct.getNullHandle();
        ConfClient.gconf_client_set(this.getHandle(), string, confValue.getHandle(), handle);
        this.checkError(handle);
    }

    public ConfValue get(String string) throws ConfException {
        Handle handle = Struct.getNullHandle();
        Handle handle2 = ConfClient.gconf_client_get(this.getHandle(), string, handle);
        this.checkError(handle);
        return ConfValue.getConfValue(handle2);
    }

    public ConfEntry getEntry(String string, String string2, boolean bl) throws ConfException {
        Handle handle = Struct.getNullHandle();
        Handle handle2 = ConfClient.gconf_client_get_entry(this.getHandle(), string, string2, bl, handle);
        this.checkError(handle);
        return ConfEntry.getConfEntry(handle2);
    }

    public ConfValue getDefaultFromSchema(String string) throws ConfException {
        Handle handle = Struct.getNullHandle();
        Handle handle2 = ConfClient.gconf_client_get_default_from_schema(this.getHandle(), string, handle);
        this.checkError(handle);
        return ConfValue.getConfValue(handle2);
    }

    public boolean unset(String string) throws ConfException {
        Handle handle = Struct.getNullHandle();
        boolean bl = ConfClient.gconf_client_unset(this.getHandle(), string, handle);
        this.checkError(handle);
        return bl;
    }

    public List getAllEntries(String string) throws ConfException {
        Handle handle = Struct.getNullHandle();
        Handle[] handleArray = ConfClient.gconf_client_all_entries(this.getHandle(), string, handle);
        this.checkError(handle);
        if (handleArray == null) {
            return null;
        }
        ArrayList<ConfEntry> arrayList = new ArrayList<ConfEntry>();
        for (int i = 0; i < handleArray.length; ++i) {
            arrayList.add(ConfEntry.getConfEntry(handleArray[i]));
        }
        return arrayList;
    }

    public List getAllDirs(String string) throws ConfException {
        Handle handle = Struct.getNullHandle();
        String[] stringArray = ConfClient.gconf_client_all_dirs(this.getHandle(), string, handle);
        this.checkError(handle);
        if (stringArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public void suggestSync() throws ConfException {
        Handle handle = ConfClient.gconf_client_suggest_sync(this.getHandle());
        this.checkError(handle);
    }

    public boolean dirExists(String string) throws ConfException {
        Handle handle = Struct.getNullHandle();
        boolean bl = ConfClient.gconf_client_dir_exists(this.getHandle(), string, handle);
        this.checkError(handle);
        return bl;
    }

    public double getDouble(String string) throws ConfException {
        Handle handle = Struct.getNullHandle();
        double d = ConfClient.gconf_client_get_float(this.getHandle(), string, handle);
        this.checkError(handle);
        return d;
    }

    public int getInt(String string) throws ConfException {
        Handle handle = Struct.getNullHandle();
        int n = ConfClient.gconf_client_get_int(this.getHandle(), string, handle);
        this.checkError(handle);
        return n;
    }

    public String getString(String string) throws ConfException {
        Handle handle = Struct.getNullHandle();
        String string2 = ConfClient.gconf_client_get_string(this.getHandle(), string, handle);
        this.checkError(handle);
        return string2;
    }

    public boolean getBoolean(String string) throws ConfException {
        Handle handle = Struct.getNullHandle();
        boolean bl = ConfClient.gconf_client_get_bool(this.getHandle(), string, handle);
        this.checkError(handle);
        return bl;
    }

    public ConfSchema getSchema(String string) throws ConfException {
        Handle handle = Struct.getNullHandle();
        Handle handle2 = ConfClient.gconf_client_get_schema(this.getHandle(), string, handle);
        this.checkError(handle);
        return ConfSchema.getConfSchema(handle2);
    }

    public Object[] getList(String string, ConfValueType confValueType) throws ConfException {
        Handle handle = Struct.getNullHandle();
        Object[] objectArray = ConfClient.gconf_client_get_list(this.getHandle(), string, confValueType.getValue(), handle);
        this.checkError(handle);
        return objectArray;
    }

    public boolean setDouble(String string, double d) throws ConfException {
        Handle handle = Struct.getNullHandle();
        boolean bl = ConfClient.gconf_client_set_float(this.getHandle(), string, d, handle);
        this.checkError(handle);
        return bl;
    }

    public boolean setInt(String string, int n) throws ConfException {
        Handle handle = Struct.getNullHandle();
        boolean bl = ConfClient.gconf_client_set_int(this.getHandle(), string, n, handle);
        this.checkError(handle);
        return bl;
    }

    public boolean setString(String string, String string2) throws ConfException {
        Handle handle = Struct.getNullHandle();
        boolean bl = ConfClient.gconf_client_set_string(this.getHandle(), string, string2, handle);
        this.checkError(handle);
        return bl;
    }

    public boolean setBoolean(String string, boolean bl) throws ConfException {
        Handle handle = Struct.getNullHandle();
        boolean bl2 = ConfClient.gconf_client_set_bool(this.getHandle(), string, bl, handle);
        this.checkError(handle);
        return bl2;
    }

    public boolean setSchema(String string, ConfSchema confSchema) throws ConfException {
        Handle handle = Struct.getNullHandle();
        boolean bl = ConfClient.gconf_client_set_schema(this.getHandle(), string, confSchema.getHandle(), handle);
        this.checkError(handle);
        return bl;
    }

    public boolean setList(String string, ConfValueType confValueType, List list) throws ConfException {
        return false;
    }

    public void notifyCallback() {
    }

    public void t() {
    }

    protected void notifyCallback(Handle handle, String string) {
        if (this.listeners == null) {
            return;
        }
        NotifyData notifyData = (NotifyData)this.listeners.get(string);
        if (notifyData == null) {
            return;
        }
        ConfEntry confEntry = ConfEntry.getConfEntry(handle);
        Vector vector = notifyData.listeners;
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                NotifyClient notifyClient = (NotifyClient)vector.elementAt(i);
                notifyClient.lis.clientNotify(confEntry);
            }
        }
    }

    private void checkError(Handle handle) throws ConfException {
        if (handle == null) {
            return;
        }
        if (handle.isNull()) {
            return;
        }
        Error error = new Error(handle);
        throw new ConfException(error.getErrorCode());
    }

    protected static final native Handle gconf_client_get_default();

    protected static final native Handle gconf_client_get_for_engine(Handle var0);

    protected static final native Handle gconf_client_add_dir(Handle var0, String var1, int var2);

    protected static final native Handle gconf_client_remove_dir(Handle var0, String var1);

    protected final native int gconf_client_notify_add(Handle var1, String var2, Handle var3);

    protected static native void gconf_client_notify_remove(Handle var0, int var1);

    protected static final native void gconf_client_clear_cache(Handle var0);

    protected static final native void gconf_client_preload(Handle var0, String var1, int var2, Handle var3);

    protected static final native void gconf_client_set(Handle var0, String var1, Handle var2, Handle var3);

    protected static final native Handle gconf_client_get(Handle var0, String var1, Handle var2);

    protected static final native Handle gconf_client_get_without_default(Handle var0, String var1, Handle var2);

    protected static final native Handle gconf_client_get_entry(Handle var0, String var1, String var2, boolean var3, Handle var4);

    protected static final native Handle gconf_client_get_default_from_schema(Handle var0, String var1, Handle var2);

    protected static final native boolean gconf_client_unset(Handle var0, String var1, Handle var2);

    protected static final native Handle[] gconf_client_all_entries(Handle var0, String var1, Handle var2);

    protected static final native String[] gconf_client_all_dirs(Handle var0, String var1, Handle var2);

    protected static final native Handle gconf_client_suggest_sync(Handle var0);

    protected static final native boolean gconf_client_dir_exists(Handle var0, String var1, Handle var2);

    protected static final native double gconf_client_get_float(Handle var0, String var1, Handle var2);

    protected static final native int gconf_client_get_int(Handle var0, String var1, Handle var2);

    protected static final native String gconf_client_get_string(Handle var0, String var1, Handle var2);

    protected static final native boolean gconf_client_get_bool(Handle var0, String var1, Handle var2);

    protected static final native Handle gconf_client_get_schema(Handle var0, String var1, Handle var2);

    protected static final native Object[] gconf_client_get_list(Handle var0, String var1, int var2, Handle var3);

    protected static final native boolean gconf_client_get_pair(Handle var0, String var1, int var2, int var3, int[] var4, int[] var5, Handle var6);

    protected static final native boolean gconf_client_set_float(Handle var0, String var1, double var2, Handle var4);

    protected static final native boolean gconf_client_set_int(Handle var0, String var1, int var2, Handle var3);

    protected static final native boolean gconf_client_set_string(Handle var0, String var1, String var2, Handle var3);

    protected static final native boolean gconf_client_set_bool(Handle var0, String var1, boolean var2, Handle var3);

    protected static final native boolean gconf_client_set_schema(Handle var0, String var1, Handle var2, Handle var3);

    protected static final native boolean gconf_client_set_list(Handle var0, String var1, int var2, Object[] var3, Handle var4);

    protected static final native boolean gconf_client_set_pair(Handle var0, String var1, int var2, int var3, Handle var4, Handle var5, Handle var6);

    protected static final native void gconf_client_value_changed(Handle var0, String var1, Handle var2);

    static {
        System.loadLibrary("gconfjni-2.12");
    }

    private class NotifyClient {
        private /* synthetic */ ConfClient this$0;
        public int id;
        public ConfClientListener lis;

        NotifyClient(ConfClient confClient) {
            this.this$0 = confClient;
        }
    }

    private class NotifyData {
        private /* synthetic */ ConfClient this$0;
        public String namespace;
        public Vector listeners;

        NotifyData(ConfClient confClient) {
            this.this$0 = confClient;
        }
    }
}

