/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.glib;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ListIterator;
import org.gnu.glib.EventType;
import org.gnu.glib.Handle;
import org.gnu.glib.PropertyNotificationListener;
import org.gnu.glib.Struct;
import org.gnu.glib.Type;
import org.gnu.glib.Value;

public class GObject
extends Struct {
    protected boolean eventsInitialized;
    private Hashtable properties;
    private ArrayList notifyListeners;
    private boolean freezeNotify;
    private ArrayList frozenNotifies;

    private /* synthetic */ void finit$() {
        this.eventsInitialized = false;
        this.properties = null;
        this.notifyListeners = null;
        this.freezeNotify = false;
        this.frozenNotifies = null;
    }

    protected GObject() {
        this.finit$();
    }

    public GObject(Type type) {
        super(GObject.g_object_new(type.getTypeHandle()));
        this.finit$();
    }

    public GObject(Handle handle) {
        super(handle);
        this.finit$();
    }

    public int addEventHandler(String string, String string2, Object object) {
        return this.addEventHandler(string, string2, object, true);
    }

    public native int addEventHandler(String var1, Object var2);

    public native int addEventHandler(String var1, Object var2, Object var3);

    public native int addEventHandler(String var1, String var2, Object var3, boolean var4);

    public native int addEventHandler(String var1, String var2, Object var3, Object var4);

    public native int addEventHandler(String var1, String var2, Class var3);

    public native int addEventHandler(String var1, String var2, Class var3, Object var4);

    public native void removeEventHandler(int var1);

    public Object getData(String string) {
        return GObject.getData(this.getHandle(), string);
    }

    public void setData(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException("key is null.");
        }
        GObject.setData(this.getHandle(), string, object);
    }

    public Class getEventListenerClass(String string) {
        return null;
    }

    public EventType getEventType(String string) {
        return null;
    }

    public void setProperty(String string, Value value) {
        if (this.hasGtkProperty(string)) {
            GObject.g_object_set_property(this.getHandle(), string, value.getHandle());
        } else {
            this.setInternProperty(string, value);
            this.notifyIntern(string);
        }
    }

    public void setIntProperty(String string, int n) {
        Value value = new Value(Type.INT());
        value.setInteger(n);
        this.setProperty(string, value);
    }

    public void setStringProperty(String string, String string2) {
        Value value = new Value(Type.STRING());
        value.setString(string2);
        this.setProperty(string, value);
    }

    public void setBooleanProperty(String string, boolean bl) {
        Value value = new Value(Type.BOOLEAN());
        value.setBoolean(bl);
        this.setProperty(string, value);
    }

    public void setFloatProperty(String string, float f) {
        Value value = new Value(Type.FLOAT());
        value.setFloat(f);
        this.setProperty(string, value);
    }

    public void setLongProperty(String string, long l) {
        Value value = new Value(Type.LONG());
        value.setLong(l);
        this.setProperty(string, value);
    }

    public void setDoubleProperty(String string, double d) {
        Value value = new Value(Type.DOUBLE());
        value.setDouble(d);
        this.setProperty(string, value);
    }

    public void setJavaObjectProperty(String string, Object object) {
        Value value = null;
        if (this.hasGtkProperty(string)) {
            Type type = new Type(GObject.getGTypeOfProperty(this.getHandle(), string));
            value = new Value(type);
        } else {
            value = new Value(Type.OBJECT());
        }
        value.setJavaObject(object);
        this.setProperty(string, value);
    }

    public Value getProperty(String string) {
        if (this.hasGtkProperty(string)) {
            return new Value(GObject.g_object_get_property(this.getHandle(), string));
        }
        return this.getInternProperty(string);
    }

    public int getIntProperty(String string) {
        Value value = this.getProperty(string);
        if (value != null) {
            return value.getInt();
        }
        return 0;
    }

    public String getStringProperty(String string) {
        Value value = this.getProperty(string);
        if (value != null) {
            return value.getString();
        }
        return null;
    }

    public boolean getBooleanProperty(String string) {
        Value value = this.getProperty(string);
        if (value != null) {
            return value.getBoolean();
        }
        return false;
    }

    public float getFloatProperty(String string) {
        Value value = this.getProperty(string);
        if (value != null) {
            return (float)value.getFloat();
        }
        return 0.0f;
    }

    public long getLongProperty(String string) {
        Value value = this.getProperty(string);
        if (value != null) {
            return value.getLong();
        }
        return 0L;
    }

    public double getDoubleProperty(String string) {
        Value value = this.getProperty(string);
        if (value != null) {
            return value.getDouble();
        }
        return 0.0;
    }

    public Object getJavaObjectProperty(String string) {
        Value value = this.getProperty(string);
        if (value == null) {
            return null;
        }
        Object object = value.getJavaObject();
        if (object == null) {
            return null;
        }
        if (object instanceof Handle) {
            int n = GObject.getGTypeOfProperty(this.getHandle(), string);
            return GObject.instantiateJGObjectFromGType(n, (Handle)object);
        }
        return object;
    }

    public boolean hasProperty(String string) {
        if (this.hasGtkProperty(string)) {
            return true;
        }
        return this.hasInternProperty(string);
    }

    public void addListener(PropertyNotificationListener propertyNotificationListener) {
        if (this.notifyListeners == null) {
            this.notifyListeners = new ArrayList();
            GObject.connectNotifySignal(this.getHandle(), this, "handlePropertyNotify");
        }
        this.notifyListeners.add(propertyNotificationListener);
    }

    public void removeListener(PropertyNotificationListener propertyNotificationListener) {
        int n = this.notifyListeners.indexOf(propertyNotificationListener);
        if (n != -1) {
            this.notifyListeners.remove(n);
        }
        if (this.notifyListeners.size() == 0) {
            GObject.disconnectNotifySignal(this.getHandle());
        }
    }

    public void freezeNotify() {
        GObject.g_object_freeze_notify(this.getHandle());
        this.freezeNotify = true;
    }

    public void notify(String string) {
        if (this.hasGtkProperty(string)) {
            GObject.g_object_notify(this.getHandle(), string);
        } else if (!this.freezeNotify) {
            this.notifyIntern(string);
        } else {
            if (this.frozenNotifies == null) {
                this.frozenNotifies = new ArrayList();
            }
            this.frozenNotifies.add(string);
        }
    }

    public void thawNotify() {
        GObject.g_object_thaw_notify(this.getHandle());
        this.freezeNotify = false;
        if (this.frozenNotifies != null) {
            ListIterator listIterator = this.frozenNotifies.listIterator();
            while (listIterator.hasNext()) {
                this.notifyIntern((String)listIterator.next());
            }
        }
    }

    protected GObject retrieveGObject(Handle handle) {
        return GObject.getGObjectFromHandle(handle);
    }

    public static GObject getGObjectFromHandle(Handle handle) {
        return (GObject)handle.getProxiedObject();
    }

    protected void finalize() throws Throwable {
        block2: {
            try {
                if (this.getHandle() == null) break block2;
                GObject.nativeFinalize(this.getHandle());
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                super.finalize();
                throw throwable;
            }
        }
        Object var1_1 = null;
        super.finalize();
    }

    private static void printStackTrace(String string) {
        new Exception(string).printStackTrace();
    }

    private void setInternProperty(String string, Value value) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(string, value);
    }

    private Value getInternProperty(String string) {
        if (this.properties != null) {
            return (Value)this.properties.get(string);
        }
        return null;
    }

    private boolean hasGtkProperty(String string) {
        Handle handle = GObject.g_object_class_find_property(this.getHandle(), string);
        return handle.isNull() ^ true;
    }

    private boolean hasInternProperty(String string) {
        if (this.properties != null) {
            return this.properties.get(string) != null;
        }
        return false;
    }

    private void notifyIntern(String string) {
        Value value;
        if (this.properties != null && (value = (Value)this.properties.get(string)) != null) {
            this.handlePropertyNotify(this.getHandle(), string);
        }
    }

    private void handlePropertyNotify(Handle handle, String string) {
        GObject gObject = GObject.getGObjectFromHandle(handle);
        PropertyNotificationListener propertyNotificationListener = null;
        if (this.notifyListeners == null) {
            this.notifyListeners = new ArrayList();
        }
        ListIterator listIterator = this.notifyListeners.listIterator();
        while (listIterator.hasNext()) {
            propertyNotificationListener = (PropertyNotificationListener)listIterator.next();
            propertyNotificationListener.notify(gObject, string);
        }
    }

    public static final void collect() {
        GObject.nativeCollect();
    }

    static final native void g_object_ref(Handle var0);

    static final native void g_object_unref(Handle var0);

    protected static final native Object getData(Handle var0, String var1);

    protected static final native void setData(Handle var0, String var1, Object var2);

    private static final native void registerLogHandler();

    private static final native Handle g_object_new(int var0);

    private static final native Handle g_object_class_find_property(Handle var0, String var1);

    private static final native void g_object_set_property(Handle var0, String var1, Handle var2);

    private static final native Handle g_object_get_property(Handle var0, String var1);

    private static final native void g_object_freeze_notify(Handle var0);

    private static final native void g_object_notify(Handle var0, String var1);

    private static final native void g_object_thaw_notify(Handle var0);

    private static final native void connectNotifySignal(Handle var0, GObject var1, String var2);

    private static final native void disconnectNotifySignal(Handle var0);

    private static final native int getGTypeOfProperty(Handle var0, String var1);

    protected static final native Object instantiateJGObjectFromGType(int var0, Handle var1);

    protected static final native int getIntFromHandle(Handle var0);

    protected static final native String getStringFromHandle(Handle var0);

    private static final native void nativeCollect();

    private static final native void nativeFinalize(Handle var0);

    private static final native void init();

    static {
        GObject.registerLogHandler();
        GObject.init();
    }
}

