/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.cairo;

import java.io.OutputStream;
import org.freedesktop.cairo.CairoObject;
import org.freedesktop.cairo.Content;
import org.freedesktop.cairo.FontOptions;
import org.gnu.glib.Handle;

public class Surface
extends CairoObject {
    Surface(Handle handle) {
        super(handle);
    }

    protected void finalize() throws Throwable {
        Surface.cairo_surface_destroy(this.getHandle());
        super.finalize();
    }

    public Surface createSimilar(Content content, int n, int n2) {
        return new Surface(Surface.cairo_surface_create_similar(this.getHandle(), content.getValue(), n, n2));
    }

    public void finish() {
        Surface.cairo_surface_finish(this.getHandle());
    }

    public void setDeviceOffset(double d, double d2) {
        Surface.cairo_surface_set_device_offset(this.getHandle(), d, d2);
    }

    public void writeToPNG(String string) {
        Surface.cairo_surface_write_to_png(this.getHandle(), string);
    }

    public void writeToPNG(OutputStream outputStream) {
        Surface.cairo_surface_write_to_png_stream(this.getHandle(), outputStream);
    }

    public FontOptions getFontOptions() {
        return new FontOptions(Surface.cairo_surface_get_font_options(this.getHandle()));
    }

    public void flush() {
        Surface.cairo_surface_flush(this.getHandle());
    }

    public void markDirty() {
        Surface.cairo_surface_mark_dirty(this.getHandle());
    }

    public void markDirty(int n, int n2, int n3, int n4) {
        Surface.cairo_surface_mark_dirty_rectangle(this.getHandle(), n, n2, n3, n4);
    }

    private static final native Handle cairo_surface_create_similar(Handle var0, int var1, int var2, int var3);

    private static final native void cairo_surface_destroy(Handle var0);

    private static final native void cairo_surface_finish(Handle var0);

    private static final native int cairo_surface_write_to_png(Handle var0, String var1);

    private static final native int cairo_surface_write_to_png_stream(Handle var0, OutputStream var1);

    private static final native void cairo_surface_set_device_offset(Handle var0, double var1, double var3);

    private static final native Handle cairo_surface_get_font_options(Handle var0);

    private static final native void cairo_surface_flush(Handle var0);

    private static final native void cairo_surface_mark_dirty(Handle var0);

    private static final native void cairo_surface_mark_dirty_rectangle(Handle var0, int var1, int var2, int var3, int var4);
}

