/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.cairo;

import org.freedesktop.cairo.CairoObject;
import org.freedesktop.cairo.FontExtents;
import org.freedesktop.cairo.FontFace;
import org.freedesktop.cairo.FontOptions;
import org.freedesktop.cairo.Glyph;
import org.freedesktop.cairo.Matrix;
import org.freedesktop.cairo.TextExtents;
import org.gnu.glib.Handle;
import org.gnu.glib.Struct;

public class ScaledFont
extends CairoObject {
    public ScaledFont(FontFace fontFace, Matrix matrix, Matrix matrix2, FontOptions fontOptions) {
        super(ScaledFont.cairo_scaled_font_create(fontFace.getHandle(), matrix.getHandle(), matrix2.getHandle(), fontOptions.getHandle()));
    }

    protected void finalize() throws Throwable {
        ScaledFont.cairo_scaled_font_destroy(this.getHandle());
        super.finalize();
    }

    ScaledFont(Handle handle) {
        super(handle);
    }

    public FontExtents getFontExtents() {
        Handle handle = Struct.getNullHandle();
        ScaledFont.cairo_scaled_font_extents(this.getHandle(), handle);
        return new FontExtents(handle);
    }

    public TextExtents getGlyphExtents(Glyph[] glyphArray) {
        if (glyphArray == null) {
            return null;
        }
        Handle[] handleArray = new Handle[glyphArray.length];
        for (int i = 0; i < glyphArray.length; ++i) {
            handleArray[i] = glyphArray[i].getHandle();
        }
        Handle handle = Struct.getNullHandle();
        ScaledFont.cairo_scaled_font_glyph_extents(this.getHandle(), handleArray, handle);
        return new TextExtents(handle);
    }

    private static final native Handle cairo_scaled_font_create(Handle var0, Handle var1, Handle var2, Handle var3);

    private static final native void cairo_scaled_font_extents(Handle var0, Handle var1);

    private static final native void cairo_scaled_font_glyph_extents(Handle var0, Handle[] var1, Handle var2);

    private static final native void cairo_scaled_font_reference(Handle var0);

    private static final native void cairo_scaled_font_destroy(Handle var0);
}

