/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.cairo;

import org.freedesktop.cairo.CairoObject;
import org.freedesktop.cairo.Point;
import org.gnu.glib.Handle;

public class Matrix
extends CairoObject {
    Matrix(Handle handle) {
        super(handle);
    }

    public Matrix() {
        super(Matrix.new_identity_matrix());
    }

    protected void finalize() throws Throwable {
        Matrix.free_matrix(this.getHandle());
        super.finalize();
    }

    public void init(double d, double d2, double d3, double d4, double d5, double d6) {
        Matrix.cairo_matrix_init(this.getHandle(), d, d2, d3, d4, d5, d6);
    }

    public void initIdentity() {
        Matrix.cairo_matrix_init_identity(this.getHandle());
    }

    public void initTranslate(double d, double d2) {
        Matrix.cairo_matrix_init_translate(this.getHandle(), d, d2);
    }

    public void initScale(double d, double d2) {
        Matrix.cairo_matrix_init_scale(this.getHandle(), d, d2);
    }

    public void initRotate(double d) {
        Matrix.cairo_matrix_init_rotate(this.getHandle(), d);
    }

    public void translate(double d, double d2) {
        Matrix.cairo_matrix_translate(this.getHandle(), d, d2);
    }

    public void scale(double d, double d2) {
        Matrix.cairo_matrix_scale(this.getHandle(), d, d2);
    }

    public void rotate(double d) {
        Matrix.cairo_matrix_rotate(this.getHandle(), d);
    }

    public void invert() {
        Matrix.cairo_matrix_invert(this.getHandle());
    }

    public static Matrix multiply(Matrix matrix, Matrix matrix2) {
        Handle handle = Matrix.cairo_matrix_multiply(matrix.getHandle(), matrix2.getHandle());
        return new Matrix(handle);
    }

    public Point transformDistance(Point point) {
        double[] dArray = new double[]{point.getX()};
        double[] dArray2 = new double[]{point.getY()};
        Matrix.cairo_matrix_transform_distance(this.getHandle(), dArray, dArray2);
        return new Point(dArray[0], dArray2[0]);
    }

    public Point transformPoint(Point point) {
        double[] dArray = new double[]{point.getX()};
        double[] dArray2 = new double[]{point.getY()};
        Matrix.cairo_matrix_transform_distance(this.getHandle(), dArray, dArray2);
        return new Point(dArray[0], dArray2[0]);
    }

    public double getXX() {
        return Matrix.getXX(this.getHandle());
    }

    public void setXX(double d) {
        Matrix.setXX(this.getHandle(), d);
    }

    public double getYX() {
        return Matrix.getYX(this.getHandle());
    }

    public void setYX(double d) {
        Matrix.setYX(this.getHandle(), d);
    }

    public double getXY() {
        return Matrix.getXY(this.getHandle());
    }

    public void setXY(double d) {
        Matrix.setXY(this.getHandle(), d);
    }

    public double getYY() {
        return Matrix.getYY(this.getHandle());
    }

    public void setYY(double d) {
        Matrix.setYY(this.getHandle(), d);
    }

    public double getX0() {
        return Matrix.getX0(this.getHandle());
    }

    public void setX0(double d) {
        Matrix.setX0(this.getHandle(), d);
    }

    public double getY0() {
        return Matrix.getY0(this.getHandle());
    }

    public void setY0(double d) {
        Matrix.setY0(this.getHandle(), d);
    }

    private static final native double getXX(Handle var0);

    private static final native double getYX(Handle var0);

    private static final native double getXY(Handle var0);

    private static final native double getYY(Handle var0);

    private static final native double getX0(Handle var0);

    private static final native double getY0(Handle var0);

    private static final native void setXX(Handle var0, double var1);

    private static final native void setYX(Handle var0, double var1);

    private static final native void setXY(Handle var0, double var1);

    private static final native void setYY(Handle var0, double var1);

    private static final native void setX0(Handle var0, double var1);

    private static final native void setY0(Handle var0, double var1);

    private static final native Handle new_identity_matrix();

    private static final native void free_matrix(Handle var0);

    private static final native void cairo_matrix_init(Handle var0, double var1, double var3, double var5, double var7, double var9, double var11);

    private static final native void cairo_matrix_init_identity(Handle var0);

    private static final native void cairo_matrix_init_translate(Handle var0, double var1, double var3);

    private static final native void cairo_matrix_init_scale(Handle var0, double var1, double var3);

    private static final native void cairo_matrix_init_rotate(Handle var0, double var1);

    private static final native void cairo_matrix_translate(Handle var0, double var1, double var3);

    private static final native void cairo_matrix_scale(Handle var0, double var1, double var3);

    private static final native void cairo_matrix_rotate(Handle var0, double var1);

    private static final native void cairo_matrix_invert(Handle var0);

    private static final native Handle cairo_matrix_multiply(Handle var0, Handle var1);

    private static final native void cairo_matrix_transform_distance(Handle var0, double[] var1, double[] var2);

    private static final native void cairo_matrix_transform_point(Handle var0, double[] var1, double[] var2);
}

