/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.cairo;

import org.freedesktop.cairo.Antialias;
import org.freedesktop.cairo.CairoObject;
import org.freedesktop.cairo.FillRule;
import org.freedesktop.cairo.FontExtents;
import org.freedesktop.cairo.FontFace;
import org.freedesktop.cairo.FontOptions;
import org.freedesktop.cairo.FontSlant;
import org.freedesktop.cairo.FontWeight;
import org.freedesktop.cairo.Glyph;
import org.freedesktop.cairo.LineCap;
import org.freedesktop.cairo.LineJoin;
import org.freedesktop.cairo.Matrix;
import org.freedesktop.cairo.Operator;
import org.freedesktop.cairo.Pattern;
import org.freedesktop.cairo.Point;
import org.freedesktop.cairo.Rectangle;
import org.freedesktop.cairo.Status;
import org.freedesktop.cairo.Surface;
import org.freedesktop.cairo.TextExtents;
import org.gnu.glib.Handle;
import org.gnu.glib.Struct;

public class Context
extends CairoObject {
    private static final double SVG_ARC_MAGIC = 0.5522847498;

    public Context(Surface surface) {
        super(Context.cairo_create(surface.getHandle()));
    }

    protected Context(Handle handle) {
        super(handle);
    }

    protected void finalize() throws Throwable {
        Context.cairo_destroy(this.getHandle());
        super.finalize();
    }

    public void save() {
        Context.cairo_save(this.getHandle());
    }

    public void restore() {
        Context.cairo_restore(this.getHandle());
    }

    public void setOperator(Operator operator) {
        Context.cairo_set_operator(this.getHandle(), operator.getValue());
    }

    public void setSource(Pattern pattern) {
        Context.cairo_set_source(this.getHandle(), pattern.getHandle());
    }

    public void setSourceRGB(double d, double d2, double d3) {
        Context.cairo_set_source_rgb(this.getHandle(), d, d2, d3);
    }

    public void setSourceRGBA(double d, double d2, double d3, double d4) {
        Context.cairo_set_source_rgba(this.getHandle(), d, d2, d3, d4);
    }

    public void setSource(Surface surface, double d, double d2) {
        Context.cairo_set_source_surface(this.getHandle(), surface.getHandle(), d, d2);
    }

    public void setTolerance(double d) {
        Context.cairo_set_tolerance(this.getHandle(), d);
    }

    public void setFillRule(FillRule fillRule) {
        Context.cairo_set_fill_rule(this.getHandle(), fillRule.getValue());
    }

    public void setLineWidth(double d) {
        Context.cairo_set_line_width(this.getHandle(), d);
    }

    public void setLineCap(LineCap lineCap) {
        Context.cairo_set_line_cap(this.getHandle(), lineCap.getValue());
    }

    public void setLineJoin(LineJoin lineJoin) {
        Context.cairo_set_line_join(this.getHandle(), lineJoin.getValue());
    }

    public void setDash(double[] dArray, double d) {
        Context.cairo_set_dash(this.getHandle(), dArray, d);
    }

    public void setMiterLimit(double d) {
        Context.cairo_set_miter_limit(this.getHandle(), d);
    }

    public void translate(double d, double d2) {
        Context.cairo_translate(this.getHandle(), d, d2);
    }

    public void scale(double d, double d2) {
        Context.cairo_scale(this.getHandle(), d, d2);
    }

    public void rotate(double d) {
        Context.cairo_rotate(this.getHandle(), d);
    }

    public void transform(Matrix matrix) {
        Context.cairo_transform(this.getHandle(), matrix.getHandle());
    }

    public void setMatrix(Matrix matrix) {
        Context.cairo_set_matrix(this.getHandle(), matrix.getHandle());
    }

    public void identityMatrix() {
        Context.cairo_identity_matrix(this.getHandle());
    }

    public Point userToDevice(Point point) {
        double[] dArray = new double[]{point.getX()};
        double[] dArray2 = new double[]{point.getY()};
        Context.cairo_user_to_device(this.getHandle(), dArray, dArray2);
        return new Point(dArray[0], dArray2[0]);
    }

    public Point userToDeviceDistance(Point point) {
        double[] dArray = new double[]{point.getX()};
        double[] dArray2 = new double[]{point.getY()};
        Context.cairo_user_to_device_distance(this.getHandle(), dArray, dArray2);
        return new Point(dArray[0], dArray2[0]);
    }

    public Point deviceToUser(Point point) {
        double[] dArray = new double[]{point.getX()};
        double[] dArray2 = new double[]{point.getY()};
        Context.cairo_device_to_user(this.getHandle(), dArray, dArray2);
        return new Point(dArray[0], dArray2[0]);
    }

    public Point deviceToUserDistance(Point point) {
        double[] dArray = new double[]{point.getX()};
        double[] dArray2 = new double[]{point.getY()};
        Context.cairo_device_to_user_distance(this.getHandle(), dArray, dArray2);
        return new Point(dArray[0], dArray2[0]);
    }

    public void newPath() {
        Context.cairo_new_path(this.getHandle());
    }

    public void moveTo(Point point) {
        Context.cairo_move_to(this.getHandle(), point.getX(), point.getY());
    }

    public void moveTo(double d, double d2) {
        Context.cairo_move_to(this.getHandle(), d, d2);
    }

    public void lineTo(Point point) {
        Context.cairo_line_to(this.getHandle(), point.getX(), point.getY());
    }

    public void lineTo(double d, double d2) {
        Context.cairo_line_to(this.getHandle(), d, d2);
    }

    public void curveTo(Point point, Point point2, Point point3) {
        Context.cairo_curve_to(this.getHandle(), point.getX(), point.getY(), point2.getX(), point2.getY(), point3.getX(), point3.getY());
    }

    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        Context.cairo_curve_to(this.getHandle(), d, d2, d3, d4, d5, d6);
    }

    public void arc(Point point, double d, double d2, double d3) {
        Context.cairo_arc(this.getHandle(), point.getX(), point.getY(), d, d2, d3);
    }

    public void arc(double d, double d2, double d3, double d4, double d5) {
        Context.cairo_arc(this.getHandle(), d, d2, d3, d4, d5);
    }

    public void arcNegative(Point point, double d, double d2, double d3) {
        Context.cairo_arc_negative(this.getHandle(), point.getX(), point.getY(), d, d2, d3);
    }

    public void arcNegative(double d, double d2, double d3, double d4, double d5) {
        Context.cairo_arc_negative(this.getHandle(), d, d2, d3, d4, d5);
    }

    public void relMoveTo(Point point) {
        Context.cairo_rel_move_to(this.getHandle(), point.getX(), point.getY());
    }

    public void relMoveTo(double d, double d2) {
        Context.cairo_rel_move_to(this.getHandle(), d, d2);
    }

    public void relLineTo(Point point) {
        Context.cairo_rel_line_to(this.getHandle(), point.getX(), point.getY());
    }

    public void relLineTo(double d, double d2) {
        Context.cairo_rel_line_to(this.getHandle(), d, d2);
    }

    public void relCurveTo(Point point, Point point2, Point point3) {
        Context.cairo_rel_curve_to(this.getHandle(), point.getX(), point.getY(), point2.getX(), point2.getY(), point3.getX(), point3.getY());
    }

    public void relCurveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        Context.cairo_rel_curve_to(this.getHandle(), d, d2, d3, d4, d5, d6);
    }

    public void rectangle(Point point, Point point2) {
        Rectangle rectangle = new Rectangle(point, point2);
        this.rectangle(rectangle);
    }

    public void rectangle(Rectangle rectangle) {
        Context.cairo_rectangle(this.getHandle(), rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public void closePath() {
        Context.cairo_close_path(this.getHandle());
    }

    public void paint() {
        Context.cairo_paint(this.getHandle());
    }

    public void paintWithAlpha(double d) {
        Context.cairo_paint_with_alpha(this.getHandle(), d);
    }

    public void mask(Pattern pattern) {
        Context.cairo_mask(this.getHandle(), pattern.getHandle());
    }

    public void mask(Surface surface, double d, double d2) {
        Context.cairo_mask_surface(this.getHandle(), surface.getHandle(), d, d2);
    }

    public void stroke() {
        Context.cairo_stroke(this.getHandle());
    }

    public void strokePreserve() {
        Context.cairo_stroke_preserve(this.getHandle());
    }

    public void fill() {
        Context.cairo_fill(this.getHandle());
    }

    public void fillPreserve() {
        Context.cairo_fill_preserve(this.getHandle());
    }

    public void copyPage() {
        Context.cairo_copy_page(this.getHandle());
    }

    public void showPage() {
        Context.cairo_show_page(this.getHandle());
    }

    public boolean inStroke(double d, double d2) {
        return Context.cairo_in_stroke(this.getHandle(), d, d2);
    }

    public boolean inStroke(Point point) {
        return Context.cairo_in_stroke(this.getHandle(), point.getX(), point.getY());
    }

    public boolean inFill(double d, double d2) {
        return Context.cairo_in_fill(this.getHandle(), d, d2);
    }

    public boolean inFill(Point point) {
        return Context.cairo_in_fill(this.getHandle(), point.getX(), point.getY());
    }

    public Rectangle strokeExtents() {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        Context.cairo_stroke_extents(this.getHandle(), dArray, dArray2, dArray3, dArray4);
        return new Rectangle(dArray[0], dArray2[0], dArray3[0], dArray4[0]);
    }

    public Rectangle fillExtents() {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        Context.cairo_fill_extents(this.getHandle(), dArray, dArray2, dArray3, dArray4);
        return new Rectangle(dArray[0], dArray2[0], dArray3[0], dArray4[0]);
    }

    public void resetClip() {
        Context.cairo_reset_clip(this.getHandle());
    }

    public void clip() {
        Context.cairo_clip(this.getHandle());
    }

    public void clipPreserve() {
        Context.cairo_clip_preserve(this.getHandle());
    }

    public void selectFontFace(String string, FontSlant fontSlant, FontWeight fontWeight) {
        Context.cairo_select_font_face(this.getHandle(), string, fontSlant.getValue(), fontWeight.getValue());
    }

    public void setFontSize(double d) {
        Context.cairo_set_font_size(this.getHandle(), d);
    }

    public void setFontMatrix(Matrix matrix) {
        Context.cairo_set_font_matrix(this.getHandle(), matrix.getHandle());
    }

    public Matrix getFontMatrix() {
        return new Matrix(Context.cairo_get_font_matrix(this.getHandle()));
    }

    public void showText(String string) {
        Context.cairo_show_text(this.getHandle(), string);
    }

    public void showGlyphs(Glyph[] glyphArray) {
        if (glyphArray == null || glyphArray.length < 1) {
            return;
        }
        Handle[] handleArray = new Handle[glyphArray.length];
        for (int i = 0; i < glyphArray.length; ++i) {
            handleArray[i] = glyphArray[i].getHandle();
        }
        Context.cairo_show_glyphs(this.getHandle(), handleArray);
    }

    public FontFace getFontFace() {
        return new FontFace(Context.cairo_get_font_face(this.getHandle()));
    }

    public FontExtents fontExtents() {
        Handle handle = Struct.getNullHandle();
        Context.cairo_font_extents(this.getHandle(), handle);
        return new FontExtents(handle);
    }

    public void setFontFace(FontFace fontFace) {
        Context.cairo_set_font_face(this.getHandle(), fontFace.getHandle());
    }

    public TextExtents textExtents(String string) {
        Handle handle = Struct.getNullHandle();
        Context.cairo_text_extents(this.getHandle(), string, handle);
        return new TextExtents(handle);
    }

    public TextExtents glyphExtents(Glyph[] glyphArray) {
        Handle handle = Struct.getNullHandle();
        Handle[] handleArray = new Handle[glyphArray.length];
        for (int i = 0; i < glyphArray.length; ++i) {
            handleArray[i] = glyphArray[i].getHandle();
        }
        Context.cairo_glyph_extents(this.getHandle(), handleArray, handle);
        return new TextExtents(handle);
    }

    public void textPath(String string) {
        Context.cairo_text_path(this.getHandle(), string);
    }

    public void glyphPath(Glyph[] glyphArray) {
        Handle[] handleArray = new Handle[glyphArray.length];
        for (int i = 0; i < glyphArray.length; ++i) {
            handleArray[i] = glyphArray[i].getHandle();
        }
        Context.cairo_glyph_path(this.getHandle(), handleArray);
    }

    public Operator getOperator() {
        return Operator.intern(Context.cairo_get_operator(this.getHandle()));
    }

    public Pattern getSource() {
        Handle handle = Context.cairo_get_source(this.getHandle());
        return new Pattern(handle);
    }

    public double getTolerance() {
        return Context.cairo_get_tolerance(this.getHandle());
    }

    public Point getCurrentPoint() {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        Context.cairo_get_current_point(this.getHandle(), dArray, dArray2);
        return new Point(dArray[0], dArray2[0]);
    }

    public FillRule getFillRule() {
        return FillRule.intern(Context.cairo_get_fill_rule(this.getHandle()));
    }

    public double getLineWidth() {
        return Context.cairo_get_line_width(this.getHandle());
    }

    public LineCap getLineCap() {
        return LineCap.intern(Context.cairo_get_line_cap(this.getHandle()));
    }

    public LineJoin getLineJoin() {
        return LineJoin.intern(Context.cairo_get_line_join(this.getHandle()));
    }

    public double getMiterLimit() {
        return Context.cairo_get_miter_limit(this.getHandle());
    }

    public Matrix getMatrix() {
        Handle handle = Context.cairo_get_matrix(this.getHandle());
        return new Matrix(handle);
    }

    public Surface getTarget() {
        return new Surface(Context.cairo_get_target(this.getHandle()));
    }

    public Status status() {
        return Status.intern(Context.cairo_status(this.getHandle()));
    }

    public void setAntialias(Antialias antialias) {
        Context.cairo_set_antialias(this.getHandle(), antialias.getValue());
    }

    public Antialias getAntialias() {
        return Antialias.intern(Context.cairo_get_antialias(this.getHandle()));
    }

    public void setFontOptions(FontOptions fontOptions) {
        Context.cairo_set_font_options(this.getHandle(), fontOptions.getHandle());
    }

    public FontOptions getFontOptions() {
        return new FontOptions(Context.cairo_get_font_options(this.getHandle()));
    }

    public void ellipse(double d, double d2, double d3, double d4) {
        Context.cairo_new_path(this.getHandle());
        Context.cairo_move_to(this.getHandle(), d + d3, d2);
        Context.cairo_curve_to(this.getHandle(), d + d3, d2 + d4 * 0.5522847498, d + d3 * 0.5522847498, d2 + d4, d, d2 + d4);
        Context.cairo_curve_to(this.getHandle(), d - d3 * 0.5522847498, d2 + d4, d - d3, d2 + d4 * 0.5522847498, d - d3, d2);
        Context.cairo_curve_to(this.getHandle(), d - d3, d2 - d4 * 0.5522847498, d - d3 * 0.5522847498, d2 - d4, d, d2 - d4);
        Context.cairo_curve_to(this.getHandle(), d + d3 * 0.5522847498, d2 - d4, d + d3, d2 - d4 * 0.5522847498, d + d3, d2);
        Context.cairo_close_path(this.getHandle());
    }

    private static final native Handle cairo_create(Handle var0);

    private static final native void cairo_destroy(Handle var0);

    private static final native void cairo_save(Handle var0);

    private static final native void cairo_restore(Handle var0);

    private static final native void cairo_set_operator(Handle var0, int var1);

    private static final native void cairo_set_source(Handle var0, Handle var1);

    private static final native void cairo_set_source_rgb(Handle var0, double var1, double var3, double var5);

    private static final native void cairo_set_source_rgba(Handle var0, double var1, double var3, double var5, double var7);

    private static final native void cairo_set_source_surface(Handle var0, Handle var1, double var2, double var4);

    private static final native void cairo_set_tolerance(Handle var0, double var1);

    private static final native void cairo_set_fill_rule(Handle var0, int var1);

    private static final native void cairo_set_line_width(Handle var0, double var1);

    private static final native void cairo_set_line_cap(Handle var0, int var1);

    private static final native void cairo_set_line_join(Handle var0, int var1);

    private static final native void cairo_set_dash(Handle var0, double[] var1, double var2);

    private static final native void cairo_set_miter_limit(Handle var0, double var1);

    private static final native void cairo_translate(Handle var0, double var1, double var3);

    private static final native void cairo_scale(Handle var0, double var1, double var3);

    private static final native void cairo_rotate(Handle var0, double var1);

    private static final native void cairo_transform(Handle var0, Handle var1);

    private static final native void cairo_set_matrix(Handle var0, Handle var1);

    private static final native void cairo_identity_matrix(Handle var0);

    private static final native void cairo_user_to_device(Handle var0, double[] var1, double[] var2);

    private static final native void cairo_user_to_device_distance(Handle var0, double[] var1, double[] var2);

    private static final native void cairo_device_to_user(Handle var0, double[] var1, double[] var2);

    private static final native void cairo_device_to_user_distance(Handle var0, double[] var1, double[] var2);

    private static final native void cairo_new_path(Handle var0);

    private static final native void cairo_move_to(Handle var0, double var1, double var3);

    private static final native void cairo_line_to(Handle var0, double var1, double var3);

    private static final native void cairo_curve_to(Handle var0, double var1, double var3, double var5, double var7, double var9, double var11);

    private static final native void cairo_arc(Handle var0, double var1, double var3, double var5, double var7, double var9);

    private static final native void cairo_arc_negative(Handle var0, double var1, double var3, double var5, double var7, double var9);

    private static final native void cairo_rel_move_to(Handle var0, double var1, double var3);

    private static final native void cairo_rel_line_to(Handle var0, double var1, double var3);

    private static final native void cairo_rel_curve_to(Handle var0, double var1, double var3, double var5, double var7, double var9, double var11);

    private static final native void cairo_rectangle(Handle var0, double var1, double var3, double var5, double var7);

    private static final native void cairo_close_path(Handle var0);

    private static final native void cairo_paint(Handle var0);

    private static final native void cairo_paint_with_alpha(Handle var0, double var1);

    private static final native void cairo_mask(Handle var0, Handle var1);

    private static final native void cairo_mask_surface(Handle var0, Handle var1, double var2, double var4);

    private static final native void cairo_stroke(Handle var0);

    private static final native void cairo_stroke_preserve(Handle var0);

    private static final native void cairo_fill(Handle var0);

    private static final native void cairo_fill_preserve(Handle var0);

    private static final native void cairo_copy_page(Handle var0);

    private static final native void cairo_show_page(Handle var0);

    private static final native boolean cairo_in_stroke(Handle var0, double var1, double var3);

    private static final native boolean cairo_in_fill(Handle var0, double var1, double var3);

    private static final native void cairo_stroke_extents(Handle var0, double[] var1, double[] var2, double[] var3, double[] var4);

    private static final native void cairo_fill_extents(Handle var0, double[] var1, double[] var2, double[] var3, double[] var4);

    private static final native void cairo_reset_clip(Handle var0);

    private static final native void cairo_clip(Handle var0);

    private static final native void cairo_clip_preserve(Handle var0);

    private static final native void cairo_select_font_face(Handle var0, String var1, int var2, int var3);

    private static final native void cairo_set_font_size(Handle var0, double var1);

    private static final native void cairo_set_font_matrix(Handle var0, Handle var1);

    private static final native Handle cairo_get_font_matrix(Handle var0);

    private static final native void cairo_show_text(Handle var0, String var1);

    private static final native void cairo_show_glyphs(Handle var0, Handle[] var1);

    private static final native Handle cairo_get_font_face(Handle var0);

    private static final native void cairo_font_extents(Handle var0, Handle var1);

    private static final native void cairo_set_font_face(Handle var0, Handle var1);

    private static final native void cairo_text_extents(Handle var0, String var1, Handle var2);

    private static final native void cairo_glyph_extents(Handle var0, Handle[] var1, Handle var2);

    private static final native void cairo_text_path(Handle var0, String var1);

    private static final native void cairo_glyph_path(Handle var0, Handle[] var1);

    private static final native int cairo_get_operator(Handle var0);

    private static final native Handle cairo_get_source(Handle var0);

    private static final native double cairo_get_tolerance(Handle var0);

    private static final native void cairo_get_current_point(Handle var0, double[] var1, double[] var2);

    private static final native int cairo_get_fill_rule(Handle var0);

    private static final native double cairo_get_line_width(Handle var0);

    private static final native int cairo_get_line_cap(Handle var0);

    private static final native int cairo_get_line_join(Handle var0);

    private static final native double cairo_get_miter_limit(Handle var0);

    private static final native Handle cairo_get_matrix(Handle var0);

    private static final native Handle cairo_get_target(Handle var0);

    private static final native int cairo_status(Handle var0);

    private static final native void cairo_set_antialias(Handle var0, int var1);

    private static final native int cairo_get_antialias(Handle var0);

    private static final native void cairo_set_font_options(Handle var0, Handle var1);

    private static final native Handle cairo_get_font_options(Handle var0);
}

