/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListenerList
implements Serializable {
    static final long serialVersionUID = -5677132037850737084L;
    private static final Object[] NO_LISTENERS = new Object[0];
    protected transient Object[] listenerList = NO_LISTENERS;

    public <T extends EventListener> void add(Class<T> t, T listener) {
        if (listener == null) {
            return;
        }
        if (!t.isInstance(listener)) {
            throw new IllegalArgumentException();
        }
        int oldLength = this.listenerList.length;
        Object[] newList = new Object[oldLength + 2];
        if (oldLength > 0) {
            System.arraycopy(this.listenerList, 0, newList, 0, oldLength);
        }
        newList[oldLength] = t;
        newList[oldLength + 1] = listener;
        this.listenerList = newList;
    }

    public int getListenerCount() {
        return this.listenerList.length / 2;
    }

    public int getListenerCount(Class<?> t) {
        int result = 0;
        int i = 0;
        while (i < this.listenerList.length) {
            if (t == this.listenerList[i]) {
                ++result;
            }
            i += 2;
        }
        return result;
    }

    public Object[] getListenerList() {
        return this.listenerList;
    }

    public <T extends EventListener> T[] getListeners(Class<T> c) {
        int count = this.getListenerCount(c);
        EventListener[] result = (EventListener[])Array.newInstance(c, count);
        int f = 0;
        int i = this.listenerList.length - 2;
        while (i >= 0) {
            if (this.listenerList[i] == c) {
                result[f++] = (EventListener)this.listenerList[i + 1];
            }
            i -= 2;
        }
        return result;
    }

    public <T extends EventListener> void remove(Class<T> t, T listener) {
        if (listener == null) {
            return;
        }
        if (!t.isInstance(listener)) {
            throw new IllegalArgumentException();
        }
        Object[] oldList = this.listenerList;
        int oldLength = oldList.length;
        int i = 0;
        while (i < oldLength) {
            if (oldList[i] == t && oldList[i + 1] == listener) {
                Object[] newList;
                if (oldLength == 2) {
                    newList = NO_LISTENERS;
                } else {
                    newList = new Object[oldLength - 2];
                    if (i > 0) {
                        System.arraycopy(oldList, 0, newList, 0, i);
                    }
                    if (i < oldLength - 2) {
                        System.arraycopy(oldList, i + 2, newList, i, oldLength - 2 - i);
                    }
                }
                this.listenerList = newList;
                return;
            }
            i += 2;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("EventListenerList: ");
        buf.append(this.listenerList.length / 2);
        buf.append(" listeners: ");
        int i = 0;
        while (i < this.listenerList.length) {
            buf.append(" type ");
            buf.append(((Class)this.listenerList[i]).getName());
            buf.append(" listener ");
            buf.append(this.listenerList[i + 1]);
            i += 2;
        }
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int i = 0;
        while (i < this.listenerList.length) {
            Class cl = (Class)this.listenerList[i];
            EventListener l = (EventListener)this.listenerList[i + 1];
            if (l != null && l instanceof Serializable) {
                out.writeObject(cl.getName());
                out.writeObject(l);
            }
            i += 2;
        }
        out.writeObject(null);
    }

    private <T extends EventListener> void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        Object type;
        this.listenerList = NO_LISTENERS;
        in.defaultReadObject();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        while ((type = in.readObject()) != null) {
            EventListener l = (EventListener)in.readObject();
            this.add(Class.forName((String)type, true, cl), l);
        }
    }
}

