/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JComboBox
extends JComponent
implements ItemSelectable,
ListDataListener,
ActionListener,
Accessible {
    private static final long serialVersionUID = 5654585963292734470L;
    private static final int DEFAULT_MAXIMUM_ROW_COUNT = 8;
    protected ComboBoxModel dataModel;
    protected ListCellRenderer renderer;
    protected ComboBoxEditor editor;
    protected int maximumRowCount;
    protected boolean isEditable;
    protected Object selectedItemReminder;
    protected KeySelectionManager keySelectionManager;
    protected String actionCommand;
    protected boolean lightWeightPopupEnabled;
    private Action action;
    private Object prototypeDisplayValue;

    public JComboBox(ComboBoxModel model) {
        this.setEditable(false);
        this.setEnabled(true);
        this.setMaximumRowCount(8);
        this.setModel(model);
        this.setActionCommand("comboBoxChanged");
        this.lightWeightPopupEnabled = true;
        this.isEditable = false;
        this.updateUI();
    }

    public JComboBox(Object[] itemArray) {
        this(new DefaultComboBoxModel(itemArray));
        if (itemArray.length > 0) {
            this.setSelectedIndex(0);
        }
    }

    public JComboBox(Vector<?> itemVector) {
        this(new DefaultComboBoxModel(itemVector));
        if (itemVector.size() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public JComboBox() {
        this(new DefaultComboBoxModel());
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    protected void installAncestorListener() {
    }

    public void setUI(ComboBoxUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((ComboBoxUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return "ComboBoxUI";
    }

    public ComboBoxUI getUI() {
        return (ComboBoxUI)this.ui;
    }

    public void setModel(ComboBoxModel newDataModel) {
        if (this.dataModel != null) {
            if (this.dataModel == newDataModel) {
                return;
            }
            this.dataModel.removeListDataListener(this);
        }
        newDataModel.addListDataListener(this);
        ComboBoxModel oldDataModel = this.dataModel;
        this.dataModel = newDataModel;
        this.selectedItemReminder = newDataModel.getSelectedItem();
        this.firePropertyChange("model", oldDataModel, this.dataModel);
    }

    public ComboBoxModel getModel() {
        return this.dataModel;
    }

    public void setLightWeightPopupEnabled(boolean enabled) {
        this.lightWeightPopupEnabled = enabled;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setEditable(boolean editable) {
        if (this.isEditable != editable) {
            this.isEditable = editable;
            this.firePropertyChange("editable", !this.isEditable, this.isEditable);
        }
    }

    public void setMaximumRowCount(int rowCount) {
        if (this.maximumRowCount != rowCount) {
            int oldMaximumRowCount = this.maximumRowCount;
            this.maximumRowCount = rowCount;
            this.firePropertyChange("maximumRowCount", oldMaximumRowCount, this.maximumRowCount);
        }
    }

    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public void setRenderer(ListCellRenderer aRenderer) {
        if (this.renderer != aRenderer) {
            ListCellRenderer oldRenderer = this.renderer;
            this.renderer = aRenderer;
            this.firePropertyChange("renderer", oldRenderer, this.renderer);
        }
    }

    public ListCellRenderer getRenderer() {
        return this.renderer;
    }

    public void setEditor(ComboBoxEditor newEditor) {
        if (this.editor == newEditor) {
            return;
        }
        if (this.editor != null) {
            this.editor.removeActionListener(this);
        }
        ComboBoxEditor oldEditor = this.editor;
        this.editor = newEditor;
        if (this.editor != null) {
            this.editor.addActionListener(this);
        }
        this.firePropertyChange("editor", oldEditor, this.editor);
    }

    public ComboBoxEditor getEditor() {
        return this.editor;
    }

    public void setSelectedItem(Object item) {
        this.dataModel.setSelectedItem(item);
        this.fireActionEvent();
    }

    public Object getSelectedItem() {
        return this.dataModel.getSelectedItem();
    }

    public void setSelectedIndex(int index) {
        if (index < -1 || index >= this.dataModel.getSize()) {
            throw new IllegalArgumentException("illegal index: " + index);
        }
        this.setSelectedItem(index == -1 ? null : this.dataModel.getElementAt(index));
    }

    public int getSelectedIndex() {
        Object selectedItem = this.getSelectedItem();
        if (selectedItem != null) {
            if (this.dataModel instanceof DefaultComboBoxModel) {
                return ((DefaultComboBoxModel)this.dataModel).getIndexOf(selectedItem);
            }
            int size = this.dataModel.getSize();
            int i = 0;
            while (i < size) {
                Object o = this.dataModel.getElementAt(i);
                if (selectedItem != null ? selectedItem.equals(o) : o == null) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public Object getPrototypeDisplayValue() {
        return this.prototypeDisplayValue;
    }

    public void setPrototypeDisplayValue(Object value) {
        Object oldValue = this.prototypeDisplayValue;
        this.prototypeDisplayValue = value;
        this.firePropertyChange("prototypeDisplayValue", oldValue, value);
    }

    public void addItem(Object element) {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Unable to add the item because the data model it is not an instance of MutableComboBoxModel.");
        }
        ((MutableComboBoxModel)this.dataModel).addElement(element);
    }

    public void insertItemAt(Object element, int index) {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Unable to insert the item because the data model it is not an instance of MutableComboBoxModel.");
        }
        ((MutableComboBoxModel)this.dataModel).insertElementAt(element, index);
    }

    public void removeItem(Object element) {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Unable to remove the item because the data model it is not an instance of MutableComboBoxModel.");
        }
        ((MutableComboBoxModel)this.dataModel).removeElement(element);
    }

    public void removeItemAt(int index) {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Unable to remove the item because the data model it is not an instance of MutableComboBoxModel.");
        }
        ((MutableComboBoxModel)this.dataModel).removeElementAt(index);
    }

    public void removeAllItems() {
        if (this.dataModel instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)this.dataModel).removeAllElements();
        } else if (this.dataModel instanceof MutableComboBoxModel) {
            MutableComboBoxModel mcbm = (MutableComboBoxModel)this.dataModel;
            int i = mcbm.getSize() - 1;
            while (i >= 0) {
                mcbm.removeElementAt(i);
                --i;
            }
        } else {
            throw new RuntimeException("Unable to remove the items because the data model it is not an instance of MutableComboBoxModel.");
        }
    }

    public void showPopup() {
        this.setPopupVisible(true);
    }

    public void hidePopup() {
        this.setPopupVisible(false);
    }

    public void setPopupVisible(boolean visible) {
        this.getUI().setPopupVisible(this, visible);
    }

    public boolean isPopupVisible() {
        return this.getUI().isPopupVisible(this);
    }

    public void setActionCommand(String aCommand) {
        this.actionCommand = aCommand;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setAction(Action a) {
        this.action = a;
        this.configurePropertiesFromAction(this.action);
        if (this.action != null) {
            this.addActionListener(this.action);
        }
    }

    public Action getAction() {
        return this.action;
    }

    protected void configurePropertiesFromAction(Action a) {
        if (a == null) {
            this.setEnabled(true);
            this.setToolTipText(null);
        } else {
            this.setEnabled(a.isEnabled());
            this.setToolTipText((String)a.getValue("ShortDescription"));
        }
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                Action act = (Action)e.getSource();
                JComboBox.this.configurePropertiesFromAction(act);
            }
        };
    }

    protected void fireItemStateChanged(ItemEvent e) {
        ItemListener[] ll = this.getItemListeners();
        int i = 0;
        while (i < ll.length) {
            ll[i].itemStateChanged(e);
            ++i;
        }
    }

    protected void fireActionEvent() {
        ActionListener[] ll = this.getActionListeners();
        int i = 0;
        while (i < ll.length) {
            ll[i].actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
            ++i;
        }
    }

    public void firePopupMenuCanceled() {
        PopupMenuListener[] listeners = this.getPopupMenuListeners();
        PopupMenuEvent e = new PopupMenuEvent(this);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].popupMenuCanceled(e);
            ++i;
        }
    }

    public void firePopupMenuWillBecomeInvisible() {
        PopupMenuListener[] listeners = this.getPopupMenuListeners();
        PopupMenuEvent e = new PopupMenuEvent(this);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].popupMenuWillBecomeInvisible(e);
            ++i;
        }
    }

    public void firePopupMenuWillBecomeVisible() {
        PopupMenuListener[] listeners = this.getPopupMenuListeners();
        PopupMenuEvent e = new PopupMenuEvent(this);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].popupMenuWillBecomeVisible(e);
            ++i;
        }
    }

    protected void selectedItemChanged() {
        Object newSelection;
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 2));
        }
        if ((newSelection = this.getSelectedItem()) != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, newSelection, 1));
        }
        this.fireActionEvent();
        this.selectedItemReminder = newSelection;
    }

    @Override
    public Object[] getSelectedObjects() {
        return new Object[]{this.getSelectedItem()};
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setSelectedItem(this.getEditor().getItem());
        this.setPopupVisible(false);
    }

    public boolean selectWithKeyChar(char keyChar) {
        if (this.keySelectionManager == null) {
            this.keySelectionManager = this.createDefaultKeySelectionManager();
        }
        int index = this.keySelectionManager.selectionForKey(keyChar, this.getModel());
        boolean retVal = false;
        if (index >= 0) {
            this.setSelectedIndex(index);
            retVal = true;
        }
        return retVal;
    }

    @Override
    public void intervalAdded(ListDataEvent event) {
        this.repaint();
    }

    @Override
    public void intervalRemoved(ListDataEvent event) {
        this.repaint();
    }

    @Override
    public void contentsChanged(ListDataEvent event) {
        if (event.getIndex0() == -1 && event.getIndex1() == -1) {
            this.selectedItemChanged();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldEnabled = super.isEnabled();
        if (enabled != oldEnabled) {
            super.setEnabled(enabled);
            this.firePropertyChange("enabled", oldEnabled, enabled);
        }
    }

    public void configureEditor(ComboBoxEditor anEditor, Object anItem) {
        anEditor.setItem(anItem);
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 9) {
            this.setPopupVisible(false);
        } else {
            super.processKeyEvent(e);
        }
    }

    public void setKeySelectionManager(KeySelectionManager aManager) {
        this.keySelectionManager = aManager;
    }

    public KeySelectionManager getKeySelectionManager() {
        return this.keySelectionManager;
    }

    public int getItemCount() {
        return this.dataModel.getSize();
    }

    public Object getItemAt(int index) {
        return this.dataModel.getElementAt(index);
    }

    protected KeySelectionManager createDefaultKeySelectionManager() {
        return new DefaultKeySelectionManager();
    }

    @Override
    protected String paramString() {
        String superParamStr = super.paramString();
        StringBuffer sb = new StringBuffer();
        sb.append(",isEditable=").append(this.isEditable());
        sb.append(",lightWeightPopupEnabled=").append(this.isLightWeightPopupEnabled());
        sb.append(",maximumRowCount=").append(this.getMaximumRowCount());
        sb.append(",selectedItemReminder=");
        if (this.selectedItemReminder != null) {
            sb.append(this.selectedItemReminder);
        }
        return String.valueOf(superParamStr) + sb.toString();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJComboBox();
        }
        return this.accessibleContext;
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    @Override
    public void addItemListener(ItemListener listener) {
        this.listenerList.add(ItemListener.class, listener);
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        this.listenerList.remove(ItemListener.class, listener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(ItemListener.class);
    }

    public void addPopupMenuListener(PopupMenuListener listener) {
        this.listenerList.add(PopupMenuListener.class, listener);
    }

    public void removePopupMenuListener(PopupMenuListener listener) {
        this.listenerList.remove(PopupMenuListener.class, listener);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return (PopupMenuListener[])this.getListeners(PopupMenuListener.class);
    }

    protected class AccessibleJComboBox
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleSelection {
        private static final long serialVersionUID = 8217828307256675666L;

        public int getAccessibleChildrenCount() {
            ComboBoxUI ui = JComboBox.this.getUI();
            int count = ui != null ? ui.getAccessibleChildrenCount(JComboBox.this) : super.getAccessibleChildrenCount();
            return count;
        }

        public Accessible getAccessibleChild(int index) {
            ComboBoxUI ui = JComboBox.this.getUI();
            Accessible child = null;
            child = ui != null ? ui.getAccessibleChild(JComboBox.this, index) : super.getAccessibleChild(index);
            return child;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleSelection(int index) {
            AccessibleSelection s;
            ComboPopup cPopup;
            JList l;
            AccessibleContext listCtx;
            Accessible popup = JComboBox.this.getUI().getAccessibleChild(JComboBox.this, 0);
            Accessible selected = null;
            if (popup != null && popup instanceof ComboPopup && (listCtx = (l = (cPopup = (ComboPopup)((Object)popup)).getList()).getAccessibleContext()) != null && (s = listCtx.getAccessibleSelection()) != null) {
                selected = s.getAccessibleSelection(index);
            }
            return selected;
        }

        public boolean isAccessibleChildSelected(int index) {
            return JComboBox.this.getSelectedIndex() == index;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public String getAccessibleActionDescription(int actionIndex) {
            return UIManager.getString("ComboBox.togglePopupText");
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public boolean doAccessibleAction(int actionIndex) {
            boolean actionPerformed = false;
            if (actionIndex == 0) {
                JComboBox.this.setPopupVisible(!JComboBox.this.isPopupVisible());
                actionPerformed = true;
            }
            return actionPerformed;
        }

        public int getAccessibleSelectionCount() {
            Object sel = JComboBox.this.getSelectedItem();
            int count = 0;
            if (sel != null) {
                count = 1;
            }
            return count;
        }

        public void addAccessibleSelection(int index) {
            JComboBox.this.setSelectedIndex(index);
        }

        public void removeAccessibleSelection(int index) {
            if (JComboBox.this.getSelectedIndex() == index) {
                this.clearAccessibleSelection();
            }
        }

        public void clearAccessibleSelection() {
            JComboBox.this.setSelectedIndex(-1);
        }

        public void selectAllAccessibleSelection() {
        }
    }

    private class DefaultKeySelectionManager
    implements KeySelectionManager {
        private DefaultKeySelectionManager() {
        }

        public int selectionForKey(char aKey, ComboBoxModel aModel) {
            String nextItem;
            int selectedIndex = JComboBox.this.getSelectedIndex();
            int i = selectedIndex + 1;
            while (i < aModel.getSize()) {
                nextItem = aModel.getElementAt(i).toString();
                if (nextItem.charAt(0) == aKey) {
                    return i;
                }
                ++i;
            }
            i = 0;
            while (i <= selectedIndex) {
                nextItem = aModel.getElementAt(i).toString();
                if (nextItem.charAt(0) == aKey) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    public static interface KeySelectionManager {
        public int selectionForKey(char var1, ComboBoxModel var2);
    }
}

