/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hashtable<K, V>
extends Dictionary<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final long serialVersionUID = 1421746759512286392L;
    private int threshold;
    private final float loadFactor;
    transient HashEntry<K, V>[] buckets;
    transient int modCount;
    transient int size;
    private transient Set<K> keys;
    private transient Collection<V> values;
    private transient Set<Map.Entry<K, V>> entries;

    public Hashtable() {
        this(11, 0.75f);
    }

    public Hashtable(Map<? extends K, ? extends V> m) {
        this(Math.max(m.size() * 2, 11), 0.75f);
        this.putAll(m);
    }

    public Hashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public Hashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (!(loadFactor > 0.0f)) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.buckets = new HashEntry[initialCapacity];
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    @Override
    public synchronized int size() {
        return this.size;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Enumeration<K> keys() {
        return new KeyEnumerator();
    }

    @Override
    public Enumeration<V> elements() {
        return new ValueEnumerator();
    }

    public synchronized boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int i = this.buckets.length - 1;
        while (i >= 0) {
            HashEntry<K, V> e = this.buckets[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
            --i;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        int idx = this.hash(key);
        HashEntry<K, V> e = this.buckets[idx];
        while (e != null) {
            if (e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public synchronized V get(Object key) {
        int idx = this.hash(key);
        HashEntry<K, V> e = this.buckets[idx];
        while (e != null) {
            if (e.key.equals(key)) {
                return (V)e.value;
            }
            e = e.next;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized V put(K key, V value) {
        idx = this.hash(key);
        e = this.buckets[idx];
        if (value != null) ** GOTO lbl10
        throw new NullPointerException();
lbl-1000:
        // 1 sources

        {
            if (e.key.equals(key)) {
                r = e.value;
                e.value = value;
                return (V)r;
            }
            e = e.next;
lbl10:
            // 2 sources

            ** while (e != null)
        }
lbl11:
        // 1 sources

        ++this.modCount;
        if (++this.size > this.threshold) {
            this.rehash();
            idx = this.hash(key);
        }
        e = new HashEntry<K, V>(key, value);
        e.next = this.buckets[idx];
        this.buckets[idx] = e;
        return null;
    }

    @Override
    public synchronized V remove(Object key) {
        int idx = this.hash(key);
        HashEntry<K, V> e = this.buckets[idx];
        HashEntry<K, V> last = null;
        while (e != null) {
            if (e.key.equals(key)) {
                ++this.modCount;
                if (last == null) {
                    this.buckets[idx] = e.next;
                } else {
                    last.next = e.next;
                }
                --this.size;
                return (V)e.value;
            }
            last = e;
            e = e.next;
        }
        return null;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        Map<K, V> addMap = m;
        for (Map.Entry<K, V> e : addMap.entrySet()) {
            if (e instanceof AbstractMap.SimpleEntry) {
                AbstractMap.SimpleEntry entry = (AbstractMap.SimpleEntry)e;
                this.put(entry.key, entry.value);
                continue;
            }
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        if (this.size > 0) {
            ++this.modCount;
            Arrays.fill(this.buckets, null);
            this.size = 0;
        }
    }

    public synchronized Object clone() {
        Hashtable copy = null;
        try {
            copy = (Hashtable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        copy.buckets = new HashEntry[this.buckets.length];
        copy.putAllInternal(this);
        copy.keys = null;
        copy.values = null;
        copy.entries = null;
        return copy;
    }

    public synchronized String toString() {
        EntryIterator entries = new EntryIterator();
        StringBuffer r = new StringBuffer("{");
        int pos = this.size;
        while (pos > 0) {
            r.append(entries.next());
            if (pos > 1) {
                r.append(", ");
            }
            --pos;
        }
        r.append("}");
        return r.toString();
    }

    @Override
    public Set<K> keySet() {
        if (this.keys == null) {
            AbstractSet r = new AbstractSet<K>(){

                @Override
                public int size() {
                    return Hashtable.this.size;
                }

                @Override
                public Iterator<K> iterator() {
                    return new KeyIterator();
                }

                @Override
                public void clear() {
                    Hashtable.this.clear();
                }

                @Override
                public boolean contains(Object o) {
                    if (o == null) {
                        return false;
                    }
                    return Hashtable.this.containsKey(o);
                }

                @Override
                public boolean remove(Object o) {
                    return Hashtable.this.remove(o) != null;
                }
            };
            this.keys = new Collections.SynchronizedSet<K>((Object)this, r);
        }
        return this.keys;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            AbstractCollection r = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return Hashtable.this.size;
                }

                @Override
                public Iterator<V> iterator() {
                    return new ValueIterator();
                }

                @Override
                public void clear() {
                    Hashtable.this.clear();
                }
            };
            this.values = new Collections.SynchronizedCollection<V>(this, r);
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            AbstractSet r = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return Hashtable.this.size;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new EntryIterator();
                }

                @Override
                public void clear() {
                    Hashtable.this.clear();
                }

                @Override
                public boolean contains(Object o) {
                    return Hashtable.this.getEntry(o) != null;
                }

                @Override
                public boolean remove(Object o) {
                    HashEntry e = Hashtable.this.getEntry(o);
                    if (e != null) {
                        Hashtable.this.remove(e.key);
                        return true;
                    }
                    return false;
                }
            };
            this.entries = new Collections.SynchronizedSet<Map.Entry<K, V>>((Object)this, r);
        }
        return this.entries;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        return this.entrySet().equals(((Map)o).entrySet());
    }

    @Override
    public synchronized int hashCode() {
        EntryIterator itr = new EntryIterator();
        int hashcode = 0;
        int pos = this.size;
        while (pos > 0) {
            hashcode += ((Map.Entry)itr.next()).hashCode();
            --pos;
        }
        return hashcode;
    }

    private int hash(Object key) {
        int hash = key.hashCode() % this.buckets.length;
        return hash < 0 ? -hash : hash;
    }

    HashEntry<K, V> getEntry(Object o) {
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Object key = ((Map.Entry)o).getKey();
        if (key == null) {
            return null;
        }
        int idx = this.hash(key);
        HashEntry<K, V> e = this.buckets[idx];
        while (e != null) {
            if (e.equals(o)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    void putAllInternal(Map<? extends K, ? extends V> m) {
        Map<K, V> addMap = m;
        Iterator<Map.Entry<K, V>> it = addMap.entrySet().iterator();
        this.size = 0;
        while (it.hasNext()) {
            Map.Entry<K, V> e = it.next();
            ++this.size;
            K key = e.getKey();
            int idx = this.hash(key);
            HashEntry<K, V> he = new HashEntry<K, V>(key, e.getValue());
            he.next = this.buckets[idx];
            this.buckets[idx] = he;
        }
    }

    protected void rehash() {
        HashEntry<K, V>[] oldBuckets = this.buckets;
        int newcapacity = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)newcapacity * this.loadFactor);
        this.buckets = new HashEntry[newcapacity];
        int i = oldBuckets.length - 1;
        while (i >= 0) {
            HashEntry<K, V> e = oldBuckets[i];
            while (e != null) {
                HashEntry next;
                int idx = this.hash(e.key);
                HashEntry<K, V> dest = this.buckets[idx];
                if (dest != null) {
                    next = dest.next;
                    while (next != null) {
                        dest = next;
                        next = dest.next;
                    }
                    dest.next = e;
                } else {
                    this.buckets[idx] = e;
                }
                next = e.next;
                e.next = null;
                e = next;
            }
            --i;
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.buckets.length);
        s.writeInt(this.size);
        EntryIterator it = new EntryIterator();
        while (it.hasNext()) {
            HashEntry entry = (HashEntry)it.next();
            s.writeObject(entry.key);
            s.writeObject(entry.value);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.buckets = new HashEntry[s.readInt()];
        int len = s.readInt();
        while (--len >= 0) {
            this.put(s.readObject(), s.readObject());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryEnumerator
    implements Enumeration<Map.Entry<K, V>> {
        int count;
        int idx;
        HashEntry<K, V> next;

        EntryEnumerator() {
            this.count = Hashtable.this.size;
            this.idx = Hashtable.this.buckets.length;
        }

        @Override
        public boolean hasMoreElements() {
            return this.count > 0;
        }

        @Override
        public Map.Entry<K, V> nextElement() {
            if (this.count == 0) {
                throw new NoSuchElementException("Hashtable Enumerator");
            }
            --this.count;
            HashEntry e = this.next;
            while (e == null) {
                if (this.idx <= 0) {
                    return null;
                }
                e = Hashtable.this.buckets[--this.idx];
            }
            this.next = e.next;
            return e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        int knownMod;
        int count;
        int idx;
        HashEntry<K, V> last;
        HashEntry<K, V> next;

        EntryIterator() {
            this.knownMod = Hashtable.this.modCount;
            this.count = Hashtable.this.size;
            this.idx = Hashtable.this.buckets.length;
        }

        @Override
        public boolean hasNext() {
            return this.count > 0;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.knownMod != Hashtable.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            HashEntry e = this.next;
            while (e == null) {
                if (this.idx <= 0) {
                    return null;
                }
                e = Hashtable.this.buckets[--this.idx];
            }
            this.next = e.next;
            this.last = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.knownMod != Hashtable.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.last == null) {
                throw new IllegalStateException();
            }
            Hashtable.this.remove(this.last.key);
            this.last = null;
            ++this.knownMod;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HashEntry<K, V>
    extends AbstractMap.SimpleEntry<K, V> {
        HashEntry<K, V> next;

        HashEntry(K key, V value) {
            super(key, value);
        }

        @Override
        public V setValue(V newVal) {
            if (newVal == null) {
                throw new NullPointerException();
            }
            return super.setValue(newVal);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyEnumerator
    implements Enumeration<K> {
        private EntryEnumerator enumerator;

        KeyEnumerator() {
            this.enumerator = new EntryEnumerator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.enumerator.hasMoreElements();
        }

        @Override
        public K nextElement() {
            HashEntry entry = (HashEntry)this.enumerator.nextElement();
            Object retVal = null;
            if (entry != null) {
                retVal = entry.key;
            }
            return retVal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    implements Iterator<K> {
        private EntryIterator iterator;

        KeyIterator() {
            this.iterator = new EntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            return ((HashEntry)this.iterator.next()).key;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueEnumerator
    implements Enumeration<V> {
        private EntryEnumerator enumerator;

        ValueEnumerator() {
            this.enumerator = new EntryEnumerator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.enumerator.hasMoreElements();
        }

        @Override
        public V nextElement() {
            HashEntry entry = (HashEntry)this.enumerator.nextElement();
            Object retVal = null;
            if (entry != null) {
                retVal = entry.value;
            }
            return retVal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    implements Iterator<V> {
        private EntryIterator iterator;

        ValueIterator() {
            this.iterator = new EntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return ((HashEntry)this.iterator.next()).value;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

