/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import gnu.classpath.ServiceFactory;
import gnu.classpath.SystemProperties;
import gnu.java.nio.charset.Provider;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Charset
implements Comparable<Charset> {
    private CharsetEncoder cachedEncoder;
    private CharsetDecoder cachedDecoder;
    private static CharsetProvider[] providers;
    private final String canonicalName;
    private final String[] aliases;

    protected Charset(String canonicalName, String[] aliases) {
        Charset.checkName(canonicalName);
        if (aliases != null) {
            int n = aliases.length;
            int i = 0;
            while (i < n) {
                Charset.checkName(aliases[i]);
                ++i;
            }
        }
        this.cachedEncoder = null;
        this.cachedDecoder = null;
        this.canonicalName = canonicalName;
        this.aliases = aliases;
    }

    private static void checkName(String name) {
        int n = name.length();
        if (n == 0) {
            throw new IllegalCharsetNameException(name);
        }
        char ch = name.charAt(0);
        if (!('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9')) {
            throw new IllegalCharsetNameException(name);
        }
        int i = 1;
        while (i < n) {
            ch = name.charAt(i);
            if (!('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9' || ch == '-' || ch == '.' || ch == ':' || ch == '_')) {
                throw new IllegalCharsetNameException(name);
            }
            ++i;
        }
    }

    public static Charset defaultCharset() {
        String encoding;
        try {
            encoding = SystemProperties.getProperty("file.encoding");
        }
        catch (SecurityException securityException) {
            encoding = "ISO-8859-1";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            encoding = "ISO-8859-1";
        }
        try {
            return Charset.forName(encoding);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        throw new IllegalStateException("Can't get default charset!");
    }

    public static boolean isSupported(String charsetName) {
        return Charset.charsetForName(charsetName) != null;
    }

    public static Charset forName(String charsetName) {
        if (charsetName == null) {
            throw new IllegalArgumentException("Charset name must not be null.");
        }
        Charset cs = Charset.charsetForName(charsetName);
        if (cs == null) {
            throw new UnsupportedCharsetException(charsetName);
        }
        return cs;
    }

    private static Charset charsetForName(String charsetName) {
        Charset.checkName(charsetName);
        Charset cs = Charset.provider().charsetForName(charsetName);
        if (cs == null) {
            CharsetProvider[] providers = Charset.providers2();
            int i = 0;
            while (i < providers.length) {
                cs = providers[i].charsetForName(charsetName);
                if (cs != null) break;
                ++i;
            }
        }
        return cs;
    }

    public static SortedMap<String, Charset> availableCharsets() {
        TreeMap<String, Charset> charsets = new TreeMap<String, Charset>(String.CASE_INSENSITIVE_ORDER);
        Iterator<Charset> i = Charset.provider().charsets();
        while (i.hasNext()) {
            Charset cs = i.next();
            charsets.put(cs.name(), cs);
        }
        CharsetProvider[] providers = Charset.providers2();
        int j = 0;
        while (j < providers.length) {
            Iterator<Charset> i2 = providers[j].charsets();
            while (i2.hasNext()) {
                Charset cs = i2.next();
                charsets.put(cs.name(), cs);
            }
            ++j;
        }
        return Collections.unmodifiableSortedMap(charsets);
    }

    private static CharsetProvider provider() {
        try {
            String s = System.getProperty("charset.provider");
            if (s != null) {
                CharsetProvider p = (CharsetProvider)Class.forName(s).newInstance();
                return p;
            }
        }
        catch (Exception exception) {}
        return Provider.provider();
    }

    private static CharsetProvider[] providers2() {
        if (providers == null) {
            try {
                Iterator i = ServiceFactory.lookupProviders(CharsetProvider.class);
                LinkedHashSet<Object> set = new LinkedHashSet<Object>();
                while (i.hasNext()) {
                    set.add(i.next());
                }
                providers = new CharsetProvider[set.size()];
                set.toArray(providers);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return providers;
    }

    public final String name() {
        return this.canonicalName;
    }

    public final Set<String> aliases() {
        if (this.aliases == null) {
            return Collections.emptySet();
        }
        int n = this.aliases.length;
        HashSet<String> aliasSet = new HashSet<String>(n);
        int i = 0;
        while (i < n) {
            aliasSet.add(this.aliases[i]);
            ++i;
        }
        return Collections.unmodifiableSet(aliasSet);
    }

    public String displayName() {
        return this.canonicalName;
    }

    public String displayName(Locale locale) {
        return this.canonicalName;
    }

    public final boolean isRegistered() {
        return !this.canonicalName.startsWith("x-") && !this.canonicalName.startsWith("X-");
    }

    public abstract boolean contains(Charset var1);

    public abstract CharsetDecoder newDecoder();

    public abstract CharsetEncoder newEncoder();

    public boolean canEncode() {
        return true;
    }

    public final synchronized ByteBuffer encode(CharBuffer cb) {
        try {
            if (this.cachedEncoder == null) {
                this.cachedEncoder = this.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            } else {
                this.cachedEncoder.reset();
            }
            return this.cachedEncoder.encode(cb);
        }
        catch (CharacterCodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public final ByteBuffer encode(String str) {
        return this.encode(CharBuffer.wrap(str));
    }

    public final synchronized CharBuffer decode(ByteBuffer bb) {
        try {
            if (this.cachedDecoder == null) {
                this.cachedDecoder = this.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            } else {
                this.cachedDecoder.reset();
            }
            return this.cachedDecoder.decode(bb);
        }
        catch (CharacterCodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public final int compareTo(Charset other) {
        return this.canonicalName.compareToIgnoreCase(other.canonicalName);
    }

    public final int hashCode() {
        return this.canonicalName.hashCode();
    }

    public final boolean equals(Object ob) {
        if (ob instanceof Charset) {
            return this.canonicalName.equalsIgnoreCase(((Charset)ob).canonicalName);
        }
        return false;
    }

    public final String toString() {
        return this.canonicalName;
    }
}

