/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.Point;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public abstract class ColorModel
implements Transparency {
    protected int pixel_bits;
    protected int transferType;
    int[] bits;
    ColorSpace cspace;
    int transparency;
    boolean hasAlpha;
    boolean isAlphaPremultiplied;
    private static final ColorModel S_RGB_MODEL = new SRGBColorModel();

    static int[] nArray(int value, int times) {
        int[] array = new int[times];
        Arrays.fill(array, value);
        return array;
    }

    static byte[] nArray(byte value, int times) {
        byte[] array = new byte[times];
        Arrays.fill(array, value);
        return array;
    }

    public ColorModel(int bits) {
        this(bits * 4, ColorModel.nArray(bits, 4), ColorSpace.getInstance(1000), true, false, 3, Buffers.smallestAppropriateTransferType(bits * 4));
    }

    protected ColorModel(int pixel_bits, int[] bits, ColorSpace cspace, boolean hasAlpha, boolean isAlphaPremultiplied, int transparency, int transferType) {
        int bits_sum = 0;
        int i = 0;
        while (i < bits.length) {
            if (bits[i] < 0) {
                throw new IllegalArgumentException();
            }
            bits_sum |= bits[i];
            ++i;
        }
        if (bits.length < cspace.getNumComponents() || bits_sum < 1) {
            throw new IllegalArgumentException();
        }
        this.pixel_bits = pixel_bits;
        this.bits = bits;
        this.cspace = cspace;
        this.hasAlpha = hasAlpha;
        this.isAlphaPremultiplied = isAlphaPremultiplied;
        this.transparency = transparency;
        this.transferType = transferType;
    }

    public void finalize() {
    }

    public static ColorModel getRGBdefault() {
        return S_RGB_MODEL;
    }

    public final boolean hasAlpha() {
        return this.hasAlpha;
    }

    public final boolean isAlphaPremultiplied() {
        return this.isAlphaPremultiplied;
    }

    public int getPixelSize() {
        return this.pixel_bits;
    }

    public int getComponentSize(int componentIdx) {
        return this.bits[componentIdx];
    }

    public int[] getComponentSize() {
        return this.bits;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public int getNumComponents() {
        return this.getNumColorComponents() + (this.hasAlpha ? 1 : 0);
    }

    public int getNumColorComponents() {
        return this.cspace.getNumComponents();
    }

    public abstract int getRed(int var1);

    public abstract int getGreen(int var1);

    public abstract int getBlue(int var1);

    public abstract int getAlpha(int var1);

    public int getRGB(int pixel) {
        return (this.getAlpha(pixel) & 0xFF) << 24 | (this.getRed(pixel) & 0xFF) << 16 | (this.getGreen(pixel) & 0xFF) << 8 | (this.getBlue(pixel) & 0xFF) << 0;
    }

    final int getPixelFromArray(Object inData) {
        DataBuffer data = Buffers.createBufferFromData(this.transferType, inData, 1);
        Buffers.getData(data);
        return data.getElem(0);
    }

    public int getRed(Object inData) {
        return this.getRed(this.getPixelFromArray(inData));
    }

    public int getGreen(Object inData) {
        return this.getGreen(this.getPixelFromArray(inData));
    }

    public int getBlue(Object inData) {
        return this.getBlue(this.getPixelFromArray(inData));
    }

    public int getAlpha(Object inData) {
        return this.getAlpha(this.getPixelFromArray(inData));
    }

    public int getRGB(Object inData) {
        return (this.getAlpha(inData) & 0xFF) << 24 | (this.getRed(inData) & 0xFF) << 16 | (this.getGreen(inData) & 0xFF) << 8 | (this.getBlue(inData) & 0xFF) << 0;
    }

    public Object getDataElements(int rgb, Object pixel) {
        throw new UnsupportedOperationException();
    }

    public int[] getComponents(int pixel, int[] components, int offset) {
        throw new UnsupportedOperationException();
    }

    public int[] getComponents(Object pixel, int[] components, int offset) {
        throw new UnsupportedOperationException();
    }

    public int[] getUnnormalizedComponents(float[] normComponents, int normOffset, int[] components, int offset) {
        int numComponents = this.getNumComponents();
        if (components == null) {
            components = new int[offset + numComponents];
        }
        int i = 0;
        while (i < numComponents) {
            float in = normComponents[normOffset++];
            int out = (int)(in * (float)((1 << this.getComponentSize(i)) - 1));
            components[offset++] = out;
            ++i;
        }
        return components;
    }

    public float[] getNormalizedComponents(int[] components, int offset, float[] normComponents, int normOffset) {
        int numComponents = this.getNumComponents();
        if (normComponents == null) {
            normComponents = new float[normOffset + numComponents];
        }
        int i = 0;
        while (i < numComponents) {
            float in = components[offset++];
            float out = in / (float)((1 << this.getComponentSize(i)) - 1);
            normComponents[normOffset++] = out;
            ++i;
        }
        return normComponents;
    }

    public float[] getNormalizedComponents(Object pixel, float[] normComponents, int normOffset) {
        int[] components = this.getComponents(pixel, null, 0);
        return this.getNormalizedComponents(components, 0, normComponents, normOffset);
    }

    public int getDataElement(int[] components, int offset) {
        throw new UnsupportedOperationException();
    }

    public int getDataElement(float[] components, int offset) {
        return this.getDataElement(this.getUnnormalizedComponents(components, offset, null, 0), 0);
    }

    public Object getDataElements(int[] components, int offset, Object obj) {
        throw new UnsupportedOperationException();
    }

    public Object getDataElements(float[] components, int offset, Object obj) {
        return this.getDataElements(this.getUnnormalizedComponents(components, offset, null, 0), 0, obj);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColorModel)) {
            return false;
        }
        ColorModel o = (ColorModel)obj;
        return this.pixel_bits == o.pixel_bits && this.transferType == o.transferType && this.transparency == o.transparency && this.hasAlpha == o.hasAlpha && this.isAlphaPremultiplied == o.isAlphaPremultiplied && Arrays.equals(this.bits, o.bits) && this.cspace.equals(o.cspace);
    }

    public final ColorSpace getColorSpace() {
        return this.cspace;
    }

    public ColorModel coerceData(WritableRaster raster, boolean isAlphaPremultiplied) {
        throw new UnsupportedOperationException();
    }

    protected void coerceDataWorker(WritableRaster raster, boolean isAlphaPremultiplied) {
        int w = raster.getWidth();
        int h = raster.getHeight();
        int x = raster.getMinX();
        int y = raster.getMinY();
        int size = w * h;
        int numColors = this.getNumColorComponents();
        int numComponents = this.getNumComponents();
        int alphaScale = (1 << this.getComponentSize(numColors)) - 1;
        double[] pixels = raster.getPixels(x, y, w, h, (double[])null);
        int i = 0;
        while (i < size) {
            double alpha = pixels[i * numComponents + numColors] / (double)alphaScale;
            int c = 0;
            while (c < numColors) {
                int offset = i * numComponents + c;
                pixels[offset] = isAlphaPremultiplied ? (double)Math.round(pixels[offset] * alpha) : (double)Math.round(pixels[offset] / alpha);
                ++c;
            }
            ++i;
        }
        raster.setPixels(0, 0, w, h, pixels);
    }

    public boolean isCompatibleRaster(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        return this.isCompatibleSampleModel(sampleModel);
    }

    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        return new WritableRaster(this.createCompatibleSampleModel(w, h), new Point(0, 0));
    }

    public SampleModel createCompatibleSampleModel(int w, int h) {
        throw new UnsupportedOperationException();
    }

    public boolean isCompatibleSampleModel(SampleModel sm) {
        return sm.getTransferType() == this.transferType;
    }

    public final int getTransferType() {
        return this.transferType;
    }

    public WritableRaster getAlphaRaster(WritableRaster raster) {
        return null;
    }

    String stringParam() {
        return "pixel_bits=" + this.pixel_bits + ", cspace=" + this.cspace + ", transferType=" + this.transferType + ", transparency=" + this.transparency + ", hasAlpha=" + this.hasAlpha + ", isAlphaPremultiplied=" + this.isAlphaPremultiplied;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.stringParam() + "]";
    }

    private static class SRGBColorModel
    extends DirectColorModel {
        SRGBColorModel() {
            super(32, 0xFF0000, 65280, 255, -16777216);
        }

        public int getAlpha(Object inData) {
            return ((int[])inData)[0] >> 24 & 0xFF;
        }

        public int getBlue(Object inData) {
            return ((int[])inData)[0] & 0xFF;
        }

        public int getGreen(Object inData) {
            return ((int[])inData)[0] >> 8 & 0xFF;
        }

        public int getRed(Object inData) {
            return ((int[])inData)[0] >> 16 & 0xFF;
        }

        public int getRGB(Object inData) {
            return ((int[])inData)[0];
        }

        public Object getDataElements(int rgb, Object pixel) {
            if (pixel == null) {
                pixel = new int[]{rgb};
            } else {
                ((int[])pixel)[0] = rgb;
            }
            return pixel;
        }
    }
}

